/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.ui.ConnectionFactoryManager;
import net.refractions.udig.catalog.ui.UDIGConnectionFactoryDescriptor;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.DataSourceSelectionState;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPage;
import net.refractions.udig.internal.ui.UiPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class DataSourceSelectionPage
extends WorkflowWizardPage
implements ISelectionChangedListener {
    private IStructuredSelection selected;
    private List<UDIGConnectionFactoryDescriptor> descriptors;
    private WizardViewer viewer;

    public DataSourceSelectionPage() {
        super("dataSourceWizardPage");
        this.setTitle(Messages.DataSourceSelectionPage_pageTitle);
        this.setDescription(Messages.DataSourceSelectionPage_defaultMessage);
    }

    public void select(List<String> ids) {
        this.descriptors = ConnectionFactoryManager.instance().getConnectionFactoryDescriptors(ids);
        this.setSelection(this.descriptors);
    }

    public void select(String id) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(id);
        this.select(l);
    }

    public void setSelection(List<UDIGConnectionFactoryDescriptor> descriptors) {
        this.selected = new StructuredSelection(descriptors);
        if (this.viewer != null) {
            if (!this.selected.isEmpty()) {
                this.viewer.setSelection((ISelection)new StructuredSelection(this.selected.getFirstElement()));
            } else {
                this.viewer.setSelection((ISelection)new StructuredSelection());
            }
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        boolean more = super.canFlipToNextPage();
        if (more) {
            if (this.selected != null && this.selected.size() == 1) {
                return true;
            }
            return this.descriptors != null && this.descriptors.size() == 1;
        }
        return false;
    }

    @Override
    public DataSourceSelectionState getState() {
        return (DataSourceSelectionState)super.getState();
    }

    @Override
    public void shown() {
        this.selected = (IStructuredSelection)this.viewer.getSelection();
        this.syncStateWithUI();
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FillLayout());
        DataSourceSelectionState state = this.getState();
        List<UDIGConnectionFactoryDescriptor> descriptorList = state.getShortlist() != null ? state.getShortlist() : this.getDescriptors();
        this.viewer = new WizardViewer(comp, 2052);
        this.viewer.setInput(descriptorList.toArray());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IWizardContainer container = DataSourceSelectionPage.this.getContainer();
                if (container instanceof Dialog) {
                    Dialog d = (Dialog)container;
                    Button button = DataSourceSelectionPage.this.findButton(d.buttonBar, 15);
                    if (button != null) {
                        button.notifyListeners(13, new Event());
                    }
                }
            }
        });
        this.viewer.addSelectionChangedListener(this);
        if (state.getDescriptor() != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)state.getDescriptor()));
        }
        this.setControl((Control)comp);
    }

    protected Button findButton(Control buttonBar, int buttonID) {
        Button button;
        if (buttonBar instanceof Composite) {
            Control[] children;
            Composite composite = (Composite)buttonBar;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Button button2;
                Control control = controlArray[n2];
                if (control instanceof Button ? (Integer)(button2 = (Button)control).getData() == buttonID : control instanceof Composite && (button2 = this.findButton(control, buttonID)) != null) {
                    return button2;
                }
                ++n2;
            }
        }
        if (buttonBar instanceof Button && (Integer)(button = (Button)buttonBar).getData() == buttonID) {
            return button;
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selected = (IStructuredSelection)event.getSelection();
        this.syncStateWithUI();
    }

    private void syncStateWithUI() {
        if (this.selected != null && !this.selected.isEmpty()) {
            UDIGConnectionFactoryDescriptor descriptor = (UDIGConnectionFactoryDescriptor)this.selected.getFirstElement();
            this.setImageDescriptor(descriptor.getDescriptionImage(0));
            this.setMessage(descriptor.getDescription(0));
            DataSourceSelectionState state = this.getState();
            state.setDescriptor(descriptor);
        }
        this.getWizard().getContainer().updateButtons();
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public List<UDIGConnectionFactoryDescriptor> getDescriptors() {
        List<UDIGConnectionFactoryDescriptor> connectionFactoryDescriptors = ConnectionFactoryManager.instance().getConnectionFactoryDescriptors();
        return connectionFactoryDescriptors;
    }

    protected void saveSelectedDescriptor() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
    }

    private static class WizardViewer
    extends TableViewer {
        public WizardViewer(Composite parent, int style) {
            super(parent, style);
            this.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object object) {
                    UDIGConnectionFactoryDescriptor descriptor = (UDIGConnectionFactoryDescriptor)object;
                    return descriptor.getLabel(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Image getImage(Object object) {
                    UDIGConnectionFactoryDescriptor descriptor = (UDIGConnectionFactoryDescriptor)object;
                    String id = descriptor.getId();
                    ImageRegistry registry = UiPlugin.getDefault().getImageRegistry();
                    ImageDescriptor image = descriptor.getImage(0);
                    ImageRegistry imageRegistry = registry;
                    synchronized (imageRegistry) {
                        if (registry.get(id) == null && image != null) {
                            registry.put(id, image);
                        }
                        return registry.get(id);
                    }
                }
            });
        }
    }
}

