/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;
import net.refractions.udig.catalog.ui.UDIGConnectionFactoryDescriptor;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class ConnectionFactoryManager {
    Map<Descriptor<UDIGConnectionFactory>, List<Descriptor<UDIGConnectionPage>>> factoryToPage = new HashMap<Descriptor<UDIGConnectionFactory>, List<Descriptor<UDIGConnectionPage>>>();
    Map<List<Descriptor<UDIGConnectionPage>>, Descriptor<UDIGConnectionFactory>> pageToFactory = new HashMap<List<Descriptor<UDIGConnectionPage>>, Descriptor<UDIGConnectionFactory>>();
    List<UDIGConnectionFactoryDescriptor> descriptors;
    private static ConnectionFactoryManager manager;

    protected ConnectionFactoryManager() {
        IExtension[] extension = Platform.getExtensionRegistry().getExtensionPoint("net.refractions.udig.catalog.ui.connectionFactory").getExtensions();
        Descriptor factory = null;
        ArrayList wizardPages = new ArrayList();
        IExtension[] iExtensionArray = extension;
        int n = extension.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension e = iExtensionArray[n2];
            IConfigurationElement[] elements = e.getConfigurationElements();
            wizardPages = new ArrayList();
            factory = null;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("factory".equals(element.getName())) {
                    factory = new Descriptor("class", element);
                }
                if ("wizardPage".equals(element.getName())) {
                    wizardPages.add(new Descriptor("class", element));
                }
                ++n4;
            }
            if (factory != null) {
                this.factoryToPage.put(factory, wizardPages);
            }
            if (factory != null) {
                this.pageToFactory.put(wizardPages, factory);
            }
            ++n2;
        }
    }

    public static synchronized ConnectionFactoryManager instance() {
        if (manager == null) {
            manager = new ConnectionFactoryManager();
        }
        return manager;
    }

    public List<Descriptor<UDIGConnectionPage>> getPageDescriptor(Descriptor<UDIGConnectionFactory> factory) throws CoreException {
        return this.factoryToPage.get(factory);
    }

    public Collection<List<Descriptor<UDIGConnectionPage>>> getPages() {
        return this.factoryToPage.values();
    }

    public Collection<Descriptor<UDIGConnectionFactory>> getFactories() {
        return this.factoryToPage.keySet();
    }

    public synchronized List<UDIGConnectionFactoryDescriptor> getConnectionFactoryDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new ArrayList<UDIGConnectionFactoryDescriptor>();
            Collection<Descriptor<UDIGConnectionFactory>> factories = this.getFactories();
            for (Descriptor<UDIGConnectionFactory> factoryDescriptor : factories) {
                try {
                    if (this.getPageDescriptor(factoryDescriptor).isEmpty()) continue;
                    this.descriptors.add(new UDIGConnectionFactoryDescriptor(factoryDescriptor));
                }
                catch (CoreException e) {
                    CatalogUIPlugin.log("", e);
                }
            }
            Collections.sort(this.descriptors, new Comparator<UDIGConnectionFactoryDescriptor>(){

                @Override
                public int compare(UDIGConnectionFactoryDescriptor o1, UDIGConnectionFactoryDescriptor o2) {
                    String s1 = o1.getLabel(0);
                    String s2 = o2.getLabel(0);
                    return s1.compareTo(s2);
                }
            });
        }
        return this.descriptors;
    }

    public List<UDIGConnectionFactoryDescriptor> getConnectionFactoryDescriptors(List<String> ids) {
        List<UDIGConnectionFactoryDescriptor> tmp = ConnectionFactoryManager.instance().getConnectionFactoryDescriptors();
        ArrayList<UDIGConnectionFactoryDescriptor> result = new ArrayList<UDIGConnectionFactoryDescriptor>();
        for (UDIGConnectionFactoryDescriptor descriptor : tmp) {
            for (String id : ids) {
                if (!id.equals(descriptor.getId())) continue;
                result.add(descriptor);
            }
        }
        return result;
    }

    public static class Descriptor<T> {
        private IConfigurationElement element;
        private String classAttribute;
        private T instance;

        Descriptor(String classAttribute, IConfigurationElement element) {
            this.classAttribute = classAttribute;
            this.element = element;
        }

        public synchronized T getConcreteInstance() throws CoreException {
            if (this.instance == null) {
                try {
                    this.instance = this.element.createExecutableExtension(this.classAttribute);
                }
                catch (CoreException eek) {
                    if (CatalogPlugin.getDefault().isDebugging()) {
                        String toLoad = this.element.getAttribute(this.classAttribute);
                        System.out.println("Unable to load:" + toLoad + ":" + (Object)((Object)eek));
                    }
                    throw eek;
                }
            }
            return this.instance;
        }

        public IConfigurationElement getConfigurationElement() {
            return this.element;
        }
    }
}

