/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveChangeListener;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.IResolveFolder;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.ui.Identifier;
import net.refractions.udig.core.AbstractUdigUIPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.PlatformUI;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.osgi.framework.BundleContext;

public class CatalogUIPlugin
extends AbstractUdigUIPlugin {
    private static CatalogUIPlugin INSTANCE;
    public static final String ID = "net.refractions.udig.catalog.ui";
    public static final String PREF_OPEN_DIALOG_DIRECTORY = "udig.preferences.openDialog.lastDirectory";
    public static final String ICONS_PATH = "icons/";
    private static final String LABELS_PREFERENCE_STORE = "CATALOG_LABELS_PREFERENCE_STORAGE";

    public CatalogUIPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerChangeListener();
    }

    private void registerChangeListener() {
        CatalogPlugin.addListener((IResolveChangeListener)new IResolveChangeListener(){

            public void changed(IResolveChangeEvent event) {
                if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isClosing()) {
                    return;
                }
                if (event.getType() == IResolveChangeEvent.Type.POST_CHANGE) {
                    event.getDelta();
                }
            }

            private void updateCache(IResolveDelta delta, IPreferenceStore p) {
                if ((delta.getKind() == IResolveDelta.Kind.REPLACED || delta.getKind() == IResolveDelta.Kind.REMOVED || delta.getKind() == IResolveDelta.Kind.CHANGED) && delta.getResolve() != null && delta.getResolve().getIdentifier() != null) {
                    String string = CatalogUIPlugin.LABELS_PREFERENCE_STORE + delta.getResolve().getIdentifier().toString();
                    p.setToDefault(string);
                }
                List children = delta.getChildren();
                for (IResolveDelta delta2 : children) {
                    this.updateCache(delta2, p);
                }
            }
        });
    }

    public static void log(String message2, Throwable t) {
        String message = message2;
        if (message == null) {
            message = "";
        }
        int status = t instanceof Exception || message != null ? 4 : 2;
        CatalogUIPlugin.getDefault().getLog().log((IStatus)new Status(status, ID, 0, message, t));
    }

    public static void trace(String message, Throwable e) {
        if (CatalogUIPlugin.getDefault().isDebugging()) {
            if (message != null) {
                System.out.println(message);
            }
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public static void trace(String message) {
        if (CatalogUIPlugin.getDefault().isDebugging() && message != null) {
            System.out.println(message);
        }
    }

    public static boolean isDebugging(String trace) {
        return CatalogUIPlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)trace));
    }

    public static Image image(IResolve resolve) {
        if (resolve == null) {
            return null;
        }
        if (resolve instanceof IResolveFolder) {
            return CatalogUIPlugin.getDefault().getImage("obj16/mapfolder_obj.gif");
        }
        if (resolve instanceof IGeoResource) {
            IGeoResource resource = (IGeoResource)resolve;
            boolean isFeature = resource.canResolve(FeatureSource.class);
            String iconId = CatalogUIPlugin.iconInternalResource(resource.getID(), isFeature);
            return CatalogUIPlugin.getDefault().getImage(iconId);
        }
        if (resolve instanceof IService) {
            IService service = (IService)resolve;
            boolean isFeature = service.canResolve(DataStore.class);
            String iconId = CatalogUIPlugin.iconInternalService(service.getID(), isFeature);
            return CatalogUIPlugin.getDefault().getImage(iconId);
        }
        if (resolve instanceof ICatalog) {
            return CatalogUIPlugin.getDefault().getImage("obj16/repository_obj.gif");
        }
        return CatalogUIPlugin.getDefault().getImage("obj16/resource_obj.gif");
    }

    public static ImageDescriptor icon(IResolve resolve) throws IOException {
        return CatalogUIPlugin.icon(resolve, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ImageDescriptor icon(final IResolve resolve, IProgressMonitor monitor) throws IOException {
        ImageDescriptor icon;
        ImageDescriptor descriptor;
        if (resolve.canResolve(ImageDescriptor.class) && (descriptor = (ImageDescriptor)resolve.resolve(ImageDescriptor.class, monitor)) != null) {
            return descriptor;
        }
        if (resolve instanceof IGeoResource) {
            icon = CatalogUIPlugin.icon((IGeoResource)resolve, monitor);
            return icon != null ? icon : new ImageDescriptor(){

                public ImageData getImageData() {
                    return CatalogUIPlugin.image(resolve).getImageData();
                }
            };
        }
        if (resolve instanceof IService) {
            icon = CatalogUIPlugin.icon((IService)resolve, monitor);
            if (icon != null) {
                return icon;
            }
            return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/server_obj.gif");
        }
        if (resolve instanceof IResolveFolder) {
            icon = CatalogUIPlugin.icon((IResolveFolder)resolve, monitor);
            return icon != null ? icon : CatalogUIPlugin.getDefault().getImageDescriptor("obj16/mapfolder_obj.gif");
        }
        if (resolve instanceof ICatalog) {
            return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/repository_obj.gif");
        }
        return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/resource_obj.gif");
    }

    private static ImageDescriptor icon(IGeoResource resource, IProgressMonitor monitor) throws IOException {
        ImageDescriptor icon;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (resource.canResolve(ImageDescriptor.class) && (icon = (ImageDescriptor)resource.resolve(ImageDescriptor.class, monitor)) != null) {
            return icon;
        }
        try {
            IGeoResourceInfo info = (IGeoResourceInfo)resource.resolve(IGeoResourceInfo.class, monitor);
            ImageDescriptor icon2 = info.getImageDescriptor();
            if (icon2 != null) {
                return icon2;
            }
        }
        catch (Throwable t) {
            CatalogUIPlugin.log("Error obtaining info", t);
            return null;
        }
        boolean isFeature = resource.canResolve(FeatureSource.class);
        String iconId = CatalogUIPlugin.iconInternalResource(resource.getID(), isFeature);
        return CatalogUIPlugin.getDefault().getImageDescriptor(iconId);
    }

    private static String iconInternalResource(ID id, boolean isFeature) {
        if (Identifier.isGraphic(id.toURL())) {
            return "obj16/graphic_obj.gif";
        }
        if (Identifier.isWMS(id.toURL())) {
            return "obj16/grid_obj.gif";
        }
        if (Identifier.isGraphic(id.toURL())) {
            return "obj16/graphic_obj.gif";
        }
        if (Identifier.isMemory(id.toURL())) {
            return "obj16/memory_obj.gif";
        }
        if (isFeature) {
            return "obj16/feature_obj.gif";
        }
        return "obj16/grid_obj.gif";
    }

    private static ImageDescriptor icon(IResolveFolder folder, IProgressMonitor monitor) throws IOException {
        ImageDescriptor icon;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (folder.canResolve(ImageDescriptor.class) && (icon = (ImageDescriptor)folder.resolve(ImageDescriptor.class, monitor)) != null) {
            return icon;
        }
        return CatalogUIPlugin.getDefault().getImageDescriptor("obj16/mapfolder_obj.gif");
    }

    private static ImageDescriptor icon(IService service, IProgressMonitor monitor) throws IOException {
        ImageDescriptor icon;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (service.canResolve(ImageDescriptor.class) && (icon = (ImageDescriptor)service.resolve(ImageDescriptor.class, monitor)) != null) {
            return icon;
        }
        try {
            ImageDescriptor icon2;
            IServiceInfo info = (IServiceInfo)service.resolve(IServiceInfo.class, monitor);
            if (info != null && (icon2 = info.getImageDescriptor()) != null) {
                return icon2;
            }
        }
        catch (Throwable t) {
            CatalogUIPlugin.log("Error obtaining info", t);
            return null;
        }
        boolean isFeature = service.canResolve(DataStore.class);
        String iconId = CatalogUIPlugin.iconInternalService(service.getID(), isFeature);
        return CatalogUIPlugin.getDefault().getImageDescriptor(iconId);
    }

    private static String iconInternalService(ID id, boolean isFeature) {
        URL url = id.toURL();
        if (Identifier.isFile(url)) {
            if (isFeature) {
                return "obj16/feature_file_obj.gif";
            }
            return "obj16/grid_file_obj.gif";
        }
        if (Identifier.isGraphic(url)) {
            return "obj16/map_graphics_obj.gif";
        }
        if (Identifier.isWMS(url)) {
            return "obj16/wms_obj.gif";
        }
        if (Identifier.isWFS(url)) {
            return "obj16/wfs_obj.gif";
        }
        if (Identifier.isJDBC(url)) {
            return "obj16/database_obj.gif";
        }
        if (isFeature) {
            return "obj16/datastore_obj.gif";
        }
        return "obj16/server_obj.gif";
    }

    public IPath getIconPath() {
        return new Path(ICONS_PATH);
    }

    public static CatalogUIPlugin getDefault() {
        return INSTANCE;
    }
}

