/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.ui.CatalogViewerSorter;
import net.refractions.udig.catalog.ui.IMessageBoard;
import net.refractions.udig.catalog.ui.ResolveContentProvider;
import net.refractions.udig.catalog.ui.ResolveLabelProviderSimple;
import net.refractions.udig.catalog.ui.ResolveTitlesDecorator;
import net.refractions.udig.catalog.ui.internal.Messages;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public class CatalogTreeViewer
extends TreeViewer
implements ISelectionChangedListener {
    private IMessageBoard messageBoard;

    public CatalogTreeViewer(Composite parent, boolean titles) {
        this(parent, 2818, titles);
    }

    public CatalogTreeViewer(Composite parent) {
        this(parent, true);
    }

    public CatalogTreeViewer(Composite parent, int style, boolean titles) {
        super(parent, style | 0x10000000);
        this.setContentProvider((IContentProvider)new ResolveContentProvider());
        ResolveLabelProviderSimple resolveLabelProviderSimple = new ResolveLabelProviderSimple();
        if (titles) {
            this.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)resolveLabelProviderSimple, (ILabelDecorator)new ResolveTitlesDecorator(resolveLabelProviderSimple)));
        } else {
            this.setLabelProvider((IBaseLabelProvider)resolveLabelProviderSimple);
        }
        this.setUseHashlookup(true);
        this.setInput(CatalogPlugin.getDefault().getLocalCatalog());
        this.setSorter(new CatalogViewerSorter());
        this.addSelectionChangedListener(this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.messageBoard == null) {
            return;
        }
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            if (sel.size() == 1) {
                Object obj = sel.getFirstElement();
                if (obj instanceof IResolve) {
                    IResolve resolve = (IResolve)obj;
                    if (resolve.getStatus() == IResolve.Status.BROKEN) {
                        if (resolve.getMessage() == null) {
                            this.messageBoard.putMessage(Messages.CatalogTreeViewer_broken, IMessageBoard.Type.ERROR);
                        } else {
                            this.messageBoard.putMessage(resolve.getMessage().getLocalizedMessage(), IMessageBoard.Type.ERROR);
                        }
                    } else if (resolve.getStatus() == IResolve.Status.RESTRICTED_ACCESS) {
                        this.messageBoard.putMessage(Messages.CatalogTreeViewer_permission, IMessageBoard.Type.ERROR);
                    } else {
                        this.messageBoard.putMessage(null, IMessageBoard.Type.NORMAL);
                    }
                } else {
                    this.messageBoard.putMessage(null, IMessageBoard.Type.NORMAL);
                }
            } else {
                this.messageBoard.putMessage(null, IMessageBoard.Type.NORMAL);
            }
        } else {
            this.messageBoard.putMessage(null, IMessageBoard.Type.NORMAL);
        }
    }

    public void setMessageBoard(IMessageBoard messageBoard) {
        this.messageBoard = messageBoard;
    }
}

