/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import net.refractions.udig.catalog.ui.workflow.EndConnectionState;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;

public abstract class AbstractUDIGImportPage
extends WorkflowWizardPage
implements UDIGConnectionPage {
    public AbstractUDIGImportPage(String pageName) {
        super(pageName);
    }

    public void setMessage(String newMessage, int newType) {
        super.setMessage(newMessage, newType);
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page != this && page instanceof WizardPage) {
            ((WizardPage)page).setMessage(newMessage, newType);
        } else {
            CatalogUIPlugin.log("A WizardPage was expected but instead was a " + page.getClass().getName(), new Exception());
        }
    }

    @Override
    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page != this && page instanceof WizardPage) {
            ((WizardPage)page).setErrorMessage(newMessage);
        } else {
            CatalogUIPlugin.log("A WizardPage was expected but instead was a " + page.getClass().getName(), new Exception());
        }
    }

    public final IWizardPage getNextPage() {
        return super.getNextPage();
    }

    @Override
    public boolean leavingPage() {
        return true;
    }

    @Override
    public Collection<URL> getResourceIDs() {
        return Collections.emptySet();
    }

    @Override
    public Collection<IService> getServices() {
        final Map<String, Serializable> params = this.getParams();
        final HashSet<IService> services = new HashSet<IService>();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                Collection<IService> newServices = EndConnectionState.constructServices(monitor, params, new HashSet<URL>());
                services.addAll(newServices);
            }
        };
        try {
            this.getContainer().run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage("Could not connect:" + e.getCause().getMessage());
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (InterruptedException e) {
            this.setErrorMessage("Canceled");
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        if (!services.isEmpty()) {
            return services;
        }
        return services;
    }

    @Override
    public Map<String, Serializable> getParams() {
        return null;
    }

    public void dispose() {
        super.dispose();
        this.setControl(null);
    }
}

