/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveChangeListener;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.PlatformUI;

public class AbstractResolveContentProvider
implements IResolveChangeListener {
    Map<IResolve, Thread> threadFarm = new IdentityHashMap<IResolve, Thread>();
    protected final Map<IResolve, List<IResolve>> structure = new IdentityHashMap<IResolve, List<IResolve>>();
    protected ICatalog catalog;
    protected List<IResolve> list;
    protected Viewer viewer;

    public void changed(IResolveChangeEvent event) {
        if (this.threadFarm == null) {
            if (this.catalog != null) {
                this.catalog.removeCatalogListener((IResolveChangeListener)this);
            }
            return;
        }
        if (event.getType() != IResolveChangeEvent.Type.POST_CHANGE) {
            return;
        }
        IResolve resolve = event.getResolve();
        if (this.threadFarm.containsKey(resolve)) {
            this.update(resolve);
        }
    }

    public void refresh(final IResolve resolve) {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        Runnable object = new Runnable(){

            @Override
            public void run() {
                if (AbstractResolveContentProvider.this.viewer instanceof TreeViewer) {
                    TreeViewer treeViewer = (TreeViewer)AbstractResolveContentProvider.this.viewer;
                    treeViewer.refresh((Object)resolve, true);
                } else {
                    AbstractResolveContentProvider.this.viewer.refresh();
                }
            }
        };
        PlatformGIS.asyncInDisplayThread((Runnable)object, (boolean)true);
    }

    public void update(IResolve resolve) {
        if (resolve == null) {
            return;
        }
        resolve.getIdentifier();
        if (this.threadFarm.containsKey(resolve)) {
            Thread update = this.threadFarm.get(resolve);
            if (!update.isAlive()) {
                update.interrupt();
                update = new Thread((Runnable)new Update(resolve), "Update " + resolve.getIdentifier());
                this.threadFarm.put(resolve, update);
                update.setPriority(1);
                update.start();
            }
        } else {
            Thread update = new Thread((Runnable)new Update(resolve), "Update " + resolve.getIdentifier());
            this.threadFarm.put(resolve, update);
            update.setPriority(1);
            update.start();
        }
    }

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        if (oldInput == newInput) {
            return;
        }
        this.viewer = newViewer;
        if (this.catalog != null || this.list != null) {
            CatalogPlugin.removeListener((IResolveChangeListener)this);
        }
        this.catalog = newInput instanceof ICatalog ? (ICatalog)newInput : null;
        List list = this.list = newInput instanceof List ? (List)newInput : null;
        if (this.catalog != null || this.list != null) {
            CatalogPlugin.addListener((IResolveChangeListener)this);
        }
    }

    public void dispose() {
        if (this.threadFarm != null) {
            for (IResolve resolve : this.threadFarm.keySet()) {
                Thread thread = this.threadFarm.get(resolve);
                if (thread == null || !thread.isAlive()) continue;
                thread.interrupt();
            }
            if (this.catalog != null) {
                this.catalog.removeCatalogListener((IResolveChangeListener)this);
            }
            CatalogPlugin.getDefault().getLocalCatalog().removeCatalogListener((IResolveChangeListener)this);
            this.threadFarm.clear();
            this.threadFarm = null;
        }
        if (this.structure != null) {
            for (IResolve resolve : this.structure.keySet()) {
                List<IResolve> children = this.structure.get(resolve);
                if (children == null) continue;
                children.clear();
            }
            this.structure.clear();
        }
    }

    class Update
    implements Runnable {
        IResolve resolve;

        Update(IResolve target) {
            this.resolve = target;
        }

        @Override
        public void run() {
            try {
                try {
                    ArrayList members = new ArrayList(this.resolve.members(null));
                    AbstractResolveContentProvider.this.structure.put(this.resolve, members);
                }
                catch (IOException io) {
                    io.printStackTrace();
                    AbstractResolveContentProvider.this.structure.put(this.resolve, null);
                }
                AbstractResolveContentProvider.this.refresh(this.resolve);
            }
            catch (Throwable t) {
                CatalogUIPlugin.trace(this.resolve.getIdentifier() + ": " + t, t);
            }
        }
    }
}

