/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.service.database;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.service.database.DataConnectionPage;
import net.refractions.udig.catalog.service.database.DatabaseConnectionRunnable;
import net.refractions.udig.catalog.service.database.DatabaseWizardLocalization;
import net.refractions.udig.catalog.service.database.ExtraParams;
import net.refractions.udig.catalog.service.database.ExtraParamsControl;
import net.refractions.udig.catalog.service.database.LookUpSchemaRunnable;
import net.refractions.udig.catalog.service.database.Tab;
import net.refractions.udig.catalog.service.database.TableBasedExtraParamsControl;
import net.refractions.udig.catalog.service.database.TableDescriptor;
import net.refractions.udig.core.internal.CorePlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.geotools.data.DataAccessFactory;

public abstract class DatabaseServiceDialect {
    public final DataAccessFactory.Param schemaParam;
    public final DataAccessFactory.Param databaseParam;
    public final DataAccessFactory.Param hostParam;
    public final DataAccessFactory.Param portParam;
    public final DataAccessFactory.Param usernameParam;
    public final DataAccessFactory.Param passwordParam;
    public final DataAccessFactory.Param typeParam;
    public final String dbType;
    public final String urlPrefix;
    public final DatabaseWizardLocalization localization;

    public DatabaseServiceDialect(DataAccessFactory.Param schemaParam, DataAccessFactory.Param databaseParam, DataAccessFactory.Param hostParam, DataAccessFactory.Param portParam, DataAccessFactory.Param usernameParam, DataAccessFactory.Param passwordParam, DataAccessFactory.Param typeParam, String dbType, String urlPrefix, DatabaseWizardLocalization localization) {
        this.schemaParam = schemaParam;
        this.databaseParam = databaseParam;
        this.hostParam = hostParam;
        this.portParam = portParam;
        this.usernameParam = usernameParam;
        this.passwordParam = passwordParam;
        this.typeParam = typeParam;
        this.dbType = dbType != null ? dbType : (String)typeParam.sample;
        this.urlPrefix = urlPrefix;
        this.localization = localization;
    }

    public Collection<URL> constructResourceIDs(TableDescriptor[] descriptors, Map<String, Serializable> params) {
        try {
            URL url = this.toURL(params);
            String serviceURL = url.toExternalForm();
            ArrayList<URL> urls = new ArrayList<URL>();
            int i = 0;
            while (i < descriptors.length) {
                TableDescriptor descriptor = descriptors[i];
                urls.add(new URL(url, String.valueOf(serviceURL) + "#" + descriptor.name));
                ++i;
            }
            return urls;
        }
        catch (MalformedURLException e) {
            this.log("Can't make URL", e);
            return Collections.emptySet();
        }
    }

    public URL toURL(Map<String, Serializable> params) throws MalformedURLException {
        String the_host = (String)((Object)params.get(this.hostParam.key));
        Integer intPort = (Integer)params.get(this.portParam.key);
        String the_database = (String)((Object)params.get(this.databaseParam.key));
        String the_username = (String)((Object)params.get(this.usernameParam.key));
        URL toURL = this.toURL(the_username, the_host, intPort, the_database);
        return toURL;
    }

    public URL toURL(String the_username, String the_host, Integer intPort, String the_database) throws MalformedURLException {
        String the_spec = String.valueOf(this.urlPrefix) + "://" + the_username + "@" + the_host + ":" + intPort + "/" + the_database;
        return this.toURL(the_spec);
    }

    public URL toURL(String the_spec) throws MalformedURLException {
        return new URL(null, the_spec, CorePlugin.RELAXED_HANDLER);
    }

    public abstract IDialogSettings getDialogSetting();

    public abstract void log(String var1, Throwable var2);

    public abstract DatabaseConnectionRunnable createDatabaseConnectionRunnable(String var1, int var2, String var3, String var4);

    public Map<Control, Tab> createOptionConnectionPageTabs(TabFolder tabFolder, DataConnectionPage containingPage) {
        return new HashMap<Control, Tab>();
    }

    public abstract LookUpSchemaRunnable createLookupSchemaRunnable(String var1, int var2, String var3, String var4, String var5);

    public Class<? extends Geometry> toGeomClass(String geomName) {
        if (geomName.equals("GEOMETRYCOLLECTION") || geomName.equals("GEOMETRY")) {
            return Geometry.class;
        }
        if (geomName.equals("POINT")) {
            return Point.class;
        }
        if (geomName.equals("MULTIPOINT")) {
            return MultiPoint.class;
        }
        if (geomName.equals("POLYGON")) {
            return Polygon.class;
        }
        if (geomName.equals("MULTIPOLYGON")) {
            return MultiPolygon.class;
        }
        if (geomName.equals("LINESTRING")) {
            return LineString.class;
        }
        if (geomName.equals("MULTILINESTRING")) {
            return MultiLineString.class;
        }
        return Geometry.class;
    }

    protected ExtraParamsControl createHostPageExtraParamControl() {
        List<ExtraParams> params = this.hostPageExtraParams();
        if (params == null || params.isEmpty()) {
            return null;
        }
        return new TableBasedExtraParamsControl(params);
    }

    protected List<ExtraParams> hostPageExtraParams() {
        return Collections.emptyList();
    }
}

