/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.ui.ops;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.ui.actions.ResetService;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.ui.FeatureTypeEditorDialog;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

public class NewFeatureTypeOp
implements IOp {
    private boolean testing;
    private boolean error = false;

    public void op(final Display display, Object target, IProgressMonitor monitor) throws Exception {
        IService service = (IService)target;
        final DataStore ds = (DataStore)service.resolve(DataStore.class, monitor);
        if (!(ds instanceof ShapefileDataStore)) {
            try {
                ds.createSchema(null);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (this.testing) {
                    this.error = true;
                    return;
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)display.getActiveShell(), (String)Messages.NewFeatureTypeOp_title, (String)Messages.NewFeatureTypeOp_message);
                    }
                });
                return;
            }
            catch (Exception exception) {}
        }
        SimpleFeatureType[] featureType = new SimpleFeatureType[1];
        if (!this.testing) {
            final FeatureTypeEditorDialog[] dialog = new FeatureTypeEditorDialog[1];
            PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    dialog[0] = new FeatureTypeEditorDialog(display.getActiveShell(), new FeatureTypeEditorDialog.ValidateFeatureType(){

                        public String validate(SimpleFeatureType featureBuilder) {
                            return null;
                        }
                    });
                }
            });
            int code = -1;
            do {
                featureType[0] = (code = this.openDialog(display, dialog[0], ds)) == 1 ? null : dialog[0].getFeatureType(true);
            } while (featureType[0] == null && code == 0);
        } else {
            featureType[0] = DataUtilities.createType((String)"TestName", (String)"Geom:MultiLineString");
        }
        if (featureType[0] == null) {
            return;
        }
        try {
            if (ds instanceof ShapefileDataStore) {
                this.createShapefile(display, monitor, featureType[0], service.getIdentifier());
            } else {
                ds.createSchema((FeatureType)featureType[0]);
                long start = System.currentTimeMillis();
                while (!Arrays.asList(ds.getTypeNames()).contains(featureType[0].getName().getLocalPart()) && start + 5000L > System.currentTimeMillis()) {
                    Thread.sleep(300L);
                }
                ResetService.reset(Collections.singletonList(service), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            }
        }
        catch (IOException e) {
            CatalogUIPlugin.log("Error creating feature type in datastore: " + ds.getClass(), e);
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.NewFeatureTypeOp_0, (String)(String.valueOf(Messages.NewFeatureTypeOp_1) + Messages.NewFeatureTypeOp_2 + ds.getClass().getSimpleName()));
                }
            });
            return;
        }
    }

    private void createShapefile(final Display display, IProgressMonitor monitor, SimpleFeatureType type, URL oldID) throws MalformedURLException, IOException {
        File file;
        if (!oldID.getProtocol().equals("file")) {
            try {
                file = new File(String.valueOf(FileLocator.toFileURL((URL)Platform.getInstanceLocation().getURL()).getFile()) + type.getName().getLocalPart() + ".shp");
            }
            catch (IOException iOException) {
                file = new File(String.valueOf(System.getProperty("java.user")) + type.getName().getLocalPart() + ".shp");
            }
            final File f = file;
            if (!this.testing) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)display.getActiveShell(), (String)Messages.NewFeatureTypeOp_shpTitle, (String)(String.valueOf(Messages.NewFeatureTypeOp_shpMessage) + f.toString()));
                    }
                });
            }
        } else {
            String s;
            int lastIndexOf = (s = new File(oldID.getFile()).toString()).lastIndexOf(".shp");
            s = s.substring(0, lastIndexOf == -1 ? s.length() : lastIndexOf + 1);
            lastIndexOf = s.lastIndexOf(File.separator);
            s = s.substring(0, lastIndexOf == -1 ? s.length() : lastIndexOf + 1);
            file = new File(String.valueOf(s) + type.getName().getLocalPart() + ".shp");
        }
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
        params.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, Boolean.valueOf(true));
        DataStore ds = factory.createDataStore(params);
        ds.createSchema((FeatureType)type);
        List service = CatalogPlugin.getDefault().getServiceFactory().createService(file.toURI().toURL());
        for (IService service2 : service) {
            try {
                if (!(service2.resolve(DataStore.class, monitor) instanceof ShapefileDataStore)) continue;
                CatalogPlugin.getDefault().getLocalCatalog().add(service2);
            }
            catch (Exception exception) {}
        }
    }

    private int openDialog(Display display, final FeatureTypeEditorDialog dialog, final DataStore dataStore) {
        final int[] code = new int[1];
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                dialog.setDataStore(dataStore);
                dialog.setBlockOnOpen(true);
                code[0] = dialog.open();
            }
        });
        return code[0];
    }

    public void testingSetTesting(boolean b) {
        this.testing = b;
    }

    public boolean testingIsError() {
        return this.error;
    }
}

