/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class ResetService
extends ActionDelegate {
    IStructuredSelection current;

    public void run(IAction action) {
        if (this.current == null) {
            return;
        }
        PlatformGIS.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                CatalogUIPlugin.log("Error resetting: " + ResetService.this.current, exception);
            }

            public void run() throws Exception {
                ArrayList<IService> servers = new ArrayList<IService>();
                Iterator selection = ResetService.this.current.iterator();
                while (selection.hasNext()) {
                    try {
                        servers.add((IService)selection.next());
                    }
                    catch (ClassCastException huh) {
                        CatalogUIPlugin.trace("Should not happen: " + huh);
                    }
                }
                ResetService.reset(servers, null);
            }
        });
    }

    public static void reset(List<IService> servers, IProgressMonitor monitor) {
        IServiceFactory serviceFactory = CatalogPlugin.getDefault().getServiceFactory();
        ICatalog catalog = CatalogPlugin.getDefault().getLocalCatalog();
        for (IService original : servers) {
            try {
                ID id = original.getID();
                CatalogUIPlugin.trace("Reset service " + original.getIdentifier());
                Map connectionParams = original.getConnectionParams();
                IService replacement = null;
                for (IService candidate : serviceFactory.createService(connectionParams)) {
                    try {
                        CatalogUIPlugin.trace(id + " : connecting");
                        IServiceInfo info = candidate.getInfo(monitor);
                        CatalogUIPlugin.trace(id + " : found " + info.getTitle());
                        replacement = candidate;
                        break;
                    }
                    catch (Throwable t) {
                        CatalogUIPlugin.trace(id + " : ... " + t.getLocalizedMessage());
                    }
                }
                if (replacement == null) {
                    CatalogUIPlugin.log("Could not reset " + id + " - as we could not connect!", null);
                    continue;
                }
                catalog.replace(id, replacement);
            }
            catch (Throwable failed) {
                CatalogUIPlugin.log("Reset failed", failed);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            this.current = (IStructuredSelection)selection;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

