/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.ui.actions;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;
import net.refractions.udig.catalog.ui.wizard.CatalogImport;
import net.refractions.udig.core.internal.CorePlugin;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.IDropAction;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;

public class CatalogImportDropAction
extends IDropAction {
    PageProcessor p;

    public boolean accept() {
        Object data = this.getData();
        if (data.getClass().isArray()) {
            Object[] objects;
            Object[] objectArray = objects = (Object[])data;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (this.canAccept(object)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (this.canAccept(data)) {
            return true;
        }
        return this.canAccept(data);
    }

    private boolean canAccept(Object data) {
        if (data instanceof IResolve) {
            IResolve resolve = (IResolve)data;
            List find = CatalogPlugin.getDefault().getLocalCatalog().find(resolve.getIdentifier(), (IProgressMonitor)new NullProgressMonitor());
            if (find != null && !find.isEmpty()) {
                return false;
            }
            return this.canImport(data);
        }
        return this.canImport(data);
    }

    protected boolean canImport(Object data1) {
        URL url;
        Object data = data1;
        if (this.getData() instanceof String && (url = this.extractURL((String)this.getData())) != null) {
            data = url;
        }
        this.p = new PageProcessor(data);
        ExtensionPointUtil.process((Plugin)CatalogUIPlugin.getDefault(), (String)"net.refractions.udig.catalog.ui.connectionFactory", (ExtensionPointProcessor)this.p);
        Set<String> found = this.p.ids;
        return !found.isEmpty();
    }

    public void perform(IProgressMonitor monitor) {
        Object data = this.getData();
        if (data.getClass().isArray()) {
            Object[] array;
            Object[] objectArray = array = (Object[])data;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (this.canAccept(object)) {
                    this.doImportSingleItem(monitor, object);
                }
                ++n2;
            }
        } else {
            this.doImportSingleItem(monitor, data);
        }
    }

    private void doImportSingleItem(IProgressMonitor monitor, Object data) {
        URL url;
        if (data instanceof String && (url = this.extractURL((String)data)) != null) {
            data = url;
        }
        CatalogImport catalogImport = new CatalogImport();
        catalogImport.run(monitor, data);
    }

    protected URL extractURL(String data) {
        String decoded = data;
        try {
            decoded = URLDecoder.decode(decoded, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        decoded = decoded.replaceAll("amp;", "&");
        URL result = null;
        String line = decoded.replace("\\S+", "");
        result = this.matchAnchorTag(line);
        if (result != null) {
            return this.formatFileURL(result);
        }
        result = this.matchGotoTag(line);
        if (result != null) {
            return this.formatFileURL(result);
        }
        if ((result = this.matchHttpTag(result, line)) != null) {
            return this.formatFileURL(result);
        }
        try {
            result = new URL(line);
        }
        catch (MalformedURLException malformedURLException) {}
        if (result == null && !line.contains(":/")) {
            result = URLUtils.fileToURL((File)new File(line));
        }
        if (result == null) {
            try {
                result = new URL(null, line, CorePlugin.RELAXED_HANDLER);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return this.formatFileURL(result);
    }

    private URL formatFileURL(URL result) {
        if (result != null && result.getProtocol().equalsIgnoreCase("file")) {
            try {
                return new URL(result.toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                return result;
            }
        }
        return result;
    }

    private URL matchHttpTag(URL result, String line) {
        Pattern urlPattern = Pattern.compile("([hH][Tt][Tt][Pp]\\S*)");
        Matcher urlMatcher = urlPattern.matcher(line);
        if (urlMatcher.find()) {
            String group = urlMatcher.group(1);
            try {
                int index = group.indexOf(34);
                if (index != -1) {
                    group = group.substring(0, index);
                }
                if ((index = group.indexOf(62)) != -1) {
                    group = group.substring(0, index);
                }
                result = new URL(group);
            }
            catch (MalformedURLException e) {
                UiPlugin.trace((String)"net.refractions.udig.ui/debug/dnd", CatalogImportDropAction.class, (String)("failure to create url from " + group), (Throwable)e);
            }
        }
        return result;
    }

    private URL matchGotoTag(String line) {
        Pattern anchorPattern = Pattern.compile("goto=(\\S+)");
        Matcher anchorMatcher = anchorPattern.matcher(line);
        URL result = null;
        if (anchorMatcher.find()) {
            try {
                String group = anchorMatcher.group(1);
                int index = group.indexOf("\"");
                if (index == -1) {
                    index = group.length();
                }
                result = new URL(group.substring(0, index));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private URL matchAnchorTag(String line) {
        Pattern anchorPattern = Pattern.compile("<a.*href=\"(\\S+)\"\\S*");
        Matcher anchorMatcher = anchorPattern.matcher(line);
        URL result = null;
        if (anchorMatcher.find()) {
            try {
                String group = anchorMatcher.group(1);
                int index = group.indexOf("\"");
                if (index == -1) {
                    index = group.length();
                }
                result = new URL(group.substring(0, index));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    static class PageProcessor
    implements ExtensionPointProcessor {
        Object data;
        Set<String> ids = new LinkedHashSet<String>();

        PageProcessor(Object data) {
            this.data = data;
        }

        public void process(IExtension extension, IConfigurationElement element) throws Exception {
            try {
                if (!"factory".equals(element.getName())) {
                    return;
                }
                UDIGConnectionFactory factory = (UDIGConnectionFactory)element.createExecutableExtension("class");
                if (factory.canProcess(this.data)) {
                    IConfigurationElement[] elements = extension.getConfigurationElements();
                    int i = 0;
                    while (i < elements.length) {
                        if (elements[i].getAttribute("id") != null) {
                            this.ids.add(elements[i].getAttribute("id"));
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable t) {
                String msg = "Error processing wizard page";
                CatalogPlugin.log((String)msg, (Throwable)t);
            }
        }
    }
}

