/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.ui;

import java.lang.reflect.InvocationTargetException;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WorkflowWizardDialogDecorator
implements IWizardContainer {
    private WizardDialog container;

    public WorkflowWizardDialogDecorator(WizardDialog container) {
        this.container = container;
    }

    public IWizardPage getCurrentPage() {
        return this.container.getCurrentPage();
    }

    public Shell getShell() {
        return this.container.getShell();
    }

    public void showPage(IWizardPage page) {
        this.container.showPage(page);
    }

    public void updateButtons() {
        this.container.updateButtons();
    }

    public void updateMessage() {
        this.container.updateMessage();
    }

    public void updateTitleBar() {
        this.container.updateTitleBar();
    }

    public void updateWindowTitle() {
        this.container.updateWindowTitle();
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress request) throws InvocationTargetException, InterruptedException {
        ProgressMonitorPart progressMonitor = this.getProgressMonitor(this.getShell().getChildren());
        if (progressMonitor instanceof ProgressMonitorPart) {
            ProgressMonitorPart part = progressMonitor;
            if (Display.getCurrent() != null) {
                part.setVisible(true);
            }
            try {
                this.setEnablement(this.container.buttonBar, false);
                if (fork) {
                    PlatformGIS.run((IRunnableWithProgress)request, (IProgressMonitor)part);
                }
                PlatformGIS.runBlockingOperation((IRunnableWithProgress)request, (IProgressMonitor)part);
            }
            finally {
                this.setEnablement(this.container.buttonBar, true);
                if (Display.getCurrent() != null && !part.isDisposed()) {
                    part.setVisible(false);
                }
            }
        } else if (fork) {
            PlatformGIS.run((IRunnableWithProgress)request);
        } else {
            PlatformGIS.runBlockingOperation((IRunnableWithProgress)request, (IProgressMonitor)ProgressManager.instance().get(new Object[0]));
        }
    }

    protected ProgressMonitorPart getProgressMonitor(Control[] controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                Control[] children = ((Composite)control).getChildren();
                ProgressMonitorPart found = this.getProgressMonitor(children);
                if (found != null) {
                    return found;
                }
            } else if (control instanceof ProgressMonitorPart) {
                return (ProgressMonitorPart)control;
            }
            ++n2;
        }
        return null;
    }

    private void setEnablement(Control controlA, boolean enabled) {
        Composite buttonBar = (Composite)this.container.buttonBar;
        if (controlA == null) {
            return;
        }
        if (controlA instanceof Composite) {
            Control[] children;
            Composite composite = (Composite)controlA;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                this.setEnablement(control, enabled);
                ++n2;
            }
        } else if (controlA != this.getButton(buttonBar, 1)) {
            controlA.setEnabled(enabled);
        }
    }

    private Button getButton(Composite buttonBar, int id) {
        Control[] children;
        Control[] controlArray = children = buttonBar.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                Button button = this.getButton((Composite)control, id);
                if (button != null) {
                    return button;
                }
            } else if (control instanceof Button && control.getData().equals(id)) {
                return (Button)control;
            }
            ++n2;
        }
        return null;
    }
}

