/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.ui;

import java.io.IOException;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.ui.ImageCache;
import net.refractions.udig.ui.OverlayCache;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class ServiceDecorator
implements ILabelDecorator {
    protected ImageCache imageCache;
    protected OverlayCache overlayCache = new OverlayCache();

    public ServiceDecorator() {
        this.imageCache = new ImageCache();
    }

    public Image decorateImage(Image image, Object element) {
        if (!(element instanceof IService)) {
            return null;
        }
        IService service = (IService)element;
        if (image == null) {
            image = this.baseIcon(service);
        }
        switch (service.getStatus()) {
            case CONNECTED: {
                return this.overlayCache.applyStatus(image, CatalogUIPlugin.getDefault().getImageDescriptor("ovr16/connected_ovr.gif"));
            }
            case NOTCONNECTED: {
                return this.overlayCache.applyStatus(image, CatalogUIPlugin.getDefault().getImageDescriptor("ovr16/wait_ovr.gif"));
            }
            case BROKEN: {
                return this.overlayCache.applyStatus(image, CatalogUIPlugin.getDefault().getImageDescriptor("ovr16/error_ovr.gif"));
            }
        }
        return image;
    }

    Image baseIcon(IService service) {
        ImageDescriptor icon = null;
        try {
            icon = service.getInfo(null).getImageDescriptor();
        }
        catch (IOException e) {
            CatalogUIPlugin.log(null, e);
        }
        if (icon == null) {
            return CatalogUIPlugin.image((IResolve)service);
        }
        return this.imageCache.getImage(icon);
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.overlayCache.disposeAll();
        this.imageCache.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return element instanceof IService && ("status".equals(property) || "metadata".equals(property));
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

