/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.ui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveFolder;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.ResolveLabelProviderSimple;
import net.refractions.udig.catalog.ui.ResolveTitlesDecorator;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.ResourceSelectionState;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ResourceSelectionPage
extends WorkflowWizardPage
implements IPageChangedListener {
    private Map<IResolve, List<IResolve>> resolveMap = new HashMap<IResolve, List<IResolve>>();
    private CheckboxTreeViewer viewer;
    private ResolveTitlesDecorator titleDecorator;
    private boolean collapseCheckedInput = false;
    private List<Object> grayedElements = new ArrayList<Object>();
    private Label label;
    private String schemaSelected;

    public ResourceSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.ResourceSelectionPage_title);
        this.setMessage(Messages.ResourceSelectionPage_message);
        this.setDescription(Messages.ResourceSelectionPage_description);
        this.setImageDescriptor(CatalogUIPlugin.getDefault().getImageDescriptor("wizban/chooselayer_wiz.gif"));
        this.schemaSelected = null;
    }

    public void setResources(List<IResolve> serviceList, IProgressMonitor monitor) {
    }

    public void dispose() {
        super.dispose();
        if (this.viewer == null) {
            return;
        }
        if (this.viewer.getContentProvider() != null) {
            this.viewer.getContentProvider().dispose();
        }
        if (this.viewer.getLabelProvider() != null) {
            this.viewer.getLabelProvider().dispose();
        }
    }

    private List<IResolve> getGeoResources(final IResolve resolve, boolean fork) {
        if (this.resolveMap.get(resolve) == null || this.resolveMap.isEmpty()) {
            final ArrayList list = new ArrayList();
            try {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.ResourceSelectionPage_searching, -1);
                        try {
                            List members = resolve.members(monitor);
                            list.addAll(members);
                            if (ResourceSelectionPage.this.schemaSelected != null) {
                                for (IResolve resolve2 : members) {
                                    IResolveFolder folder = (IResolveFolder)resolve2;
                                    if (folder.getTitle() == ResourceSelectionPage.this.schemaSelected) continue;
                                    list.remove(resolve2);
                                }
                            }
                        }
                        catch (Exception e) {
                            CatalogUIPlugin.log("Error finding resources", e);
                        }
                        monitor.done();
                    }
                };
                if (fork) {
                    this.getContainer().run(false, true, runnable);
                } else {
                    runnable.run((IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                CatalogUIPlugin.log("", e);
            }
            this.resolveMap.put(resolve, list);
        }
        return this.resolveMap.get(resolve);
    }

    public List<Object> getCheckedElements() {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IGeoResource) {
                IGeoResource resource = (IGeoResource)object;
                list.add(resource);
            }
            ++n2;
        }
        return list;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.viewer = new CheckboxTreeViewer(composite);
        this.viewer.setSorter(null);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceSelectionPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.viewer.addCheckStateListener((ICheckStateListener)new ResourceSelectionPageCheckStateListener());
        this.viewer.setContentProvider((IContentProvider)new ServiceTreeProvider());
        this.titleDecorator = new ResolveTitlesDecorator(new ResolveLabelProviderSimple(), true);
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider(this.titleDecorator.getSource(), (ILabelDecorator)this.titleDecorator);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setAutoExpandLevel(3);
        ResourceSelectionState state = (ResourceSelectionState)this.getState();
        this.label = new Label(composite, 0);
        this.label.setLayoutData((Object)new GridData(768));
        this.label.setText(MessageFormat.format(Messages.ResourceSelectionPage_NumLayersSelected, 0));
        this.setInput(state);
        this.setControl((Control)composite);
    }

    public CheckboxTreeViewer getViewer() {
        return this.viewer;
    }

    public void syncWithUI() {
        try {
            LinkedHashMap<IGeoResource, IService> map = new LinkedHashMap<IGeoResource, IService>();
            Object[] elements = this.getViewer().getCheckedElements();
            ArrayList<IGeoResource> resources = new ArrayList<IGeoResource>();
            int i = 0;
            while (i < elements.length) {
                resources.addAll(this.collectResources((IResolve)elements[i]));
                ++i;
            }
            for (IGeoResource geoResource : resources) {
                map.put(geoResource, geoResource.service((IProgressMonitor)new NullProgressMonitor()));
            }
            this.label.setText(MessageFormat.format(Messages.ResourceSelectionPage_NumLayersSelected, map.size()));
            ((ResourceSelectionState)this.getState()).setResources(map);
        }
        catch (IOException e) {
            CatalogUIPlugin.log(e.getLocalizedMessage(), e);
        }
    }

    private List<IGeoResource> collectResources(IResolve resolve) throws IOException {
        if (this.viewer.getExpandedState((Object)resolve) && !(resolve instanceof IGeoResource)) {
            return Collections.emptyList();
        }
        if (resolve instanceof IGeoResource) {
            return Collections.singletonList((IGeoResource)resolve);
        }
        ArrayList<IGeoResource> resources = new ArrayList<IGeoResource>();
        List members = resolve.members((IProgressMonitor)new NullProgressMonitor());
        for (IResolve resolve2 : members) {
            resources.addAll(this.collectResources(resolve2));
        }
        return resources;
    }

    @Override
    public void shown() {
        this.setInput((ResourceSelectionState)this.getState());
    }

    private void setInput(ResourceSelectionState state) {
        this.grayedElements.clear();
        int checked = 0;
        if (state.getWorkflow().getContext() instanceof IResolveFolder) {
            IResolveFolder resolveFolder = (IResolveFolder)state.getWorkflow().getContext();
            IService service = resolveFolder.getService((IProgressMonitor)new NullProgressMonitor());
            this.schemaSelected = resolveFolder.getTitle();
            this.viewer.setInput((Object)service);
        } else {
            this.viewer.setInput(state.getServices());
            Map<IGeoResource, IService> resources = state.getResources();
            if (resources != null) {
                HashSet<IService> expanded = new HashSet<IService>();
                for (Map.Entry<IGeoResource, IService> entry : resources.entrySet()) {
                    ++checked;
                    IGeoResource resource = entry.getKey();
                    IService service = entry.getValue();
                    this.viewer.setChecked((Object)resource, true);
                    this.viewer.setChecked((Object)service, true);
                    expanded.add(service);
                }
                if (this.collapseCheckedInput) {
                    for (IService service : expanded) {
                        this.viewer.setExpandedState((Object)service, false);
                    }
                }
            }
        }
        this.viewer.setGrayedElements(this.grayedElements.toArray());
        this.label.setText(MessageFormat.format(Messages.ResourceSelectionPage_NumLayersSelected, checked));
    }

    Button findButton(Control[] children, int id) {
        if ((Integer)this.getShell().getDefaultButton().getData() == id) {
            return this.getShell().getDefaultButton();
        }
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Composite composite;
            Button button;
            Button button2;
            Control child = controlArray[n2];
            if (child instanceof Button && (Integer)(button2 = (Button)child).getData() == id) {
                return button2;
            }
            if (child instanceof Composite && (button = this.findButton((composite = (Composite)child).getChildren(), id)) != null) {
                return button;
            }
            ++n2;
        }
        return null;
    }

    public void pageChanged(PageChangedEvent event) {
    }

    public boolean isCollapseCheckedInput() {
        return this.collapseCheckedInput;
    }

    public void setCollapseCheckedInput(boolean collapseCheckedInput) {
        this.collapseCheckedInput = collapseCheckedInput;
    }

    private final class ResourceSelectionPageCheckStateListener
    implements ICheckStateListener {
        private ResourceSelectionPageCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object o = event.getElement();
            boolean checked = event.getChecked();
            ServiceTreeProvider p = this.updateChildren(o, checked);
            if (checked) {
                Object parent = p.getParent(o);
                while (parent != null && !(parent instanceof IGeoResource)) {
                    ResourceSelectionPage.this.viewer.setChecked(parent, true);
                    parent = p.getParent(parent);
                }
            }
            ResourceSelectionPage.this.syncWithUI();
        }

        private ServiceTreeProvider updateChildren(Object o, boolean checked) {
            ServiceTreeProvider p = (ServiceTreeProvider)ResourceSelectionPage.this.viewer.getContentProvider();
            if (o instanceof IGeoResource) {
                return p;
            }
            Object[] children = p.getChildren(o);
            if (children != null && children.length > 0) {
                int i = 0;
                while (i < children.length) {
                    ResourceSelectionPage.this.viewer.setChecked(children[i], checked);
                    this.updateChildren(children[i], checked);
                    ++i;
                }
            }
            return p;
        }
    }

    public class ServiceTreeProvider
    extends LabelProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Collection) {
                Collection list = (Collection)parentElement;
                if (list.isEmpty()) {
                    return this.reasons();
                }
                return list.toArray();
            }
            if (parentElement instanceof IResolve) {
                IResolve service;
                List children;
                if (parentElement instanceof IResolveFolder) {
                    IResolveFolder folder = (IResolveFolder)parentElement;
                    if (ResourceSelectionPage.this.schemaSelected != null) {
                        try {
                            if (ResourceSelectionPage.this.schemaSelected == folder.getTitle()) {
                                List children2 = folder.members((IProgressMonitor)new NullProgressMonitor());
                                return children2.toArray();
                            }
                            return null;
                        }
                        catch (IOException e) {
                            CatalogUIPlugin.log(null, e);
                        }
                    }
                }
                if ((children = ResourceSelectionPage.this.getGeoResources(service = (IResolve)parentElement, true)).isEmpty()) {
                    if (parentElement instanceof IService) {
                        ResourceSelectionPage.this.grayedElements.add(service);
                        if (service.getStatus() == IResolve.Status.BROKEN) {
                            if (service.getMessage() != null) {
                                String string = String.valueOf(Messages.ResourceSelectionPage_brokenReportError) + service.getMessage().getLocalizedMessage();
                                ResourceSelectionPage.this.grayedElements.add(string);
                                return new String[]{string};
                            }
                            String string = Messages.ResourceSelectionPage_brokenUnknown;
                            ResourceSelectionPage.this.grayedElements.add(string);
                            return new String[]{string};
                        }
                        if (service.getStatus() == IResolve.Status.RESTRICTED_ACCESS) {
                            String string = Messages.ResourceSelectionPage_noPermission;
                            ResourceSelectionPage.this.grayedElements.add(string);
                            return new String[]{string};
                        }
                        if (service.getStatus() == IResolve.Status.CONNECTED) {
                            String string = Messages.ResourceSelectionPage_connectedButNoResources;
                            ResourceSelectionPage.this.grayedElements.add(string);
                            return new String[]{string};
                        }
                    } else {
                        return null;
                    }
                }
                return children.toArray();
            }
            return null;
        }

        private Object[] reasons() {
            return new String[]{Messages.ResourceSelectionPage_noServices};
        }

        public Object getParent(Object element) {
            if (element instanceof IResolve) {
                IResolve resource = (IResolve)element;
                try {
                    return resource.parent((IProgressMonitor)new NullProgressMonitor());
                }
                catch (IOException e) {
                    CatalogUIPlugin.log(null, e);
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IResolve;
        }

        public String getText(Object element) {
            if (element instanceof IResolve) {
                IResolve resolver = (IResolve)element;
                return resolver.getIdentifier().toString();
            }
            return null;
        }
    }
}

