/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.ui;

import java.io.Serializable;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ui.AbstractUDIGImportPage;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.EndConnectionState;
import net.refractions.udig.catalog.ui.workflow.IntermediateState;
import net.refractions.udig.catalog.ui.workflow.Listener;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardDialog;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPage;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.geotools.data.DataSourceException;

public class ConnectionPageDecorator
extends WorkflowWizardPage
implements UDIGConnectionPage,
Listener {
    UDIGConnectionPage page;

    public ConnectionPageDecorator() {
        super("connection");
    }

    @Override
    public Map<String, Serializable> getParams() {
        return this.page.getParams();
    }

    @Override
    public void setState(State state) {
        UDIGConnectionPage tmp;
        super.setState(state);
        if (state instanceof IntermediateState) {
            IntermediateState intermediateState = (IntermediateState)state;
            EndConnectionState endConnectionState = (EndConnectionState)intermediateState.getEndState();
            tmp = endConnectionState.getConnectionFactory().createConnectionPage(intermediateState.getIndex());
        } else {
            EndConnectionState endConnectionState = (EndConnectionState)state;
            tmp = endConnectionState.getConnectionFactory().createConnectionPage(endConnectionState.getDescriptor().getWizardPageCount() - 1);
        }
        this.page = tmp;
        if (tmp instanceof WorkflowWizardPage) {
            ((WorkflowWizardPage)((Object)tmp)).setState(state);
        }
        if (tmp.getWizard() != this.getWizard()) {
            tmp.setWizard((IWizard)this.getWizard());
        }
        state.getWorkflow().addListener(this);
    }

    @Override
    public void shown() {
        super.shown();
        if (this.page instanceof WorkflowWizardPage) {
            ((WorkflowWizardPage)((Object)this.page)).shown();
        }
    }

    public void createControl(Composite parent) {
        this.page.createControl(parent);
        this.setControl(this.page.getControl());
    }

    public void dispose() {
        this.page.dispose();
        this.setControl(null);
    }

    public boolean isPageComplete() {
        if (this.page == null) {
            return false;
        }
        boolean complete = this.page.isPageComplete();
        if (complete && this.getState() instanceof EndConnectionState) {
            EndConnectionState state = (EndConnectionState)this.getState();
            state.setServices(this.page.getServices());
            if (this.page instanceof AbstractUDIGImportPage) {
                AbstractUDIGImportPage importPage = (AbstractUDIGImportPage)this.page;
                state.setSelectedResources(importPage.getResourceIDs());
            }
        }
        return complete;
    }

    @Override
    public boolean leavingPage() {
        AbstractUDIGImportPage importPage;
        if (this.getState() instanceof EndConnectionState) {
            EndConnectionState state = (EndConnectionState)this.getState();
            Collection<IService> services = this.page.getServices();
            state.setServices(services);
            if (this.page instanceof AbstractUDIGImportPage) {
                AbstractUDIGImportPage importPage2 = (AbstractUDIGImportPage)this.page;
                Collection<URL> resourceIDs = importPage2.getResourceIDs();
                state.setSelectedResources(resourceIDs);
            }
        }
        return !(this.page instanceof AbstractUDIGImportPage) || (importPage = (AbstractUDIGImportPage)this.page).leavingPage();
    }

    public String getName() {
        return this.page.getName();
    }

    public Image getImage() {
        return this.page.getImage();
    }

    public String getDescription() {
        return this.page.getDescription();
    }

    public String getTitle() {
        return this.page.getTitle();
    }

    public String getMessage() {
        return this.page.getMessage();
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
    }

    @Override
    public void forward(State current, State prev) {
    }

    @Override
    public void backward(State current, State next) {
    }

    @Override
    public void statePassed(State state) {
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ConnectionPageDecorator.this.setErrorMessage(null);
            }
        });
    }

    @Override
    public void stateFailed(State state) {
        EndConnectionState connectionState;
        Map<IService, Throwable> errors;
        Iterator<Map.Entry<IService, Throwable>> iterator;
        if (state instanceof EndConnectionState && (iterator = (errors = (connectionState = (EndConnectionState)state).getErrors()).entrySet().iterator()).hasNext()) {
            Map.Entry<IService, Throwable> entry = iterator.next();
            Throwable t = entry.getValue();
            final String message = this.formatException(entry.getKey(), t);
            if (Display.getCurrent() == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionPageDecorator.this.page.setErrorMessage(message);
                    }
                });
            } else {
                this.page.setErrorMessage(message);
            }
        }
    }

    private String formatException(IService key, Throwable t) {
        if (t instanceof UnknownHostException) {
            return String.valueOf(key.getIdentifier().getHost()) + Messages.ConnectionPage_illegalHost;
        }
        if (t instanceof DataSourceException) {
            String message = t.getMessage();
            if (message.contains("user") && message.contains("does not exist")) {
                return Messages.ConnectionPage_badUsername;
            }
            if (message.contains("password")) {
                return Messages.ConnectionPage_badPassword;
            }
        }
        return Messages.ConnectionPage_genericError;
    }

    @Override
    public void started(State first) {
    }

    @Override
    public void finished(State last) {
        if (!(this.getContainer() instanceof WorkflowWizardDialog) && this.getContainer() != null) {
            this.getWizard().performFinish();
        }
    }

    public IWizardPage getNextPage() {
        if (!this.getState().hasNext()) {
            return super.getNextPage();
        }
        return this.page.getNextPage();
    }

    public Control getControl() {
        return super.getControl();
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        IWizardPage previousPage = page;
        if (page instanceof ConnectionPageDecorator) {
            previousPage = ((ConnectionPageDecorator)page).page;
        }
        this.page.setPreviousPage(previousPage);
    }

    @Override
    public Collection<URL> getResourceIDs() {
        return this.page.getResourceIDs();
    }

    @Override
    public Collection<IService> getServices() {
        return this.page.getServices();
    }

    @Override
    public State getState() {
        return super.getState();
    }
}

