/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.ui;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IRepository;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.core.internal.CorePlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;

public class CatalogViewDropAdapter
extends ViewerDropAdapter {
    protected CatalogViewDropAdapter(Viewer viewer) {
        super(viewer);
    }

    public boolean performDrop(Object data) {
        IServiceFactory serviceFactory = CatalogPlugin.getDefault().getServiceFactory();
        IRepository local = CatalogPlugin.getDefault().getLocal();
        if (data instanceof URL) {
            URL url = (URL)data;
            try {
                local.acquire(url, null);
            }
            catch (IOException e) {
                CatalogUIPlugin.log("Drag and Drop " + url, e);
            }
        } else if (data instanceof Map) {
            Map connectionParams = (Map)data;
            try {
                local.acquire(connectionParams, null);
            }
            catch (IOException e) {
                CatalogUIPlugin.log("Drag and Drop " + connectionParams, e);
            }
        } else if (data instanceof String || data instanceof String[]) {
            List urls = null;
            urls = data instanceof String ? CorePlugin.stringsToURLs((String)((String)data)) : CorePlugin.stringsToURLs((String[])((String[])data));
            for (URL url : urls) {
                List services = serviceFactory.createService(url);
                for (IService service : services) {
                    CatalogPlugin.getDefault().getLocalCatalog().add(service);
                }
            }
        }
        return true;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return true;
    }
}

