/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.ui;

import java.io.IOException;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ui.CatalogTreeViewer;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.StatusLineMessageBoardAdapter;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.internal.ui.IDropTargetProvider;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.ProgressManager;
import net.refractions.udig.ui.UDIGDragDropUtilities;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.prefs.BackingStoreException;

public class CatalogView
extends ViewPart
implements ISetSelectionTarget,
IDropTargetProvider {
    public static final String VIEW_ID = "net.refractions.udig.catalog.ui.CatalogView";
    CatalogTreeViewer treeviewer;
    Action removeAction;
    private Action saveAction;
    private Action loadAction;
    private Action propertiesAction;

    public void createPartControl(Composite parent) {
        this.treeviewer = new CatalogTreeViewer(parent, true);
        this.treeviewer.setMessageBoard(new StatusLineMessageBoardAdapter(this.getViewSite().getActionBars().getStatusLineManager()));
        UDIGDragDropUtilities.addDragDropSupport((StructuredViewer)this.treeviewer, (IDropTargetProvider)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeviewer);
        this.createActions();
        this.createMenu();
        this.createToolbar();
        this.createContextMenu();
        this.hookGlobalActions();
    }

    protected void hookGlobalActions() {
        this.getViewSite().getActionBars().setGlobalActionHandler("properties", (IAction)this.propertiesAction);
    }

    private void createContextMenu() {
        final MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                contextMenu.add((IContributionItem)new GroupMarker("additions"));
                contextMenu.add((IContributionItem)new Separator());
                contextMenu.add((IAction)CatalogView.this.removeAction);
                IWorkbenchWindow window = CatalogView.this.getSite().getWorkbenchWindow();
                ActionFactory.IWorkbenchAction action = ActionFactory.IMPORT.create(window);
                contextMenu.add((IAction)action);
                contextMenu.add((IContributionItem)new Separator());
                contextMenu.add((IContributionItem)UiPlugin.getDefault().getOperationMenuFactory().getContextMenu(CatalogView.this.treeviewer.getSelection()));
                contextMenu.add((IContributionItem)new Separator());
                contextMenu.add((IAction)ActionFactory.EXPORT.create(CatalogView.this.getSite().getWorkbenchWindow()));
            }
        });
        Menu menu = contextMenu.createContextMenu(this.treeviewer.getControl());
        this.treeviewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.treeviewer);
    }

    private void createActions() {
        this.propertiesAction = new PropertyDialogAction((IShellProvider)this.getViewSite().getWorkbenchWindow(), (ISelectionProvider)this.treeviewer);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        this.getSite().getKeyBindingService().registerAction((IAction)this.propertiesAction);
        this.removeAction = new Action(){

            public void run() {
                IStructuredSelection selected = (IStructuredSelection)CatalogView.this.treeviewer.getSelection();
                CatalogView.this.removeSelected(selected);
            }
        };
        Messages.initAction((IAction)this.removeAction, "action_remove");
        this.removeAction.setEnabled(false);
        this.removeAction.setImageDescriptor(CatalogUIPlugin.getDefault().getImageDescriptor("elcl16/remove_co.gif"));
        this.removeAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.removeAction);
        this.getSite().getKeyBindingService().registerAction((IAction)this.removeAction);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.removeAction, "net.refractions.udig.catalog.ui.remove_service_action_context");
        this.saveAction = new Action(Messages.CatalogView_save_label){

            public void run() {
                try {
                    CatalogPlugin.getDefault().storeToPreferences(ProgressManager.instance().get(new Object[0]));
                }
                catch (BackingStoreException e) {
                    CatalogPlugin.log(null, (Throwable)e);
                }
                catch (IOException e) {
                    CatalogPlugin.log(null, (Throwable)e);
                }
            }
        };
        this.loadAction = new Action(Messages.CatalogView_load_label){

            public void run() {
                try {
                    CatalogPlugin.getDefault().restoreFromPreferences();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.treeviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CatalogView.this.updateActionEnablement();
            }
        });
    }

    void registerDatasource() {
    }

    protected void showProperties(IStructuredSelection selected) {
        if (selected.isEmpty()) {
            return;
        }
        selected.getFirstElement();
        for (Object o : selected) {
            if (o instanceof IService) {
                this.remove((IService)o);
                continue;
            }
            if (!(o instanceof IGeoResource)) continue;
            this.remove((IGeoResource)o);
        }
    }

    protected void removeSelected(IStructuredSelection selected) {
        for (Object o : selected) {
            if (o instanceof IService) {
                this.remove((IService)o);
                continue;
            }
            if (!(o instanceof IGeoResource)) continue;
            this.remove((IGeoResource)o);
        }
    }

    private void remove(IService service) {
        CatalogPlugin.getDefault().getLocalCatalog().remove(service);
    }

    private void remove(IGeoResource georesource) {
        try {
            this.remove(georesource.service(null));
        }
        catch (IOException e) {
            CatalogUIPlugin.log(null, e);
        }
    }

    void updateActionEnablement() {
        IStructuredSelection sel = (IStructuredSelection)this.treeviewer.getSelection();
        if (sel.size() == 0) {
            this.removeAction.setEnabled(false);
            this.propertiesAction.setEnabled(false);
        } else {
            this.removeAction.setEnabled(true);
            this.propertiesAction.setEnabled(true);
        }
    }

    private void createMenu() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.add((IAction)this.saveAction);
        mgr.add((IAction)this.loadAction);
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        ActionFactory.IWorkbenchAction action = ActionFactory.IMPORT.create(window);
        action.setImageDescriptor(CatalogUIPlugin.getDefault().getImageDescriptor("etool16/import_wiz.gif"));
        mgr.add((IAction)action);
        mgr.add((IAction)this.removeAction);
    }

    public void setFocus() {
        this.treeviewer.getControl().setFocus();
    }

    public CatalogTreeViewer getTreeviewer() {
        return this.treeviewer;
    }

    public void selectReveal(ISelection selection) {
        this.treeviewer.setSelection(selection, true);
    }

    public Object getTarget(DropTargetEvent event) {
        return this;
    }
}

