/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.wizard.export.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.Project;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ExportProjectUtils {
    public static void exportProject(Project project, String destinationDirectory, IProgressMonitor monitor) {
        if (project == null) {
            return;
        }
        monitor.beginTask(String.valueOf(Messages.ExportProjectWizard_Exporting) + project.getName(), 1);
        Resource resource = project.eResource();
        if (resource == null) {
            throw new NullPointerException("Project does not have a file");
        }
        String destination = ExportProjectUtils.generateDestinationProjectFilePath(resource, project.getName(), destinationDirectory);
        Resource copy = ExportProjectUtils.collectAllAndCopyIntoDestResource(resource, destination);
        ExportProjectUtils.saveResource(copy);
        monitor.worked(1);
    }

    private static String generateDestinationProjectFilePath(Resource resource, String name, String destinationDirectory) {
        URI origURI = resource.getURI();
        File file = new File(origURI.toFileString());
        return String.valueOf(destinationDirectory) + File.separator + name + ".udig" + File.separator + file.getName();
    }

    private static void saveResource(Resource copy) {
        try {
            copy.save(null);
        }
        catch (IOException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    private static Resource collectAllAndCopyIntoDestResource(Resource projectResource, String dest) {
        ResourceSet resourceSet = projectResource.getResourceSet();
        List<Resource> resources = ExportProjectUtils.gatherAllResourcesToList(projectResource);
        File destFile = new File(dest);
        String absoluteDestPath = destFile.getAbsolutePath();
        URI destURI = URI.createFileURI((String)absoluteDestPath);
        Resource destResource = resourceSet.createResource(destURI);
        ArrayList collection = new ArrayList();
        for (Resource curResource : resources) {
            collection.addAll(curResource.getContents());
        }
        Collection copyAll = EcoreUtil.copyAll(collection);
        destResource.getContents().addAll(copyAll);
        return destResource;
    }

    private static List<Resource> gatherAllResourcesToList(Resource projectResource) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(projectResource);
        ExportProjectUtils.addReferencedResourcesToList(resources);
        return resources;
    }

    private static void addReferencedResourcesToList(List<Resource> resources) {
        int i = 0;
        while (i < resources.size()) {
            Resource r = resources.get(i);
            TreeIterator j = r.getAllContents();
            while (j.hasNext()) {
                for (Object object : ((EObject)j.next()).eCrossReferences()) {
                    EObject eObject;
                    Resource otherResource;
                    if (!(object instanceof EObject) || (otherResource = (eObject = (EObject)object).eResource()) == null || resources.contains(otherResource)) continue;
                    resources.add(otherResource);
                }
            }
            ++i;
        }
    }
}

