/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.wizard.export.image;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.wizard.export.image.ImageExportFormat;
import net.refractions.udig.project.ui.wizard.export.image.XAffineTransform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class WorldImageExportFormat
extends ImageExportFormat {
    private String formatName;
    private String formatExtension;

    public WorldImageExportFormat(String formatName, String formatExtension) {
        this.formatName = formatName;
        this.formatExtension = formatExtension;
    }

    @Override
    public String getName() {
        return this.formatName;
    }

    @Override
    public String getExtension() {
        return this.formatExtension;
    }

    @Override
    public void createControl(Composite parent) {
        this.setControl((Control)new Composite(parent, 0));
    }

    @Override
    public void write(IMap map, BufferedImage image, File destination) throws IOException {
        ImageIO.write((RenderedImage)image, this.getName(), destination);
        String baseFile = destination.getPath().substring(0, destination.getPath().lastIndexOf("."));
        try {
            this.createWorldFile(map.getViewportModel().worldToScreenTransform().createInverse(), baseFile);
        }
        catch (TransformException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        catch (NoninvertibleTransformException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        this.createProjectionFile(baseFile, map.getViewportModel().getCRS());
    }

    private void createProjectionFile(String baseFile, CoordinateReferenceSystem coordinateReferenceSystem) throws IOException {
        try {
            File prjFile = new File(new StringBuffer(baseFile).append(".prj").toString());
            BufferedWriter out = new BufferedWriter(new FileWriter(prjFile));
            out.write(coordinateReferenceSystem.toWKT());
            out.close();
        }
        catch (Throwable throwable) {}
    }

    private void createWorldFile(AffineTransform gridToWorld, String baseFile) throws IOException, TransformException {
        boolean lonFirst = XAffineTransform.getSwapXY(gridToWorld) != -1;
        double xPixelSize = lonFirst ? gridToWorld.getScaleX() : gridToWorld.getShearY();
        double rotation1 = lonFirst ? gridToWorld.getShearX() : gridToWorld.getScaleX();
        double rotation2 = lonFirst ? gridToWorld.getShearY() : gridToWorld.getScaleY();
        double yPixelSize = lonFirst ? gridToWorld.getScaleY() : gridToWorld.getShearX();
        double xLoc = gridToWorld.getTranslateX();
        double yLoc = gridToWorld.getTranslateY();
        StringBuffer buff = new StringBuffer(baseFile);
        buff.append(".wld");
        File worldFile = new File(buff.toString());
        PrintWriter out = new PrintWriter(new FileOutputStream(worldFile));
        out.println(xPixelSize);
        out.println(rotation1);
        out.println(rotation2);
        out.println(yPixelSize);
        out.println(xLoc);
        out.println(yLoc);
        out.flush();
        out.close();
    }
}

