/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.wizard.export.image;

public enum Paper {
    LETTER(216, 356),
    LEGAL(216, 279),
    A0(841, 1189),
    A1(594, 841),
    A2(420, 594),
    A3(594, 420),
    A4(210, 297);

    final double MILLIMETERS_PER_INCH = 25.4;
    private final int width;
    private final int height;

    private Paper(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private int toPixels(int width2, double dpi) {
        return (int)((double)width2 / 25.4 * dpi);
    }

    public int getPixelWidth(boolean landscape, int dpi) {
        if (landscape) {
            return this.toPixels(this.height, dpi);
        }
        return this.toPixels(this.width, dpi);
    }

    public int getPixelHeight(boolean landscape, int dpi) {
        if (landscape) {
            return this.toPixels(this.width, dpi);
        }
        return this.toPixels(this.height, dpi);
    }
}

