/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.wizard.export.image;

import java.awt.image.BufferedImage;
import java.io.File;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.wizard.export.image.Image2Pdf;
import net.refractions.udig.project.ui.wizard.export.image.ImageExportFormat;
import net.refractions.udig.project.ui.wizard.export.image.ImageExportPage;
import net.refractions.udig.project.ui.wizard.export.image.Paper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class PDFImageExportFormat
extends ImageExportFormat {
    private Combo dpiCombo;
    private Spinner topMarginSpinner;
    private Spinner lowerMarginSpinner;
    private Spinner leftMarginSpinner;
    private Spinner rightMarginSpinner;
    private Combo paperCombo;
    private Button landscape;

    @Override
    public String getExtension() {
        return "pdf";
    }

    @Override
    public String getName() {
        return "PDF";
    }

    @Override
    public boolean useStandardDimensionControls() {
        return false;
    }

    @Override
    public void write(IMap map, BufferedImage image, File destination) {
        Image2Pdf.write(image, destination.getAbsolutePath(), this.paper(), this.leftMarginSpinner.getSelection(), this.topMarginSpinner.getSelection(), this.landscape(), this.getDpi());
    }

    @Override
    public void createControl(Composite comp) {
        Group group = new Group(comp, 0);
        group.setText(Messages.ImageExportPage_PDF_Group_Description);
        group.setLayout((Layout)new GridLayout(4, false));
        this.createPaperLabel(group);
        this.createPaperCombo(group);
        this.createLandscapeButton(group);
        this.createLandscapeLabel(group);
        this.createDpiCombo(group);
        this.createMarginsGroup(group);
        this.setControl((Control)group);
    }

    private void createDpiCombo(Group group) {
        ImageExportPage.createLabel((Composite)group, "DPI:");
        this.dpiCombo = new Combo((Composite)group, 8);
        this.dpiCombo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.dpiCombo.setItems(new String[]{"72", "144", "300"});
        this.dpiCombo.setData("0", (Object)72);
        this.dpiCombo.setData("1", (Object)144);
        this.dpiCombo.setData("2", (Object)300);
        this.dpiCombo.select(0);
    }

    private void createMarginsGroup(Group group) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.horizontalSpan = 4;
        Group marginsGroup = new Group((Composite)group, 0);
        marginsGroup.setLayoutData((Object)gridData);
        marginsGroup.setLayout((Layout)gridLayout);
        marginsGroup.setText(Messages.ImageExportPage_marginsGroup);
        Label topLabel = new Label((Composite)marginsGroup, 0);
        topLabel.setText(Messages.ImageExportPage_topMargin);
        this.topMarginSpinner = new Spinner((Composite)marginsGroup, 0);
        this.topMarginSpinner.setSelection(10);
        Label lowerLabel = new Label((Composite)marginsGroup, 0);
        lowerLabel.setText(Messages.ImageExportPage_lowerMargin);
        this.lowerMarginSpinner = new Spinner((Composite)marginsGroup, 0);
        this.lowerMarginSpinner.setSelection(10);
        Label leftLabel = new Label((Composite)marginsGroup, 0);
        leftLabel.setText(Messages.ImageExportPage_leftMargin);
        this.leftMarginSpinner = new Spinner((Composite)marginsGroup, 0);
        this.leftMarginSpinner.setSelection(10);
        Label rightLabel = new Label((Composite)marginsGroup, 0);
        rightLabel.setText(Messages.ImageExportPage_rightMargin);
        this.rightMarginSpinner = new Spinner((Composite)marginsGroup, 0);
        this.rightMarginSpinner.setSelection(10);
    }

    private void createLandscapeLabel(Group group) {
        ImageExportPage.createLabel((Composite)group, Messages.ImageExportPage_landscapeLabel);
    }

    private void createPaperLabel(Group group) {
        ImageExportPage.createLabel((Composite)group, Messages.ImageExportPage_size_Label);
    }

    private void createPaperCombo(Group group) {
        Paper[] paperTypes;
        this.paperCombo = new Combo((Composite)group, 8);
        this.paperCombo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Paper[] paperArray = paperTypes = Paper.values();
        int n = paperTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Paper paper = paperArray[n2];
            this.paperCombo.add(paper.name());
            ++n2;
        }
        this.paperCombo.select(0);
    }

    private void createLandscapeButton(Group group) {
        this.landscape = new Button((Composite)group, 32);
        this.landscape.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
    }

    public boolean landscape() {
        return this.landscape.getSelection();
    }

    public Paper paper() {
        return Paper.valueOf(this.paperCombo.getItem(this.paperCombo.getSelectionIndex()));
    }

    public int getDpi() {
        return Integer.valueOf(this.dpiCombo.getItem(this.dpiCombo.getSelectionIndex()));
    }

    @Override
    public int getHeight(double mapwidth, double mapheight) {
        int paperHeight = this.paper().getPixelHeight(this.landscape(), this.getDpi());
        int topMargin = this.topMarginSpinner.getSelection();
        int lowerMargin = this.lowerMarginSpinner.getSelection();
        return paperHeight - topMargin - lowerMargin;
    }

    @Override
    public int getWidth(double mapwidth, double mapheight) {
        int paperWidth = this.paper().getPixelWidth(this.landscape(), this.getDpi());
        int rightMargin = this.rightMarginSpinner.getSelection();
        int leftMargin = this.leftMarginSpinner.getSelection();
        return paperWidth - rightMargin - leftMargin;
    }
}

