/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.wizard.export.image;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.render.RenderException;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.BoundsStrategy;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.wizard.export.image.ImageExportPage;
import net.refractions.udig.project.ui.wizard.export.image.MapSelectorPageWithScaleColumn;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.opengis.referencing.operation.TransformException;

public class ExportMapToImageWizard
extends Wizard
implements IExportWizard {
    public static final String DIRECTORY_KEY = "exportDirectoryKey";
    public static final String FORMAT_KEY = "exportFormatKey";
    public static final String WIDTH_KEY = "widthKey";
    public static final String HEIGHT_KEY = Messages.ExportMapToImageWizard_3;
    public static final String SELECTION = "SELECTION_HANDLING";
    private ImageExportPage imageSettingsPage = new ImageExportPage();
    private MapSelectorPageWithScaleColumn mapSelectorPage;

    public ExportMapToImageWizard() {
        this.setWindowTitle(Messages.ExportMapToImageWizard_windowtitle);
        this.setDialogSettings(ProjectUIPlugin.getDefault().getDialogSettings());
        String title = null;
        ImageDescriptor banner = ProjectUIPlugin.getDefault().getImageDescriptor("wizban/exportimage_wiz.gif");
        this.setDefaultPageImageDescriptor(banner);
        this.mapSelectorPage = new MapSelectorPageWithScaleColumn("Select Map With Scale", title, banner);
        this.addPage((IWizardPage)this.mapSelectorPage);
        this.addPage((IWizardPage)this.imageSettingsPage);
        this.setNeedsProgressMonitor(true);
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        this.addPageChangeListener();
    }

    private void addPageChangeListener() {
        if (this.getContainer() instanceof WizardDialog) {
            WizardDialog dialog = (WizardDialog)this.getContainer();
            dialog.addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    WizardPage currentPage = (WizardPage)event.getSelectedPage();
                    if (currentPage == ExportMapToImageWizard.this.mapSelectorPage) {
                        String currentFormat = ExportMapToImageWizard.this.imageSettingsPage.getFormat().getName();
                        String description = MessageFormat.format("Select map to export to {0} images", currentFormat);
                        currentPage.setDescription(description);
                    }
                }
            });
        }
    }

    public boolean performFinish() {
        final ArrayList errors = new ArrayList();
        final ArrayList renderedMaps = new ArrayList();
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Collection<IMap> maps = ExportMapToImageWizard.this.mapSelectorPage.getMaps();
                    monitor.beginTask(Messages.ExportMapToImageWizard_exportMapsTaskName, maps.size() * 3 + 1);
                    monitor.worked(1);
                    for (IMap map : maps) {
                        try {
                            ExportMapToImageWizard.this.exportMap(map, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
                        }
                        catch (RenderException e) {
                            Object[] args = new Object[]{map.getName(), e.getLocalizedMessage()};
                            String pattern = Messages.ExportMapToImageWizard_renderingErrorMessage;
                            errors.add(MessageFormat.format(pattern, args));
                        }
                        catch (IOException e) {
                            errors.add(String.valueOf(Messages.ExportMapToImageWizard_ioexceptionErrorMessage) + e.getLocalizedMessage());
                        }
                        catch (TransformException transformException) {
                            errors.add("Failed to create world file.  This image can not be used as a Raster file in uDig");
                        }
                        catch (NoninvertibleTransformException noninvertibleTransformException) {
                            errors.add("Failed to create world file.  This image can not be used as a Raster file in uDig");
                        }
                        catch (RuntimeException e) {
                            errors.add("An unexpected failure occurred: " + e.getLocalizedMessage());
                        }
                        renderedMaps.add(map);
                    }
                    ExportMapToImageWizard.this.mapSelectorPage.getMaps().remove(renderedMaps);
                    ExportMapToImageWizard.this.mapSelectorPage.updateMapList();
                }
            });
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (!errors.isEmpty()) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage(String.valueOf(Messages.ExportMapToImageWizard_ShowErrorMessage) + (String)errors.iterator().next());
            return false;
        }
        this.getDialogSettings().put(DIRECTORY_KEY, this.mapSelectorPage.getExportDir().getAbsolutePath());
        this.getDialogSettings().put(FORMAT_KEY, this.imageSettingsPage.getFormat().getName());
        return true;
    }

    private void exportMap(IMap map, IProgressMonitor monitor) throws RenderException, IOException, TransformException, NoninvertibleTransformException {
        IMap renderedMap;
        monitor.beginTask(Messages.ExportMapToImageWizard_RenderingTaskName, 10);
        String pattern = Messages.ExportMapToImageWizard_preparingTaskName;
        Object[] args = new Object[]{map.getName()};
        monitor.setTaskName(MessageFormat.format(pattern, args));
        File destination = this.determineDestinationFile(map);
        if (destination == null) {
            return;
        }
        int width = this.imageSettingsPage.getWidth(map.getViewportModel().getWidth(), map.getViewportModel().getHeight());
        int height = this.imageSettingsPage.getHeight(map.getViewportModel().getWidth(), map.getViewportModel().getHeight());
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        try {
            monitor.worked(2);
            pattern = Messages.ExportMapToImageWizard_renderingTaskname;
            args = new Object[]{map.getName()};
            monitor.setTaskName(MessageFormat.format(pattern, args));
            int scaleDenom = MapSelectorPageWithScaleColumn.getScaleDenom(map);
            BoundsStrategy boundsStrategy = new BoundsStrategy(scaleDenom);
            ApplicationGIS.DrawMapParameter drawMapParameter = new ApplicationGIS.DrawMapParameter(g, new Dimension(width, height), map, boundsStrategy, this.imageSettingsPage.getFormat().getDPI(), this.imageSettingsPage.getSelectionHandling(), monitor);
            renderedMap = ApplicationGIS.drawMap(drawMapParameter);
        }
        finally {
            g.dispose();
        }
        monitor.worked(3);
        pattern = Messages.ExportMapToImageWizard_writingTaskname;
        args = new Object[]{map.getName()};
        monitor.setTaskName(MessageFormat.format(pattern, args));
        this.imageSettingsPage.getFormat().write(renderedMap, image, destination);
        this.addToCatalog(destination);
        monitor.done();
    }

    private void addToCatalog(final File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("Expected " + file + " was not created");
        }
        if (file.getAbsolutePath().toLowerCase().endsWith("pdf")) {
            return;
        }
        Job addToCatalog = new Job("Add " + file.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                ICatalog localCatalog = CatalogPlugin.getDefault().getLocalCatalog();
                URL url = new ID(file, null).toURL();
                IService service = null;
                try {
                    service = localCatalog.acquire(url, monitor);
                }
                catch (IOException iOException) {}
                return service != null ? Status.OK_STATUS : new Status(4, "net.refractions.udig.project.ui", "Failed to add " + file);
            }
        };
        addToCatalog.schedule();
    }

    private void addToCatalog(ICatalog localCatalog, IService service) {
        ID id = service.getID();
        IService found = (IService)localCatalog.getById(IService.class, id, (IProgressMonitor)new NullProgressMonitor());
        if (found != null) {
            localCatalog.replace(service.getID(), service);
        } else {
            localCatalog.add(service);
        }
    }

    private File determineDestinationFile(IMap map) {
        String name;
        File exportDir = this.mapSelectorPage.getExportDir();
        File destination = this.addSuffix(new File(exportDir, name = URLUtils.cleanFilename((String)map.getName())));
        if (destination.exists()) {
            boolean overwrite;
            boolean bl = overwrite = !MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)Messages.ExportMapToImageWizard_overwriteWarningTitle, (String)(String.valueOf(Messages.ExportMapToImageWizard_overwriteWarningMessage) + destination.getName()));
            if (!overwrite) {
                if (!destination.delete()) {
                    destination = this.selectFile(destination, Messages.ExportMapToImageWizard_unableToDeleteMsg);
                }
            } else {
                destination = this.selectFile(destination, Messages.ExportMapToImageWizard_selectFileTitle);
            }
        }
        if (destination == null) {
            return null;
        }
        return this.addSuffix(destination);
    }

    private File addSuffix(File file) {
        String extension;
        String path = this.stripEndSlash(file.getPath());
        if (path.endsWith(extension = this.imageSettingsPage.getFormat().getExtension())) {
            return file;
        }
        File destination = new File(String.valueOf(path) + "." + extension);
        return destination;
    }

    private String stripEndSlash(String path) {
        if (path.endsWith("/")) {
            return this.stripEndSlash(path.substring(0, path.length() - 1));
        }
        return path;
    }

    private File selectFile(File destination, String string) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(string);
        dialog.setFilterPath(destination.getParent());
        dialog.setFileName(destination.getName());
        String file = dialog.open();
        destination = file == null ? null : new File(file);
        return destination;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mapSelectorPage.setSelection(selection);
    }
}

