/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.viewers;

import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.MapToolEntry;
import net.refractions.udig.project.ui.internal.tool.display.ToolManager;
import net.refractions.udig.project.ui.internal.tool.display.ToolProxy;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.ui.IEditorPart;

public class MapEditDomain
extends DefaultEditDomain {
    private PaletteListener paletteListener = new PaletteListener(){

        public void activeToolChanged(PaletteViewer viewer, ToolEntry tool) {
            ToolEntry entry;
            ToolManager tools = (ToolManager)ApplicationGIS.getToolManager();
            if (viewer != null && (entry = viewer.getActiveTool()) instanceof MapToolEntry) {
                MapToolEntry mapEntry = (MapToolEntry)entry;
                ToolProxy toolProxy = mapEntry.getMapToolProxy();
                tools.setActiveModalToolProxy(toolProxy);
            }
        }
    };

    public MapEditDomain(IEditorPart editorPart) {
        super(editorPart);
    }

    public void setPaletteViewer(PaletteViewer palette) {
        PaletteViewer current = this.getPaletteViewer();
        if (current != null) {
            current.removePaletteListener(this.paletteListener);
        }
        super.setPaletteViewer(palette);
        if (palette != null) {
            palette.addPaletteListener(this.paletteListener);
        }
    }

    public void setActiveTool(String id) {
        PaletteViewer paletteViewer = this.getPaletteViewer();
        if (id != null && id.equals(paletteViewer.getActiveTool().getId())) {
            return;
        }
        ToolEntry entry = this.findToolEntry((PaletteContainer)paletteViewer.getPaletteRoot(), id);
        if (entry != null) {
            paletteViewer.setActiveTool(entry);
        }
    }

    private ToolEntry findToolEntry(PaletteContainer container, String id) {
        if (id == null) {
            return null;
        }
        for (Object item : container.getChildren()) {
            ToolEntry find;
            PaletteEntry entry = (PaletteEntry)item;
            if (entry instanceof ToolEntry) {
                if (!id.equals(entry.getId())) continue;
                return (ToolEntry)entry;
            }
            if (!(entry instanceof PaletteContainer) || (find = this.findToolEntry((PaletteContainer)entry, id)) == null) continue;
            return find;
        }
        return null;
    }
}

