/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.tool.selection.provider;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.project.ui.tool.IMapEditorSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractMapEditorSelectionProvider
implements IMapEditorSelectionProvider {
    protected StructuredSelection selection;
    protected CopyOnWriteArraySet<ISelectionChangedListener> listeners = new CopyOnWriteArraySet();

    @Override
    public Set<ISelectionChangedListener> getListeners() {
        return this.listeners;
    }

    protected void notifyListeners() {
        if (Display.getCurrent() == null) {
            final AbstractMapEditorSelectionProvider p = this;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SelectionChangedEvent event = new SelectionChangedEvent(p, (ISelection)AbstractMapEditorSelectionProvider.this.selection);
                    for (ISelectionChangedListener l : AbstractMapEditorSelectionProvider.this.listeners) {
                        l.selectionChanged(event);
                    }
                }
            });
        } else {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection);
            for (ISelectionChangedListener l : this.listeners) {
                l.selectionChanged(event);
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }
}

