/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.tool.options;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ToolOptionContributionItem
extends ContributionItem
implements IPropertyChangeListener {
    protected Map<Control, String> fields = new HashMap<Control, String>();
    protected IPreferenceStore store;
    private SelectionListener selectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            String preferenceString = ToolOptionContributionItem.this.fields.get(e.widget);
            if (e.widget instanceof Button) {
                boolean selectionPref;
                Button button = (Button)e.widget;
                boolean selection = button.getSelection();
                if (selection != (selectionPref = ToolOptionContributionItem.this.getPreferenceStore().getBoolean(preferenceString))) {
                    ToolOptionContributionItem.this.getPreferenceStore().setValue(preferenceString, selection);
                }
            } else if (e.widget instanceof Combo) {
                String selectionPref;
                Combo combo = (Combo)e.widget;
                String selection = ToolOptionContributionItem.this.behaviour[combo.getSelectionIndex()];
                if (selection != (selectionPref = ToolOptionContributionItem.this.getPreferenceStore().getString(preferenceString))) {
                    ToolOptionContributionItem.this.getPreferenceStore().setValue(preferenceString, selection);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private String[] behaviour;

    protected void setPreferenceStore(IPreferenceStore store) {
        this.store = store;
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.store;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyString = event.getProperty();
        if (this.fields.containsValue(propertyString)) {
            try {
                this.listen(false);
                this.update(this.store);
            }
            finally {
                this.listen(true);
            }
        }
    }

    private void listen(boolean listen) {
        if (listen) {
            for (Control control : this.fields.keySet()) {
                if (control == null || control.isDisposed() || !(control instanceof Button)) continue;
                ((Button)control).addSelectionListener(this.selectionListener);
            }
        } else {
            for (Control control : this.fields.keySet()) {
                if (control == null || control.isDisposed() || !(control instanceof Button)) continue;
                ((Button)control).removeSelectionListener(this.selectionListener);
            }
        }
    }

    public void addField(String preferenceString, Button button) {
        if (preferenceString == null) {
            throw new NullPointerException("PreferenceString required");
        }
        this.fields.put((Control)button, preferenceString);
        button.addSelectionListener(this.selectionListener);
    }

    public void addField(String preferenceString, Combo combo, String[] behaviour) {
        if (preferenceString == null) {
            throw new NullPointerException("PreferenceString required");
        }
        this.behaviour = behaviour;
        this.fields.put((Control)combo, preferenceString);
        combo.addSelectionListener(this.selectionListener);
    }

    public final void fill(Composite parent) {
        IPreferenceStore store = this.fillFields(parent);
        this.setPreferenceStore(store);
        this.update(store);
        store.addPropertyChangeListener((IPropertyChangeListener)this);
        this.listen(true);
    }

    protected abstract IPreferenceStore fillFields(Composite var1);

    protected void update(IPreferenceStore preferenceStore) {
        for (Control control : this.fields.keySet()) {
            String preferenceString;
            if (control == null || control.isDisposed() || (preferenceString = this.fields.get(control)) == null) continue;
            if (control instanceof Button) {
                boolean selectionPref;
                Button button = (Button)control;
                boolean selection = button.getSelection();
                if (selection == (selectionPref = preferenceStore.getBoolean(preferenceString))) continue;
                button.setSelection(selectionPref);
                continue;
            }
            if (!(control instanceof Combo)) continue;
            Combo combo = (Combo)control;
            String selectionPref = this.getPreferenceStore().getString(preferenceString);
            int i = 0;
            while (i < this.behaviour.length) {
                if (selectionPref.equals(this.behaviour[i])) {
                    combo.select(i);
                }
                ++i;
            }
        }
    }

    public void dispose() {
        if (this.fields != null) {
            this.listen(false);
            this.fields.clear();
        }
        if (this.store != null) {
            this.store.removePropertyChangeListener((IPropertyChangeListener)this);
            this.store = null;
        }
        super.dispose();
    }
}

