/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.tool;

import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.project.ui.internal.ApplicationGISInternal;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseListener;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseMotionListener;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseWheelEvent;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseWheelListener;
import net.refractions.udig.project.ui.tool.IMapEditorSelectionProvider;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.project.ui.tool.Tool;
import net.refractions.udig.project.ui.tool.ToolLifecycleEvent;
import net.refractions.udig.project.ui.tool.ToolLifecycleListener;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractTool
implements Tool,
MapMouseListener,
MapMouseMotionListener,
MapMouseWheelListener,
EventListener {
    public static final int NONE = 0;
    public static final int MOUSE = 1;
    public static final int MOTION = 2;
    public static final int WHEEL = 4;
    public static final int DRAG_DROP = 8;
    protected IToolContext context;
    private int targets;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private IMapEditorSelectionProvider selectionProvider;
    private Set<ToolLifecycleListener> listeners = new HashSet<ToolLifecycleListener>();
    protected boolean enabled = true;
    private boolean isNotify = true;

    public AbstractTool(int targets) {
        if ((targets & 0xF) != targets) {
            throw new RuntimeException("Argument targets indicated that the items was not to be registered with any component.\nArgument targets = " + targets);
        }
        this.targets = targets;
    }

    public void init(IConfigurationElement element) {
    }

    protected final void registerMouseListeners() {
        if (this.context == null || this.context.getViewportPane() == null) {
            return;
        }
        if ((this.targets & 1) != 0) {
            this.context.getViewportPane().addMouseListener(this);
        }
        if ((this.targets & 2) != 0) {
            this.context.getViewportPane().addMouseMotionListener(this);
        }
        if ((this.targets & 4) != 0) {
            this.context.getViewportPane().addMouseWheelListener(this);
        }
        if ((this.targets & 8) != 0) {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            final IToolContext context = this.context;
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MapEditorPart editor = ApplicationGISInternal.findMapEditor(context.getMap());
                    if (editor != null && !editor.isDragging()) {
                        editor.setDragging(true);
                    }
                }
            });
        }
    }

    protected final void deregisterMouseListeners() {
        if (this.context == null || this.context.getViewportPane() == null) {
            return;
        }
        this.context.getViewportPane().removeMouseListener(this);
        this.context.getViewportPane().removeMouseMotionListener(this);
        this.context.getViewportPane().removeMouseWheelListener(this);
        if ((this.targets & 8) != 0) {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            final IToolContext context = this.context;
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MapEditorPart editor = ApplicationGISInternal.findMapEditor(context.getMap());
                    if (editor != null && editor.isDragging()) {
                        editor.setDragging(false);
                    }
                }
            });
        }
    }

    @Override
    public void setContext(IToolContext tools) {
        this.deregisterMouseListeners();
        this.context = tools;
        this.registerMouseListeners();
    }

    @Override
    public IToolContext getContext() {
        return this.context;
    }

    @Override
    public void dispose() {
        this.deregisterMouseListeners();
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldValue = this.enabled;
        this.enabled = enabled;
        if (this.isNotify && oldValue != enabled) {
            ToolLifecycleEvent event = new ToolLifecycleEvent(this, ToolLifecycleEvent.Type.ENABLE, enabled, oldValue);
            this.fireEvent(event);
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public IMapEditorSelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public void setSelectionProvider(IMapEditorSelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    @Override
    public void addListener(ToolLifecycleListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ToolLifecycleListener listener) {
        this.listeners.remove(listener);
    }

    protected void setNotifyListeners(boolean isNotify) {
        this.isNotify = isNotify;
    }

    protected boolean isNotifyListeners() {
        return this.isNotify;
    }

    protected void fireEvent(ToolLifecycleEvent event) {
        for (ToolLifecycleListener listener : this.listeners) {
            listener.changed(event);
        }
    }

    @Override
    public void mouseEntered(MapMouseEvent e) {
    }

    @Override
    public void mouseExited(MapMouseEvent e) {
    }

    @Override
    public void mousePressed(MapMouseEvent e) {
    }

    @Override
    public void mouseReleased(MapMouseEvent e) {
    }

    @Override
    public void mouseDragged(MapMouseEvent e) {
    }

    @Override
    public void mouseMoved(MapMouseEvent e) {
    }

    @Override
    public void mouseHovered(MapMouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MapMouseWheelEvent e) {
    }

    @Override
    public void mouseDoubleClicked(MapMouseEvent event) {
    }
}

