/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.tool;

import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.tool.AbstractTool;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.project.ui.tool.ModalTool;
import net.refractions.udig.project.ui.tool.ToolLifecycleEvent;
import org.eclipse.jface.action.IStatusLineManager;

public abstract class AbstractModalTool
extends AbstractTool
implements ModalTool {
    private boolean active;
    private String currentCursorID;

    public AbstractModalTool() {
        super(1);
    }

    public AbstractModalTool(int targets) {
        super(targets);
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
        this.setStatusBarMessage(active);
        if (!active) {
            this.deregisterMouseListeners();
        } else if (this.isEnabled()) {
            this.registerMouseListeners();
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    private void setStatusBarMessage(boolean active) {
        this.getContext().updateUI(new Runnable(){

            @Override
            public void run() {
                if (AbstractModalTool.this.getContext().getActionBars() == null) {
                    return;
                }
                IStatusLineManager bar = AbstractModalTool.this.getContext().getActionBars().getStatusLineManager();
                if (bar != null) {
                    bar.setMessage("");
                    bar.setErrorMessage("");
                }
            }
        });
    }

    @Override
    public void setContext(IToolContext context) {
        this.deregisterMouseListeners();
        this.context = context;
        if (this.isActive() && this.isEnabled()) {
            this.registerMouseListeners();
        }
    }

    @Override
    public final String getCursorID() {
        return this.currentCursorID;
    }

    @Override
    public final void setCursorID(String id) {
        this.currentCursorID = id;
        if (this.isActive() && this.getContext() != null && !this.getContext().getViewportPane().isDisposed()) {
            this.getContext().getViewportPane().setCursor(ApplicationGIS.getToolManager().findToolCursor(this.currentCursorID));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldValue = this.isEnabled();
        boolean tempNotify = this.isNotifyListeners();
        this.setNotifyListeners(false);
        super.setEnabled(enabled);
        this.setNotifyListeners(tempNotify);
        if (oldValue != enabled) {
            IToolContext toolContext = this.getContext();
            if (!enabled) {
                if (toolContext != null) {
                    if (this.isActive()) {
                        this.deregisterMouseListeners();
                    }
                    this.setProperty("latestCursorId", this.getCursorID());
                    this.setCursorID("no");
                }
            } else if (toolContext != null) {
                if (this.isActive()) {
                    this.registerMouseListeners();
                }
                String defaultCursorId = (String)this.getProperty("latestCursorId");
                this.setCursorID(defaultCursorId);
            }
        }
        if (this.isNotifyListeners() && oldValue != enabled) {
            ToolLifecycleEvent event = new ToolLifecycleEvent(this, ToolLifecycleEvent.Type.ENABLE, enabled, oldValue);
            this.fireEvent(event);
        }
    }
}

