/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.tileset;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.preferences.PreferenceConstants;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class TileSetControl
extends FieldEditorPreferencePage {
    private ZoomItemListEditor editor;
    private SizeStringFieldEditor width;
    private SizeStringFieldEditor height;
    private ImageTypeFieldEditor imageType;
    private TileSetBooleanFieldEditor checkbox;
    private IGeoResource resource;

    public TileSetControl(IGeoResource resource) {
        super(1);
        this.setDescription(Messages.TileSet_dialog_description);
        this.noDefaultAndApplyButton();
        this.resource = resource;
    }

    protected void createFieldEditors() {
        String scales;
        Boolean enabled;
        String imageTypeValue;
        String widthValue;
        Map props = this.resource.getPersistentProperties();
        String heightValue = (String)props.get("tilesetHeight");
        if (heightValue == null) {
            heightValue = PreferenceConstants.DEFAULT_TILE_SIZE.toString();
        }
        if ((widthValue = (String)props.get("tilesetWidth")) == null) {
            widthValue = PreferenceConstants.DEFAULT_TILE_SIZE.toString();
        }
        if ((imageTypeValue = (String)props.get("tilesetImageType")) == null) {
            imageTypeValue = "image/png";
        }
        if ((enabled = (Boolean)props.get("tilesetOnOff")) == null) {
            enabled = true;
        }
        if ((scales = (String)props.get("tilesetScales")) == null) {
            scales = "";
        }
        this.checkbox = new TileSetBooleanFieldEditor("tilesetOnOff", Messages.TileSet_dialog_onoff_desc, enabled, this.getFieldEditorParent());
        this.width = new SizeStringFieldEditor("tilesetWidth", Messages.TileSet_dialog_width, widthValue, this.getFieldEditorParent());
        this.height = new SizeStringFieldEditor("tilesetHeight", Messages.TileSet_dialog_heigth, heightValue, this.getFieldEditorParent());
        this.imageType = new ImageTypeFieldEditor("tilesetImageType", Messages.TileSet_dialog_image_type, imageTypeValue, this.getFieldEditorParent());
        this.editor = new ZoomItemListEditor("tilesetScales", Messages.TileSet_dialog_zoom_desc, scales, this.getFieldEditorParent());
        this.width.setEnabled(enabled, this.getFieldEditorParent());
        this.height.setEnabled(enabled, this.getFieldEditorParent());
        this.editor.setEnabled(enabled, this.getFieldEditorParent());
        this.imageType.setEnabled(enabled, this.getFieldEditorParent());
        if (scales == null || "".equals(scales)) {
            this.loadDefaults();
        }
        this.addField((FieldEditor)this.checkbox);
        this.addField((FieldEditor)this.width);
        this.addField((FieldEditor)this.height);
        this.addField((FieldEditor)this.imageType);
        this.addField((FieldEditor)this.editor);
    }

    public void loadDefaults() {
        this.width.doLoadDefault();
        this.height.doLoadDefault();
        this.imageType.doLoadDefault();
        this.editor.doLoadDefault();
        this.checkbox.doLoadDefault();
    }

    public boolean performOk() {
        this.resource.getPersistentProperties().put("tilesetOnOff", this.checkbox.getBooleanValue());
        this.resource.getPersistentProperties().put("tilesetWidth", this.width.getStringValue());
        this.resource.getPersistentProperties().put("tilesetHeight", this.height.getStringValue());
        this.resource.getPersistentProperties().put("tilesetImageType", this.imageType.getStringValue());
        this.resource.getPersistentProperties().put("tilesetScales", this.editor.getAsListString());
        return true;
    }

    private class ImageTypeFieldEditor
    extends StringFieldEditor {
        public ImageTypeFieldEditor(String name, String labelText, String value, Composite parent) {
            super(name, labelText, parent);
            this.getTextControl().setText(value);
        }

        protected void doLoadDefault() {
            this.getTextControl().setText("image/png");
            this.setEnabled(false, TileSetControl.this.getFieldEditorParent());
        }
    }

    private class SizeStringFieldEditor
    extends StringFieldEditor {
        public SizeStringFieldEditor(String name, String labelText, String value, Composite parent) {
            super(name, labelText, parent);
            this.getTextControl().setText(value);
        }

        protected void doLoadDefault() {
            this.getTextControl().setText(PreferenceConstants.DEFAULT_TILE_SIZE.toString());
            this.setEnabled(false, TileSetControl.this.getFieldEditorParent());
        }
    }

    private class TileSetBooleanFieldEditor
    extends BooleanFieldEditor {
        public TileSetBooleanFieldEditor(String pTilesetOnOff, String tileSet_dialog_onoff_desc, boolean value, Composite fieldEditorParent) {
            super(pTilesetOnOff, tileSet_dialog_onoff_desc, fieldEditorParent);
            this.getChangeControl(TileSetControl.this.getFieldEditorParent()).setSelection(value);
            this.getChangeControl(TileSetControl.this.getFieldEditorParent()).addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    TileSetControl.this.editor.setEnabled(TileSetBooleanFieldEditor.this.getBooleanValue(), TileSetControl.this.getFieldEditorParent());
                    TileSetControl.this.width.setEnabled(TileSetBooleanFieldEditor.this.getBooleanValue(), TileSetControl.this.getFieldEditorParent());
                    TileSetControl.this.imageType.setEnabled(TileSetBooleanFieldEditor.this.getBooleanValue(), TileSetControl.this.getFieldEditorParent());
                    TileSetControl.this.height.setEnabled(TileSetBooleanFieldEditor.this.getBooleanValue(), TileSetControl.this.getFieldEditorParent());
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
        }

        protected void doLoadDefault() {
            this.setPresentsDefaultValue(true);
            this.getChangeControl(TileSetControl.this.getFieldEditorParent()).setSelection(false);
        }
    }

    protected class ZoomItemListEditor
    extends ListEditor {
        protected ZoomItemListEditor(String name, String labelText, String scales, Composite parent) {
            super(name, labelText, parent);
            this.getUpButton().setVisible(false);
            this.getDownButton().setVisible(false);
            this.loadScales(this.parseString(scales));
        }

        protected String getNewInputObject() {
            String str = null;
            InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.TileSet_dialog_new_title, Messages.TileSet_dialog_new_desc, str, null);
            int result = dialog.open();
            if (result == 0) {
                str = dialog.getValue();
            }
            if (str == null || "".equals(str)) {
                return null;
            }
            try {
                Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (this.inList(str)) {
                return null;
            }
            return str;
        }

        private void loadScales(String[] scales) {
            String[] stringArray = scales;
            int n = scales.length;
            int n2 = 0;
            while (n2 < n) {
                String scale = stringArray[n2];
                this.getList().add(scale);
                ++n2;
            }
        }

        protected void doLoadDefault() {
            this.getList().removeAll();
            SortedSet defaultScales = ApplicationGIS.getActiveMap().getViewportModel().getDefaultPreferredScaleDenominators();
            Double[] scales = new Double[defaultScales.size()];
            defaultScales.toArray(scales);
            int i = scales.length - 1;
            while (i >= 0) {
                Double scale = scales[i];
                this.getList().add(scale.toString());
                --i;
            }
            this.setEnabled(false, TileSetControl.this.getFieldEditorParent());
        }

        public String getAsListString() {
            return this.createList(this.getList().getItems());
        }

        private boolean inList(String str) {
            List<String> list = Arrays.asList(this.getList().getItems());
            return list.contains(str);
        }

        protected String[] parseString(String stringList) {
            String[] items = stringList.split(" ");
            return items;
        }

        protected String createList(String[] items) {
            StringBuilder stringList = new StringBuilder();
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (stringList.length() > 0) {
                    stringList.append(" ");
                }
                stringList.append(str);
                ++n2;
            }
            return stringList.toString();
        }
    }
}

