/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.render.displayAdapter;

import java.awt.Point;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import org.eclipse.swt.SWT;

public class MapMouseEvent {
    public static final int NONE = 0;
    public static final int ALT_DOWN_MASK = 65536;
    public static final int CTRL_DOWN_MASK = 262144;
    public static final int SHIFT_DOWN_MASK = 131072;
    public static final int MOD1_DOWN_MASK = SWT.MOD1;
    public static final int MOD2_DOWN_MASK = SWT.MOD2;
    public static final int MOD3_DOWN_MASK = SWT.MOD3;
    public static final int MOD4_DOWN_MASK = SWT.MOD4;
    public static final int BUTTON1 = 8;
    public static final int BUTTON2 = 16;
    public static final int BUTTON3 = 32;
    public final IMapDisplay source;
    public final int state;
    public final int buttons;
    public final int modifiers;
    public final int button;
    public final int x;
    public final int y;
    public final long timestamp;

    public MapMouseEvent(IMapDisplay source, int x, int y, int modifiers, int buttons, int button) {
        this.source = source;
        this.state = modifiers | buttons;
        this.x = x;
        this.y = y;
        this.button = button;
        this.buttons = buttons;
        this.modifiers = modifiers & SWT.MODIFIER_MASK;
        this.timestamp = System.currentTimeMillis();
    }

    public Point getPoint() {
        return new Point(this.x, this.y);
    }

    public boolean isShiftDown() {
        return this.isModifierDown(131072);
    }

    public boolean isControlDown() {
        return this.isModifierDown(262144);
    }

    public boolean isAltDown() {
        return this.isModifierDown(65536);
    }

    public boolean isModifierDown(int mask) {
        return (this.modifiers & mask) != 0;
    }

    public boolean modifiersDown() {
        return this.modifiers != 0;
    }

    public boolean buttonsDown() {
        return this.buttons != 0;
    }
}

