/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.operations.example;

import com.vividsolutions.jts.geom.Envelope;
import java.text.MessageFormat;
import java.util.ArrayList;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.summary.SummaryData;
import net.refractions.udig.project.ui.summary.SummaryDialog;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LayerSummary
implements IOp {
    public void op(final Display display, Object target, IProgressMonitor monitor) throws Exception {
        final Layer layer = (Layer)target;
        CoordinateReferenceSystem layerCRS = layer.getCRS();
        ReferencedEnvelope bounds = layer.getBounds(monitor, layerCRS);
        final ArrayList<SummaryData> data = new ArrayList<SummaryData>();
        data.add(new SummaryData(Messages.LayerSummary_name, layer.getName()));
        data.add(new SummaryData(Messages.LayerSummary_id, layer.getID()));
        data.add(new SummaryData(Messages.LayerSummary_zorder, layer.getZorder()));
        data.add(new SummaryData(Messages.LayerSummary_crs, layerCRS.getName()));
        data.add(new SummaryData(Messages.LayerSummary_bounds, LayerSummary.parseBounds((Envelope)bounds)));
        data.add(new SummaryData(Messages.LayerSummary_selection, layer.getFilter()));
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                SummaryDialog d = new SummaryDialog(display.getActiveShell(), String.valueOf(Messages.LayerSummary_title) + layer.getName(), data);
                d.setBlockOnOpen(true);
                d.open();
            }
        });
    }

    public static String parseBounds(Envelope env) {
        String minx = LayerSummary.chopDouble(env.getMinX());
        String maxx = LayerSummary.chopDouble(env.getMaxX());
        String miny = LayerSummary.chopDouble(env.getMinY());
        String maxy = LayerSummary.chopDouble(env.getMaxY());
        return MessageFormat.format(Messages.LayerSummary_boundsFormat, minx, miny, maxx, maxy);
    }

    private static String chopDouble(double d) {
        String s = String.valueOf(d);
        int end = s.indexOf(46) + 2;
        while (end > s.length()) {
            --end;
        }
        return s.substring(0, end);
    }
}

