/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.operations.example;

import com.vividsolutions.jts.geom.Envelope;
import java.text.MessageFormat;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.opengis.filter.Filter;

public class FeaturesInView
implements IOp {
    public void op(final Display display, Object target, IProgressMonitor monitor) throws Exception {
        IMap map = (IMap)target;
        Exception e = null;
        int featureCount = 0;
        for (ILayer layer : map.getMapLayers()) {
            if (!layer.isType(FeatureSource.class) || !layer.isVisible()) continue;
            try {
                FeatureSource source = (FeatureSource)layer.getResource(FeatureSource.class, monitor);
                Filter filter = layer.createBBoxFilter((Envelope)map.getViewportModel().getBounds(), monitor);
                FeatureCollection results = source.getFeatures((Query)new DefaultQuery(layer.getSchema().getName().getLocalPart(), filter));
                int count = results.size();
                if (count <= 0) continue;
                featureCount += count;
            }
            catch (Exception e1) {
                e = e1;
            }
        }
        final Exception exception = e;
        final int finalCount = featureCount;
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (exception == null) {
                    MessageDialog.openInformation((Shell)display.getActiveShell(), (String)Messages.FeaturesInView_0, (String)(String.valueOf(Messages.FeaturesInView_1) + finalCount));
                } else {
                    MessageDialog.openInformation((Shell)display.getActiveShell(), (String)Messages.FeaturesInView_0, (String)MessageFormat.format(Messages.FeaturesInView_3, finalCount));
                }
            }
        });
    }
}

