/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.operations;

import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.factory.SelectionCommandFactory;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SelectAllFeaturesOp
implements IOp {
    public void op(Display display, Object target, IProgressMonitor monitor) throws Exception {
        ILayer layer = (ILayer)target;
        SimpleFeatureSource source = (SimpleFeatureSource)layer.getResource(FeatureSource.class, (IProgressMonitor)new NullProgressMonitor());
        SimpleFeatureType schema = (SimpleFeatureType)source.getSchema();
        GeometryDescriptor geometryDescriptor = schema.getGeometryDescriptor();
        IViewportModel viewportModel = ApplicationGIS.getActiveMap().getViewportModel();
        ReferencedEnvelope bounds = viewportModel.getBounds();
        CoordinateReferenceSystem dataCrs = schema.getCoordinateReferenceSystem();
        ReferencedEnvelope newBounds = bounds.transform(dataCrs, true);
        String name = geometryDescriptor.getLocalName();
        Filter bboxFilter = SelectAllFeaturesOp.getBboxFilter(name, (BoundingBox)newBounds);
        SelectionCommandFactory cmdFactory = SelectionCommandFactory.getInstance();
        UndoableMapCommand selectCommand = cmdFactory.createSelectCommand(layer, bboxFilter);
        IToolContext toolContext = ApplicationGIS.createContext(ApplicationGIS.getActiveMap());
        toolContext.sendASyncCommand((Command)selectCommand);
    }

    public static Filter getBboxFilter(String attribute, BoundingBox bbox) throws CQLException {
        double w = bbox.getMinX();
        double e = bbox.getMaxX();
        double s = bbox.getMinY();
        double n = bbox.getMaxY();
        return SelectAllFeaturesOp.getBboxFilter(attribute, w, e, s, n);
    }

    public static Filter getBboxFilter(String attribute, double west, double east, double south, double north) throws CQLException {
        if (attribute == null) {
            attribute = "the_geom";
        }
        StringBuilder sB = new StringBuilder();
        sB.append("BBOX(");
        sB.append(attribute);
        sB.append(",");
        sB.append(west);
        sB.append(",");
        sB.append(south);
        sB.append(",");
        sB.append(east);
        sB.append(",");
        sB.append(north);
        sB.append(")");
        Filter bboxFilter = CQL.toFilter((String)sB.toString());
        return bboxFilter;
    }
}

