/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.wizard;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class NewProjectWizardPage
extends WizardPage {
    DirectoryFieldEditor projectDirectoryEditor;
    StringFieldEditor projectNameEditor;

    public NewProjectWizardPage() {
        super(Messages.NewProjectWizardPage_newProject, Messages.NewProjectWizardPage_newProject, ProjectUIPlugin.getDefault().getImageDescriptor("wizban/newprj_wiz.gif"));
        this.setDescription(Messages.NewProjectWizardPage_newProject_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.projectNameEditor = new StringFieldEditor("newproject.name", Messages.NewProjectWizardPage_label_projectName, composite){

            protected boolean doCheckState() {
                return NewProjectWizardPage.this.validate();
            }
        };
        this.projectNameEditor.setPage((DialogPage)this);
        this.projectNameEditor.setValidateStrategy(0);
        Text textControl = this.projectNameEditor.getTextControl(composite);
        GridData gd = new GridData(16384, 0, false, false);
        gd.widthHint = 100;
        gd.horizontalSpan = 2;
        textControl.setLayoutData((Object)gd);
        this.projectDirectoryEditor = new DirectoryFieldEditor("newproject.directory", Messages.NewProjectWizardPage_label_projectDir, composite){

            protected boolean doCheckState() {
                return NewProjectWizardPage.this.validate();
            }
        };
        this.projectDirectoryEditor.setPage((DialogPage)this);
        this.projectDirectoryEditor.setValidateStrategy(0);
        this.projectDirectoryEditor.fillIntoGrid(composite, 3);
        String defaultProjectName = Messages.NewProjectWizardPage_default_name;
        IPath homepath = Platform.getLocation();
        String projectPath = new File(homepath.toString()).getAbsolutePath();
        this.projectNameEditor.setStringValue(defaultProjectName);
        this.projectDirectoryEditor.setStringValue(projectPath);
        composite.pack();
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public String getProjectName() {
        return this.projectNameEditor.getStringValue();
    }

    public String getProjectPath() {
        return this.projectDirectoryEditor.getStringValue();
    }

    public boolean validate() {
        String projectPath = this.getProjectPath();
        String projectName = this.getProjectName();
        if (projectPath == null || projectPath.length() == 0) {
            this.setErrorMessage(Messages.NewProjectWizardPage_err_project_dir_valid);
            this.setPageComplete(false);
            return false;
        }
        File f = new File(String.valueOf(projectPath) + File.separator + projectName + ".udig");
        if (f.exists()) {
            this.setErrorMessage(Messages.NewProjectWizardPage_err_project_exists);
            this.setPageComplete(false);
            return false;
        }
        File projectPathFolder = null;
        try {
            URL projectURL = new URL("file:///" + projectPath);
            projectPathFolder = new File(projectURL.getFile());
            String absolutePath = projectPathFolder.getAbsolutePath();
            if (!projectPath.equals(absolutePath)) {
                this.setErrorMessage(Messages.NewProjectWizardPage_err_project_dir_absolute);
                this.setPageComplete(false);
                return false;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            this.setPageComplete(false);
            return false;
        }
        if (projectPathFolder.exists()) {
            String projectFileAbsolutePath = String.valueOf(projectPathFolder.getAbsolutePath()) + File.separatorChar + "project.uprj";
            File projectFile = new File(projectFileAbsolutePath);
            if (projectFile.exists()) {
                this.setErrorMessage(Messages.NewProjectWizardPage_err_project_exists);
                this.setPageComplete(false);
                return false;
            }
        } else {
            this.setErrorMessage(Messages.NewProjectWizardPage_err_project_dir_valid);
            this.setPageComplete(false);
            return false;
        }
        if (projectName == null || projectName.length() == 0) {
            this.setErrorMessage(Messages.NewProjectWizardPage_err_project_name);
            this.setPageComplete(false);
            return false;
        }
        this.setPageComplete(true);
        return true;
    }
}

