/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.wizard.NewProjectWizardPage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewProjectWizard
extends Wizard
implements INewWizard {
    protected NewProjectWizardPage page;

    public void setPage(NewProjectWizardPage page) {
        this.page = page;
        this.setWindowTitle(page.getTitle());
    }

    public void addPages() {
        this.page = new NewProjectWizardPage();
        this.addPage((IWizardPage)this.page);
        this.setWindowTitle(this.page.getTitle());
        this.setHelpAvailable(true);
    }

    public boolean performFinish() {
        if (!this.page.validate()) {
            return false;
        }
        String projectPath = this.page.getProjectPath();
        String projectName = this.page.getProjectName();
        projectPath = projectPath.replaceAll("\\\\", "/");
        while (projectPath.endsWith("/")) {
            projectPath = projectPath.substring(0, projectPath.length() - 2);
        }
        Project project = ProjectPlugin.getPlugin().getProjectRegistry().getProject(String.valueOf(projectPath) + File.separator + projectName + ".udig");
        project.setName(projectName);
        Resource projectResource = project.eResource();
        try {
            projectResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            ProjectUIPlugin.log("Error during saving the project file of an anew created project", e);
        }
        return true;
    }

    public boolean canFinish() {
        return this.page.isPageComplete();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

