/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.tool.display;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.internal.ui.operations.OperationCategory;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.MapEditorSelectionProvider;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.tool.display.CursorProxy;
import net.refractions.udig.project.ui.internal.tool.display.HandlerProxy;
import net.refractions.udig.project.ui.internal.tool.display.ModalItem;
import net.refractions.udig.project.ui.internal.tool.display.ModalToolCategory;
import net.refractions.udig.project.ui.internal.tool.display.ToolAction;
import net.refractions.udig.project.ui.internal.tool.display.ToolManager;
import net.refractions.udig.project.ui.tool.AbstractTool;
import net.refractions.udig.project.ui.tool.ActionTool;
import net.refractions.udig.project.ui.tool.IMapEditorSelectionProvider;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.project.ui.tool.ModalTool;
import net.refractions.udig.project.ui.tool.Tool;
import net.refractions.udig.project.ui.tool.ToolLifecycleListener;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.operations.EnablementUtil;
import net.refractions.udig.ui.operations.ILazyOpListener;
import net.refractions.udig.ui.operations.LazyOpFilter;
import net.refractions.udig.ui.operations.OpFilter;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ToolProxy
extends ModalItem
implements ModalTool,
ActionTool {
    Tool tool = null;
    IToolContext toolContext = null;
    IConfigurationElement element = null;
    boolean hasControl = false;
    String defaultCursorID;
    private boolean onToolbar = true;
    int type = -1;
    static final int MODAL = 1;
    static final int BACKGROUND = 2;
    static final int ACTION = 3;
    private String categoryId;
    private static final String DEFAULT_ID = "net.refractions.udig.tools.Zoom";
    private volatile IAction action;
    private String menuPath;
    private boolean disposed = false;
    private volatile IMapEditorSelectionProvider selectionProviderInstance;
    private ToolManager toolManager;
    Lock enabledLock = new ReentrantLock(true);
    private Lock selectionProviderLock = new ReentrantLock();

    public ToolProxy(IExtension extension, IConfigurationElement definition, ToolManager toolManager) {
        ImageDescriptor icon;
        this.toolManager = toolManager;
        this.categoryId = definition.getAttribute("categoryId");
        String type = definition.getName();
        String pluginid = extension.getNamespaceIdentifier();
        String id = definition.getAttribute("id");
        String name = definition.getAttribute("name");
        if (name == null) {
            name = Messages.ToolProxy_unnamed;
        }
        String toolTip = definition.getAttribute("tooltip");
        String iconID = definition.getAttribute("icon");
        String largeIconID = definition.getAttribute("largeIcon");
        String preferencePageId = definition.getAttribute("preferencePageId");
        this.setPreferencePageId(preferencePageId);
        this.defaultCursorID = definition.getAttribute("toolCursorId");
        if (this.defaultCursorID == null) {
            IConfigurationElement[] children = definition.getChildren("cursor");
            if (children.length > 0) {
                CursorProxy cursorProxy = new CursorProxy(children[0]);
                toolManager.cursorsCache.put(cursorProxy.getID(), cursorProxy);
                this.defaultCursorID = cursorProxy.getID();
            } else {
                this.defaultCursorID = "default";
            }
        }
        OpFilter parseEnablement = EnablementUtil.parseEnablement((String)(String.valueOf(extension.getNamespaceIdentifier()) + "." + definition.getName()), (IConfigurationElement[])definition.getChildren("enablement"));
        this.enablement = new LazyOpFilter((ILazyOpListener)this, parseEnablement);
        this.operationCategories = this.parseOperationCategories(definition);
        String bool = definition.getAttribute("hasCustomControl");
        this.hasControl = bool != null && bool.equalsIgnoreCase("true");
        bool = definition.getAttribute("onToolbar");
        this.onToolbar = bool != null && bool.equalsIgnoreCase("true");
        this.menuPath = definition.getAttribute("menuPath");
        if (iconID == null) {
            icon = null;
        } else {
            icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginid, (String)iconID);
            this.setImageDescriptor(icon);
        }
        if (largeIconID == null) {
            this.setLargeImageDescriptor(icon);
        } else {
            ImageDescriptor largeIcon = icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginid, (String)largeIconID);
            this.setLargeImageDescriptor(largeIcon);
        }
        this.element = definition;
        this.setName(name);
        this.setToolTipText(toolTip);
        this.setId(id);
        if (type.equals("modalTool")) {
            this.type = 1;
        } else if (type.equals("backgroundTool")) {
            this.type = 2;
        } else if (type.equals("actionTool")) {
            this.type = 3;
        }
        this.handlerType = definition.getAttribute("commandHandler");
        String unparsedCommandIds = definition.getAttribute("commandIds");
        this.commandIds = unparsedCommandIds != null && unparsedCommandIds.length() > 0 ? unparsedCommandIds.split(",") : new String[0];
        if (id.equals(DEFAULT_ID)) {
            toolManager.defaultModalToolProxy = this;
        }
    }

    private List<OperationCategory> parseOperationCategories(IConfigurationElement toolElement) {
        IConfigurationElement[] children = toolElement.getChildren("operationCategory");
        if (children == null || children.length == 0) {
            return null;
        }
        Map categories = UiPlugin.getDefault().getOperationMenuFactory().getCategories();
        ArrayList<OperationCategory> results = new ArrayList<OperationCategory>();
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String opCategoryID = element.getAttribute("categoryID");
            if (opCategoryID == null || opCategoryID.length() == 0) {
                ProjectUIPlugin.log("Warning: CategoryID attribute of operationCategory element in tool '" + this.id + "' is empty.", null);
            } else {
                OperationCategory opCategory = (OperationCategory)categories.get(opCategoryID);
                if (opCategory == null) {
                    ProjectUIPlugin.log("Warning: CategoryID attribute of operationCategory element in tool '" + this.id + "' cannot be found. Does it actually exist?", null);
                } else {
                    results.add(opCategory);
                }
            }
            ++n2;
        }
        return results;
    }

    public int getStyle() {
        if (this.type == 1) {
            return 8;
        }
        return 1;
    }

    @Override
    public void setContext(IToolContext toolContext) {
        this.toolContext = toolContext;
        if (this.type == 2) {
            this.getTool().setContext(toolContext);
        } else if (this.type == 1 && this.toolManager.getActiveToolProxy() == this) {
            ModalTool modalTool = this.getModalTool();
            modalTool.setContext(toolContext);
            String currentCursorID = modalTool.getCursorID();
            toolContext.getViewportPane().setCursor(ApplicationGIS.getToolManager().findToolCursor(currentCursorID));
        } else if (this.tool != null) {
            this.getTool().setContext(toolContext);
        }
    }

    public String toString() {
        return this.getId();
    }

    ModalTool getModalTool() {
        return (ModalTool)this.getTool();
    }

    ActionTool getModelessTool() {
        return (ActionTool)this.getTool();
    }

    public Tool getTool() {
        if (this.tool == null) {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            final Display finalDisplay = display;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    BusyIndicator.showWhile((Display)finalDisplay, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            IConfigurationElement[] toolElementChildren;
                            String klassName = (this).ToolProxy.this.element.getAttribute("class");
                            if (klassName != null) {
                                try {
                                    Object o = (this).ToolProxy.this.element.createExecutableExtension("class");
                                    (this).ToolProxy.this.tool = (Tool)o;
                                    if ((this).ToolProxy.this.tool instanceof AbstractTool) {
                                        ((AbstractTool)(this).ToolProxy.this.tool).init((this).ToolProxy.this.element);
                                    }
                                    if ((this).ToolProxy.this.tool instanceof ModalTool && (this).ToolProxy.this.defaultCursorID != null) {
                                        ((ModalTool)(this).ToolProxy.this.tool).setCursorID((this).ToolProxy.this.defaultCursorID);
                                        (this).ToolProxy.this.tool.setProperty("defaultCursorId", (this).ToolProxy.this.defaultCursorID);
                                    }
                                    (this).ToolProxy.this.tool.setContext((this).ToolProxy.this.toolContext);
                                    (this).ToolProxy.this.tool.setEnabled(ToolProxy.this.isEnabled());
                                    if ((this).ToolProxy.this.tool instanceof ModalTool) {
                                        IMapEditorSelectionProvider selectionProvider = ToolProxy.this.getSelectionProvider();
                                        ModalTool modalTool = (ModalTool)(this).ToolProxy.this.tool;
                                        modalTool.setSelectionProvider(selectionProvider);
                                    }
                                }
                                catch (CoreException e) {
                                    ProjectUIPlugin.log("Error loading tool", e);
                                }
                            }
                            IConfigurationElement[] iConfigurationElementArray = toolElementChildren = (this).ToolProxy.this.element.getChildren();
                            int n = toolElementChildren.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IConfigurationElement toolElement = iConfigurationElementArray[n2];
                                if (toolElement.getAttribute("class") != null) {
                                    try {
                                        String contributionId = toolElement.getAttribute("id");
                                        Object optionsContribution = toolElement.createExecutableExtension("class");
                                        ContributionItem contributionItem = (ContributionItem)optionsContribution;
                                        contributionItem.setId(contributionId);
                                        ToolProxy.this.addOptionsContribution((ContributionItem)optionsContribution);
                                    }
                                    catch (CoreException e) {
                                        e.printStackTrace();
                                    }
                                }
                                ++n2;
                            }
                        }
                    });
                }
            };
            PlatformGIS.syncInDisplayThread((Runnable)runnable);
        }
        return this.tool;
    }

    public int getType() {
        return this.type;
    }

    public String getMenuPath() {
        return this.menuPath;
    }

    public boolean isOnToolbar() {
        return this.onToolbar;
    }

    @Override
    public IToolContext getContext() {
        return this.toolContext;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAction getAction() {
        if (this.action == null) {
            ToolProxy toolProxy = this;
            synchronized (toolProxy) {
                if (this.action == null) {
                    this.action = new ToolAction(this);
                }
                this.action.setEnabled(this.isEnabled());
            }
        }
        return this.action;
    }

    @Override
    public boolean isEnabled() {
        if (this.tool == null) {
            return super.isEnabled();
        }
        return this.tool.isEnabled();
    }

    @Override
    public void setEnabled(final boolean enabled) {
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ToolProxy.this.toolProxySetEnabled(enabled);
            }
        });
    }

    protected void toolProxySetEnabled(boolean enabled) {
        this.enabledLock.lock();
        try {
            super.setEnabled(enabled);
            if (this.tool != null) {
                this.tool.setEnabled(enabled);
            }
            if (this.action != null) {
                this.action.setEnabled(enabled);
            }
        }
        finally {
            this.enabledLock.unlock();
        }
    }

    @Override
    public void run() {
        if (this.isModeless()) {
            this.runModeless();
            if (this.isEnabled()) {
                return;
            }
        } else {
            PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToolProxy.this.runModal();
                }
            });
        }
    }

    @Override
    protected void runModal() {
        this.setActive(true);
        ToolProxy activeToolProxy = this.getActiveItem();
        if (activeToolProxy != this) {
            if (activeToolProxy != null) {
                activeToolProxy.setActive(false);
            }
            this.setActiveItem(this);
        }
    }

    @Override
    protected boolean isModeless() {
        return this.type == 3;
    }

    @Override
    protected void runModeless() {
        if (this.type != 3) {
            throw new IllegalStateException("runModeless expects ACTION");
        }
        PlatformGIS.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                ToolProxy.this.getModelessTool().run();
            }

            public void handleException(Throwable exception) {
                ProjectUIPlugin.log("Error occured while executing tool: " + ToolProxy.this.getId(), exception);
            }
        });
    }

    @Override
    public void setActive(boolean active) {
        if (this.toolContext == null) {
            return;
        }
        this.setChecked(active);
        if (this.getTool() instanceof ModalTool && this.isActive() != active) {
            ModalTool modalTool = this.getModalTool();
            modalTool.setActive(active);
            if (active) {
                this.toolManager.setActiveModalToolProxy(this);
            }
        }
    }

    @Override
    public void dispose() {
        this.disposed = true;
        if (this.tool != null) {
            this.tool.dispose();
        }
    }

    @Override
    public IHandler getHandler(String commandId) {
        if (this.handlerType != null && this.handlerType.length() > 0) {
            return new HandlerProxy(this.element, this, commandId);
        }
        return null;
    }

    @Override
    protected ModalItem getDefaultItem() {
        return this.toolManager.defaultModalToolProxy;
    }

    @Override
    protected ToolProxy getActiveItem() {
        return this.toolManager.getActiveToolProxy();
    }

    @Override
    protected void setActiveItem(ModalItem modalItem) {
        this.toolManager.setActiveModalToolProxy((ToolProxy)modalItem);
    }

    @Override
    public boolean isActive() {
        return this.getModalTool().isActive();
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public IMapEditorSelectionProvider getSelectionProvider() {
        if (this.selectionProviderInstance == null) {
            this.selectionProviderLock.lock();
            try {
                ToolManager m;
                ModalToolCategory cat;
                if (this.selectionProviderInstance != null) {
                    IMapEditorSelectionProvider iMapEditorSelectionProvider = this.selectionProviderInstance;
                    return iMapEditorSelectionProvider;
                }
                if (this.element.getAttribute("selectionProvider") != null) {
                    try {
                        this.selectionProviderInstance = (IMapEditorSelectionProvider)this.element.createExecutableExtension("selectionProvider");
                    }
                    catch (CoreException e) {
                        ProjectUIPlugin.log("Error instantiating selection provider for " + this.element.getNamespaceIdentifier() + "/" + this.element.getName(), e);
                    }
                    if (this.selectionProviderInstance != null) {
                        IMapEditorSelectionProvider iMapEditorSelectionProvider = this.selectionProviderInstance;
                        return iMapEditorSelectionProvider;
                    }
                }
                this.selectionProviderInstance = (cat = (m = (ToolManager)ApplicationGIS.getToolManager()).findModalCategory(this.getCategoryId())) != null ? cat.getSelectionProvider() : new MapEditorSelectionProvider();
            }
            finally {
                this.selectionProviderLock.unlock();
            }
        }
        return this.selectionProviderInstance;
    }

    @Override
    public String getCursorID() {
        throw new UnsupportedOperationException("Call ToolProxy.getTool().getCursorID() method instead");
    }

    @Override
    public void setCursorID(String id) {
        throw new UnsupportedOperationException("Call ToolProxy.getTool().setCursorID(String) method instead");
    }

    @Override
    public Object getProperty(String key) {
        throw new UnsupportedOperationException("Call ToolProxy.getTool().getProperty(String) method instead");
    }

    @Override
    public void setProperty(String key, Object value) {
        throw new UnsupportedOperationException("Call ToolProxy.getTool().setProperty(String, String) method instead");
    }

    @Override
    public void addListener(ToolLifecycleListener listener) {
        throw new UnsupportedOperationException("Call ToolProxy.getTool().addListener(ToolLifecycleListener) method instead");
    }

    @Override
    public void removeListener(ToolLifecycleListener listener) {
        throw new UnsupportedOperationException("Call ToolProxy.getTool().removeListener(ToolLifecycleListener) method instead");
    }

    public void notifyResultObtained(boolean result) {
        this.setEnabled(result);
    }

    @Override
    public void setSelectionProvider(IMapEditorSelectionProvider selectionProvider) {
        throw new UnsupportedOperationException("Call ToolProxy.getTool().setSelectionProvider(IMapEditorSelectionProvider) method instead");
    }
}

