/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.tool.display;

import java.awt.AWTException;
import java.awt.Robot;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.refractions.udig.core.filter.AdaptingFilter;
import net.refractions.udig.core.filter.AdaptingFilterFactory;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.internal.ui.UDIGDNDProcessor;
import net.refractions.udig.internal.ui.UDIGDropHandler;
import net.refractions.udig.internal.ui.UDigByteAndLocalTransfer;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.internal.ui.operations.OperationCategory;
import net.refractions.udig.internal.ui.operations.OperationMenuFactory;
import net.refractions.udig.internal.ui.operations.RunOperationsAction;
import net.refractions.udig.project.EditManagerEvent;
import net.refractions.udig.project.IEditManagerListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.commands.CreateMapCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.ApplicationGISInternal;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.project.ui.internal.MapEditorWithPalette;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.actions.Delete;
import net.refractions.udig.project.ui.internal.tool.ToolContext;
import net.refractions.udig.project.ui.internal.tool.display.ActionToolCategory;
import net.refractions.udig.project.ui.internal.tool.display.CursorProxy;
import net.refractions.udig.project.ui.internal.tool.display.MenuToolCategory;
import net.refractions.udig.project.ui.internal.tool.display.ModalItem;
import net.refractions.udig.project.ui.internal.tool.display.ModalToolCategory;
import net.refractions.udig.project.ui.internal.tool.display.ToolCategory;
import net.refractions.udig.project.ui.internal.tool.display.ToolProxy;
import net.refractions.udig.project.ui.internal.tool.impl.ToolContextImpl;
import net.refractions.udig.project.ui.tool.IContextMenuContributionTool;
import net.refractions.udig.project.ui.tool.IToolManager;
import net.refractions.udig.project.ui.tool.ModalTool;
import net.refractions.udig.project.ui.tool.Tool;
import net.refractions.udig.project.ui.tool.options.PreferencesShortcutToolOptionsContributionItem;
import net.refractions.udig.project.ui.viewers.MapEditDomain;
import net.refractions.udig.ui.IDropAction;
import net.refractions.udig.ui.IDropHandlerListener;
import net.refractions.udig.ui.UDIGDragDropUtilities;
import net.refractions.udig.ui.ViewerDropLocation;
import net.refractions.udig.ui.operations.ILazyOpListener;
import net.refractions.udig.ui.operations.LazyOpFilter;
import net.refractions.udig.ui.operations.OpAction;
import net.refractions.udig.ui.operations.OpFilter;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubCoolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SubActionBars2;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ViewPart;
import org.opengis.filter.Filter;

public class ToolManager
implements IToolManager {
    Set<IAction> registeredToolActions = new HashSet<IAction>();
    protected List<String> categoryIds = new ArrayList<String>();
    List<ModalToolCategory> modalCategories = new LinkedList<ModalToolCategory>();
    List<ActionToolCategory> actionCategories = new LinkedList<ActionToolCategory>();
    List<MenuToolCategory> menuCategories = new LinkedList<MenuToolCategory>();
    List<ToolProxy> backgroundTools = new LinkedList<ToolProxy>();
    ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
    protected Map<String, CursorProxy> cursorsCache = new HashMap<String, CursorProxy>();
    private ToolProxy activeModalToolProxy;
    private ModalTool activeTool;
    ToolProxy defaultModalToolProxy;
    Lock redoLock = new ReentrantLock();
    Lock undoLock = new ReentrantLock();
    Lock forwardLock = new ReentrantLock();
    Lock backwardLock = new ReentrantLock();
    Lock deleteLock = new ReentrantLock();
    Lock enterLock = new ReentrantLock();
    Lock pasteLock = new ReentrantLock();
    Lock propertiesLock = new ReentrantLock();
    Lock copyLock = new ReentrantLock();
    Lock cutLock = new ReentrantLock();
    private volatile IAction redoAction;
    private volatile IAction undoAction;
    private volatile IAction forwardAction;
    private volatile IAction backwardAction;
    private volatile IAction deleteAction;
    private volatile IAction enterAction;
    private volatile IAction zoomToSelectionAction;
    private volatile IAction pasteAction;
    private volatile IAction copyAction;
    private volatile IAction cutAction;
    private AdapterImpl commandListener;
    private List<ContributionItem> optionsContribution = new ArrayList<ContributionItem>();
    MapPart currentEditor;
    EditManagerListener selectedLayerListener;
    private PropertyDialogAction propertiesAction;
    private IAction actionCLOSE;
    private IAction actionSAVE;
    private IAction actionCLOSE_ALL;
    private PreferencesShortcutToolOptionsContributionItem preferencesShortcutToolOptions;

    public ToolManager() {
        this.processCategories();
        this.processTools();
        this.removeEmptyCategories();
        Collections.sort(this.categoryIds, new CategorySorter());
        this.setCommandHandlers();
    }

    private void processTools() {
        List extensionList = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.project.ui.tool");
        for (IConfigurationElement element : extensionList) {
            ToolProxy proxy;
            String categoryId;
            IExtension extension = element.getDeclaringExtension();
            String type = element.getName();
            if (type.equals("backgroundTool")) {
                ToolProxy proxy2 = new ToolProxy(extension, element, this);
                this.backgroundTools.add(proxy2);
                continue;
            }
            if (type.equals("modalTool")) {
                categoryId = this.getCategoryIdAttribute(element);
                proxy = new ToolProxy(extension, element, this);
                this.addToModalCategory(categoryId, proxy);
                continue;
            }
            if (type.equals("actionTool")) {
                categoryId = this.getCategoryIdAttribute(element);
                proxy = new ToolProxy(extension, element, this);
                this.addToActionCategory(categoryId, proxy);
                this.addToMenuCategory(categoryId, proxy);
                continue;
            }
            if (!type.equals("toolCursor")) continue;
            CursorProxy cursorProxy = new CursorProxy(element);
            this.cursorsCache.put(cursorProxy.getID(), cursorProxy);
        }
        if (this.activeModalToolProxy == null) {
            this.activeModalToolProxy = this.defaultModalToolProxy;
        }
    }

    private String getCategoryIdAttribute(IConfigurationElement element) {
        String id = element.getAttribute("categoryId");
        return id == null ? "" : id;
    }

    @Override
    public Cursor findToolCursor(String cursorID) {
        CursorProxy cursorProxy = this.cursorsCache.get(cursorID);
        if (cursorProxy != null) {
            return cursorProxy.getCursor();
        }
        Cursor systemCursor = CursorProxy.getSystemCursor(cursorID);
        if (systemCursor != null) {
            return systemCursor;
        }
        return null;
    }

    @Override
    public Tool findTool(String toolID) {
        for (ModalToolCategory category : this.modalCategories) {
            for (ModalItem item : category) {
                if (!toolID.equals(item.getId())) continue;
                return ((ToolProxy)item).getTool();
            }
        }
        return null;
    }

    public ToolProxy findToolProxy(String toolID) {
        for (ModalToolCategory modalToolCategory : this.modalCategories) {
            for (ModalItem item : modalToolCategory) {
                if (!toolID.equals(item.getId())) continue;
                return (ToolProxy)item;
            }
        }
        for (ActionToolCategory actionToolCategory : this.actionCategories) {
            for (ModalItem item : actionToolCategory) {
                if (!toolID.equals(item.getId())) continue;
                return (ToolProxy)item;
            }
        }
        for (ToolProxy toolProxy : this.backgroundTools) {
            if (!toolID.equals(toolProxy.getId())) continue;
            return toolProxy;
        }
        return null;
    }

    private void addToModalCategory(String categoryId, ToolProxy proxy) {
        if (this.filterTool(categoryId, proxy, ModalToolCategory.class)) {
            return;
        }
        ModalToolCategory modalCategory = this.findModalCategory(categoryId);
        if (modalCategory == null && (modalCategory = this.findModalCategory(Messages.ToolCategory_other)) == null) {
            modalCategory = new ModalToolCategory(this);
            this.modalCategories.add(modalCategory);
            if (!this.categoryIds.contains(Messages.ToolCategory_other)) {
                this.categoryIds.add(Messages.ToolCategory_other);
            }
        }
        modalCategory.add(proxy);
    }

    protected boolean filterTool(String categoryId, ToolProxy proxy, Class<? extends ToolCategory> categoryType) {
        return false;
    }

    private void addToMenuCategory(String categoryId, ToolProxy proxy) {
        if (this.filterTool(categoryId, proxy, MenuToolCategory.class)) {
            return;
        }
        MenuToolCategory category = this.findMenuCategory(categoryId);
        if (category == null && (category = this.findMenuCategory(Messages.ToolCategory_other)) == null) {
            category = new MenuToolCategory(this);
            this.menuCategories.add(category);
            if (!this.categoryIds.contains(Messages.ToolCategory_other)) {
                this.categoryIds.add(Messages.ToolCategory_other);
            }
        }
        category.add(proxy);
    }

    private void addToActionCategory(String categoryId, ToolProxy proxy) {
        if (this.filterTool(categoryId, proxy, ActionToolCategory.class)) {
            return;
        }
        ActionToolCategory category = this.findActionCategory(categoryId);
        if (category == null && (category = this.findActionCategory(Messages.ToolCategory_other)) == null) {
            category = new ActionToolCategory(this);
            this.actionCategories.add(category);
            if (!this.categoryIds.contains(Messages.ToolCategory_other)) {
                this.categoryIds.add(Messages.ToolCategory_other);
            }
        }
        category.add(proxy);
    }

    private void processCategories() {
        List extension = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.project.ui.tool");
        for (IConfigurationElement element : extension) {
            MenuToolCategory category;
            ActionToolCategory actionCategory;
            if (!element.getName().equals("category")) continue;
            String id = element.getAttribute("id");
            this.categoryIds.add(id);
            ModalToolCategory modalCategory = this.findModalCategory(id);
            if (modalCategory == null) {
                modalCategory = new ModalToolCategory(element, this);
                this.modalCategories.add(modalCategory);
            }
            if ((actionCategory = this.findActionCategory(id)) == null) {
                actionCategory = new ActionToolCategory(element, this);
                this.actionCategories.add(actionCategory);
            }
            if ((category = this.findMenuCategory(id)) != null) continue;
            category = new MenuToolCategory(element, this);
            this.menuCategories.add(category);
        }
    }

    private void removeEmptyCategories() {
        ArrayList<ToolCategory> toRemove = new ArrayList<ToolCategory>();
        for (ActionToolCategory actionToolCategory : this.actionCategories) {
            if (actionToolCategory.items.size() != 0) continue;
            toRemove.add(actionToolCategory);
        }
        this.actionCategories.removeAll(toRemove);
        for (ModalToolCategory modalToolCategory : this.modalCategories) {
            if (modalToolCategory.items.size() != 0) continue;
            toRemove.add(modalToolCategory);
        }
        this.modalCategories.removeAll(toRemove);
        for (MenuToolCategory menuToolCategory : this.menuCategories) {
            if (menuToolCategory.items.size() != 0) continue;
            toRemove.add(menuToolCategory);
        }
        this.menuCategories.removeAll(toRemove);
    }

    private void setCommandHandlers() {
        HashSet<String> ids = new HashSet<String>();
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        for (ModalToolCategory modalToolCategory : this.modalCategories) {
            if (!ids.contains(modalToolCategory.getId())) {
                ids.add(modalToolCategory.getId());
                modalToolCategory.setCommandHandlers(service);
            }
            this.registerCommands(ids, service, modalToolCategory);
        }
        for (ActionToolCategory actionToolCategory : this.actionCategories) {
            if (!ids.contains(actionToolCategory.getId())) {
                ids.add(actionToolCategory.getId());
                actionToolCategory.setCommandHandlers(service);
            }
            this.registerCommands(ids, service, actionToolCategory);
        }
        for (MenuToolCategory menuToolCategory : this.menuCategories) {
            if (!ids.contains(menuToolCategory.getId())) {
                ids.add(menuToolCategory.getId());
                menuToolCategory.setCommandHandlers(service);
            }
            this.registerCommands(ids, service, menuToolCategory);
        }
    }

    private void registerCommands(Set<String> ids, ICommandService service, ToolCategory category) {
        for (ModalItem tool : category) {
            if (ids.contains(tool.getId())) continue;
            ids.add(category.getId());
            String[] stringArray = tool.getCommandIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String currentId = stringArray[n2];
                Command command = service.getCommand(currentId = currentId.trim());
                if (command != null) {
                    command.setHandler(tool.getHandler(currentId));
                }
                ++n2;
            }
        }
    }

    @Override
    public void setCurrentEditor(MapPart editor) {
        if (editor == this.currentEditor) {
            return;
        }
        this.currentEditor = editor;
        if (editor != null) {
            if (editor != null) {
                this.setActiveTool(editor);
                this.setEnabled((IMap)editor.getMap(), this.actionCategories);
                this.setEnabled((IMap)editor.getMap(), this.menuCategories);
                this.setEnabled((IMap)editor.getMap(), this.modalCategories);
            }
        } else {
            this.disable(this.actionCategories);
            this.disable(this.menuCategories);
            this.disable(this.modalCategories);
        }
    }

    private void disable(List<? extends ToolCategory> categories) {
        for (ToolCategory toolCategory : categories) {
            for (ModalItem item : toolCategory) {
                OpFilter enablesFor = item.getEnablesFor();
                if (!(enablesFor instanceof LazyOpFilter)) continue;
                ((LazyOpFilter)enablesFor).disable();
            }
        }
    }

    private void setEnabled(IMap map, Collection<? extends ToolCategory> categories) {
        if (this.selectedLayerListener == null) {
            this.selectedLayerListener = new EditManagerListener();
        }
        this.selectedLayerListener.setCurrentMap(map);
        if (!map.getEditManager().containsListener((IEditManagerListener)this.selectedLayerListener)) {
            map.getEditManager().addListener((IEditManagerListener)this.selectedLayerListener);
        }
        for (ToolCategory toolCategory : categories) {
            for (ModalItem item : toolCategory) {
                OpFilter enablesFor = item.getEnablesFor();
                ILayer selectedLayer = map.getEditManager().getSelectedLayer();
                if (!(enablesFor instanceof LazyOpFilter)) {
                    enablesFor = new LazyOpFilter((ILazyOpListener)item, enablesFor);
                }
                boolean accept = enablesFor.accept((Object)selectedLayer);
                item.setEnabled(accept);
            }
        }
    }

    void setActiveTool(MapPart editor) {
        net.refractions.udig.project.internal.Map map = editor.getMap();
        Adapter listener = this.getCommandListener(editor);
        if (!map.eAdapters().contains((Object)listener)) {
            map.eAdapters().add((Object)listener);
        }
        ToolContextImpl tools = new ToolContextImpl();
        tools.setMapInternal(map);
        this.setContext(this.modalCategories, tools);
        this.setContext(this.actionCategories, tools);
        this.setContext(this.menuCategories, tools);
        for (ToolProxy tool : this.backgroundTools) {
            tool.setContext(tools);
        }
        for (IAction action : this.registeredToolActions) {
            action.setEnabled(true);
        }
        this.setCommandActions(map, editor);
        if (this.activeModalToolProxy != null) {
            if (!this.activeModalToolProxy.isActive()) {
                if (this.activeTool == null) {
                    this.activeTool = this.activeModalToolProxy.getModalTool();
                    this.initToolOptionsContribution(editor.getStatusLineManager(), this.activeModalToolProxy);
                }
                this.activeModalToolProxy.getModalTool().setActive(true);
            }
            editor.setSelectionProvider(this.activeModalToolProxy.getSelectionProvider());
            if (editor instanceof MapEditorWithPalette) {
                MapEditorWithPalette editor2 = (MapEditorWithPalette)editor;
                MapEditDomain editDomain = editor2.getEditDomain();
                editDomain.setActiveTool(this.activeModalToolProxy.getId());
            }
        }
    }

    private void setContext(List<? extends ToolCategory> categories, ToolContext tools) {
        for (ToolCategory toolCategory : categories) {
            for (ModalItem item : toolCategory.items) {
                ToolProxy tool = (ToolProxy)item;
                tool.setContext(tools);
            }
        }
    }

    @Override
    public void addToolAction(IAction action) {
        this.registeredToolActions.add(action);
        action.setEnabled(ApplicationGIS.getActiveMap() != ApplicationGIS.NO_MAP);
    }

    @Override
    public IAction createToolAction(final String toolID, final String categoryID) {
        Action toolAction = new Action(){

            public void runWithEvent(Event event) {
                IAction action = ToolManager.this.getTool(toolID, categoryID);
                if (action != null && action.isEnabled()) {
                    action.runWithEvent(event);
                }
            }
        };
        toolAction.addPropertyChangeListener(new IPropertyChangeListener((IAction)toolAction){
            private final /* synthetic */ IAction val$toolAction;
            {
                this.val$toolAction = iAction;
            }

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("enabled")) {
                    this.val$toolAction.setEnabled(((Boolean)event.getNewValue()).booleanValue());
                }
            }
        });
        toolAction.setEnabled(this.getTool(toolID, categoryID).isEnabled());
        this.addToolAction((IAction)toolAction);
        return toolAction;
    }

    @Override
    public ActionToolCategory findActionCategory(String id) {
        for (ActionToolCategory category : this.actionCategories) {
            if (!category.getId().equals(id)) continue;
            return category;
        }
        return null;
    }

    MenuToolCategory findMenuCategory(String id) {
        for (MenuToolCategory category : this.menuCategories) {
            if (!category.getId().equals(id)) continue;
            return category;
        }
        return null;
    }

    protected ModalToolCategory findModalCategory(String id) {
        for (ModalToolCategory category : this.modalCategories) {
            String id2 = category.getId();
            if (!id2.equals(id)) continue;
            return category;
        }
        return null;
    }

    @Override
    public void contributeToMenu(IMenuManager manager) {
        IMenuManager mapMenu;
        IMenuManager navigateMenu = manager.findMenuUsingPath("navigate");
        if (navigateMenu == null) {
            navigateMenu = new MenuManager(Messages.ToolManager_menu_manager_title, "navigate");
            IContributionItem additions = manager.find("additions");
            if (additions == null || !(additions instanceof GroupMarker)) {
                manager.add((IContributionItem)navigateMenu);
            } else {
                manager.appendToGroup("additions", (IContributionItem)navigateMenu);
            }
            navigateMenu.add((IContributionItem)new GroupMarker("navStart"));
            navigateMenu.add((IContributionItem)new GroupMarker("additions"));
            navigateMenu.add((IContributionItem)new GroupMarker("navEnd"));
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        navigateMenu.appendToGroup("navEnd", (IAction)ActionFactory.BACK.create(window));
        navigateMenu.appendToGroup("navEnd", (IAction)ActionFactory.FORWARD.create(window));
        if (!manager.isVisible()) {
            manager.setVisible(true);
        }
        if ((mapMenu = manager.findMenuUsingPath("map")) == null) {
            mapMenu = new MenuManager(Messages.ToolManager_menu_manager_title, "map");
            manager.add((IContributionItem)mapMenu);
            mapMenu.add((IContributionItem)new GroupMarker("mapStart"));
            mapMenu.add((IContributionItem)new GroupMarker("additions"));
            mapMenu.add((IContributionItem)new GroupMarker("mapEnd"));
        }
        for (MenuToolCategory category : this.menuCategories) {
            category.contribute(manager);
        }
    }

    @Override
    public void contributeActiveModalTool(IMenuManager manager) {
        Tool activeTool = this.getActiveTool();
        if (activeTool instanceof IContextMenuContributionTool) {
            IContextMenuContributionTool contributionTool = (IContextMenuContributionTool)((Object)activeTool);
            ArrayList<IContributionItem> contributions = new ArrayList<IContributionItem>();
            contributionTool.contributeContextMenu(contributions);
            if (!contributions.isEmpty()) {
                manager.add((IContributionItem)new Separator());
                for (IContributionItem item : contributions) {
                    manager.add(item);
                }
            }
        }
    }

    @Override
    public IAction getREDOAction() {
        net.refractions.udig.project.internal.Map activeMap = ApplicationGISInternal.getActiveMap();
        this.redoLock.lock();
        try {
            if (this.redoAction == null) {
                this.redoAction = new Action(){

                    public void run() {
                        net.refractions.udig.project.internal.Map activeMap = ApplicationGISInternal.getActiveMap();
                        if (activeMap != ApplicationGIS.NO_MAP) {
                            activeMap.redo();
                        }
                    }
                };
                this.redoAction.setImageDescriptor(this.sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
                this.redoAction.setText(Messages.ToolManager_redoAction);
                this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
            }
            if (activeMap != ApplicationGIS.NO_MAP) {
                this.redoAction.setEnabled(activeMap.getCommandStack().canRedo());
            } else {
                this.redoAction.setEnabled(false);
            }
            IAction iAction = this.redoAction;
            return iAction;
        }
        finally {
            this.redoLock.unlock();
        }
    }

    @Override
    public void setREDOAction(IAction action, IWorkbenchPart part) {
        if (action == null) {
            throw new NullPointerException("action must not be null");
        }
        if (part == null) {
            throw new NullPointerException("part must not be null");
        }
        this.redoLock.lock();
        try {
            this.redoAction = action;
            this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
            IKeyBindingService service = part.getSite().getKeyBindingService();
            service.registerAction(this.redoAction);
        }
        finally {
            this.redoLock.unlock();
        }
    }

    @Override
    public IAction getUNDOAction() {
        net.refractions.udig.project.internal.Map activeMap = ApplicationGISInternal.getActiveMap();
        this.undoLock.lock();
        try {
            if (this.undoAction == null) {
                this.undoAction = new Action(){

                    public void run() {
                        net.refractions.udig.project.internal.Map activeMap = ApplicationGISInternal.getActiveMap();
                        if (activeMap != ApplicationGIS.NO_MAP) {
                            activeMap.undo();
                        }
                    }
                };
                this.undoAction.setImageDescriptor(this.sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
                this.undoAction.setText(Messages.ToolManager_undoAction);
                this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
            }
            if (activeMap != ApplicationGIS.NO_MAP) {
                this.undoAction.setEnabled(activeMap.getCommandStack().canUndo());
            } else {
                this.undoAction.setEnabled(false);
            }
            IAction iAction = this.undoAction;
            return iAction;
        }
        finally {
            this.undoLock.unlock();
        }
    }

    @Override
    public void setUNDOAction(IAction action, IWorkbenchPart part) {
        if (action == null) {
            throw new NullPointerException("action must not be null");
        }
        if (part == null) {
            throw new NullPointerException("part must not be null");
        }
        this.undoLock.lock();
        try {
            this.undoAction = action;
            this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
            IKeyBindingService service = part.getSite().getKeyBindingService();
            service.registerAction(this.undoAction);
        }
        finally {
            this.undoLock.unlock();
        }
    }

    @Override
    public IAction getFORWARD_HISTORYAction() {
        net.refractions.udig.project.internal.Map activeMap = ApplicationGISInternal.getActiveMap();
        this.forwardLock.lock();
        try {
            if (this.forwardAction == null) {
                this.forwardAction = new Action(){

                    public void run() {
                        net.refractions.udig.project.internal.Map activeMap = ApplicationGISInternal.getActiveMap();
                        if (activeMap != ApplicationGIS.NO_MAP) {
                            activeMap.forwardHistory();
                        }
                    }
                };
                this.forwardAction.setImageDescriptor(this.sharedImages.getImageDescriptor("IMG_TOOL_FORWARD"));
                this.forwardAction.setText(Messages.ToolManager_forward);
                this.forwardAction.setToolTipText(Messages.ToolManager_forward_tooltip);
                this.forwardAction.setActionDefinitionId("org.eclipse.ui.navigate.forward");
            }
            if (activeMap != ApplicationGIS.NO_MAP) {
                this.forwardAction.setEnabled(activeMap.getCommandStack().canRedo());
            } else {
                this.forwardAction.setEnabled(false);
            }
            IAction iAction = this.forwardAction;
            return iAction;
        }
        finally {
            this.forwardLock.unlock();
        }
    }

    @Override
    public void setFORWARDAction(IAction action, IWorkbenchPart part) {
        if (action == null) {
            throw new NullPointerException("action must not be null");
        }
        if (part == null) {
            throw new NullPointerException("part must not be null");
        }
        this.forwardLock.lock();
        try {
            this.forwardAction = action;
            this.forwardAction.setActionDefinitionId("org.eclipse.ui.navigate.forward");
            IKeyBindingService service = part.getSite().getKeyBindingService();
            service.registerAction(this.forwardAction);
        }
        finally {
            this.forwardLock.unlock();
        }
    }

    @Override
    public void registerActionsWithPart(IWorkbenchPart part) {
        IKeyBindingService service = part.getSite().getKeyBindingService();
        service.registerAction(this.getBACKWARD_HISTORYAction());
        service.registerAction(this.getFORWARD_HISTORYAction());
        service.registerAction(this.getCOPYAction(part));
        service.registerAction(this.getCUTAction(part));
        service.registerAction(this.getDELETEAction());
        service.registerAction(this.getPASTEAction(part));
        service.registerAction(this.getREDOAction());
        service.registerAction(this.getUNDOAction());
        this.addToolScope(part.getSite());
    }

    @Override
    public void unregisterActions(IWorkbenchPart part) {
        IKeyBindingService service = part.getSite().getKeyBindingService();
        service.unregisterAction(this.getBACKWARD_HISTORYAction());
        service.unregisterAction(this.getFORWARD_HISTORYAction());
        service.unregisterAction(this.getCOPYAction(part));
        service.unregisterAction(this.getCUTAction(part));
        service.unregisterAction(this.getDELETEAction());
        service.unregisterAction(this.getPASTEAction(part));
        service.unregisterAction(this.getREDOAction());
        service.unregisterAction(this.getUNDOAction());
        service.setScopes(new String[0]);
    }

    @Override
    public IAction getBACKWARD_HISTORYAction() {
        net.refractions.udig.project.internal.Map activeMap = ApplicationGISInternal.getActiveMap();
        this.backwardLock.lock();
        try {
            if (this.backwardAction == null) {
                this.backwardAction = new Action(){

                    public void run() {
                        net.refractions.udig.project.internal.Map activeMap = ApplicationGISInternal.getActiveMap();
                        if (activeMap != ApplicationGIS.NO_MAP) {
                            activeMap.backwardHistory();
                        }
                    }
                };
                this.backwardAction.setImageDescriptor(this.sharedImages.getImageDescriptor("IMG_TOOL_BACK"));
                this.backwardAction.setText(Messages.ToolManager_back);
                this.backwardAction.setToolTipText(Messages.ToolManager_back_tooltip);
                this.backwardAction.setActionDefinitionId("org.eclipse.ui.navigate.back");
            }
            if (activeMap != ApplicationGIS.NO_MAP) {
                this.backwardAction.setEnabled(activeMap.getCommandStack().canUndo());
            } else {
                this.backwardAction.setEnabled(false);
            }
        }
        finally {
            this.backwardLock.unlock();
        }
        return this.backwardAction;
    }

    @Override
    public void setBACKAction(IAction action, IWorkbenchPart part) {
        if (action == null) {
            throw new NullPointerException("action must not be null");
        }
        if (part == null) {
            throw new NullPointerException("part must not be null");
        }
        this.backwardLock.lock();
        try {
            this.backwardAction = action;
            this.backwardAction.setActionDefinitionId("org.eclipse.ui.navigate.back");
            IKeyBindingService service = part.getSite().getKeyBindingService();
            service.registerAction(this.backwardAction);
        }
        finally {
            this.backwardLock.unlock();
        }
    }

    @Override
    public IAction getCUTAction(IWorkbenchPart part) {
        this.cutLock.lock();
        try {
            if (this.cutAction == null) {
                this.cutAction = new Action(){};
            }
            IAction iAction = this.cutAction;
            return iAction;
        }
        finally {
            this.cutLock.unlock();
        }
    }

    @Override
    public void setCUTAction(IAction action, IWorkbenchPart part) {
        if (action == null) {
            throw new NullPointerException("action must not be null");
        }
        if (part == null) {
            throw new NullPointerException("part must not be null");
        }
        this.cutLock.lock();
        try {
            this.cutAction = action;
            this.cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
            IKeyBindingService service = part.getSite().getKeyBindingService();
            service.registerAction(this.cutAction);
        }
        finally {
            this.cutLock.unlock();
        }
    }

    @Override
    public IAction getCOPYAction(IWorkbenchPart part) {
        this.copyLock.lock();
        try {
            if (this.copyAction == null) {
                this.copyAction = new CopyAction();
                ActionFactory.IWorkbenchAction template = ActionFactory.COPY.create(part.getSite().getWorkbenchWindow());
                this.copyAction.setText(template.getText());
                this.copyAction.setToolTipText(template.getToolTipText());
                this.copyAction.setImageDescriptor(template.getImageDescriptor());
                this.copyAction.setId(template.getId());
                this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
            }
            if (this.copyAction instanceof CopyAction) {
                ((CopyAction)this.copyAction).setPart(part);
            }
            IKeyBindingService service = part.getSite().getKeyBindingService();
            service.registerAction(this.copyAction);
            IAction iAction = this.copyAction;
            return iAction;
        }
        finally {
            this.copyLock.unlock();
        }
    }

    @Override
    public void setCOPYAction(IAction action, IWorkbenchPart part) {
        if (action == null) {
            throw new NullPointerException("action must not be null");
        }
        if (part == null) {
            throw new NullPointerException("part must not be null");
        }
        this.copyLock.lock();
        try {
            this.copyAction = action;
            this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
            IKeyBindingService service = part.getSite().getKeyBindingService();
            service.registerAction(this.copyAction);
        }
        finally {
            this.copyLock.unlock();
        }
    }

    public IAction getPropertiesAction(IWorkbenchPart part, ISelectionProvider selectionProvider) {
        this.propertiesLock.lock();
        try {
            if (this.propertiesAction == null || this.propertiesAction.getSelectionProvider() != selectionProvider) {
                this.propertiesAction = new PropertyDialogAction((IShellProvider)part.getSite().getWorkbenchWindow(), selectionProvider);
            }
            IKeyBindingService service = part.getSite().getKeyBindingService();
            service.registerAction((IAction)this.propertiesAction);
            PropertyDialogAction propertyDialogAction = this.propertiesAction;
            return propertyDialogAction;
        }
        finally {
            this.propertiesLock.unlock();
        }
    }

    @Override
    public IAction getPASTEAction(IWorkbenchPart part) {
        this.pasteLock.lock();
        try {
            if (this.pasteAction == null) {
                this.pasteAction = new PasteAction();
                ActionFactory.IWorkbenchAction template = ActionFactory.PASTE.create(part.getSite().getWorkbenchWindow());
                this.pasteAction.setText(template.getText());
                this.pasteAction.setToolTipText(template.getToolTipText());
                this.pasteAction.setImageDescriptor(template.getImageDescriptor());
                this.pasteAction.setId(template.getId());
                this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
            }
            if (this.pasteAction instanceof PasteAction) {
                ((PasteAction)this.pasteAction).setPart(part);
            }
            IKeyBindingService service = part.getSite().getKeyBindingService();
            service.registerAction(this.pasteAction);
            IAction iAction = this.pasteAction;
            return iAction;
        }
        finally {
            this.pasteLock.unlock();
        }
    }

    @Override
    public void setPASTEAction(IAction action, IWorkbenchPart part) {
        if (action == null) {
            throw new NullPointerException("action must not be null");
        }
        if (part == null) {
            throw new NullPointerException("part must not be null");
        }
        this.pasteLock.lock();
        try {
            this.pasteAction = action;
            this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
            IKeyBindingService service = part.getSite().getKeyBindingService();
            service.registerAction(this.pasteAction);
        }
        finally {
            this.pasteLock.unlock();
        }
    }

    @Override
    public synchronized IAction getDELETEAction() {
        this.deleteLock.lock();
        try {
            if (this.deleteAction == null) {
                this.deleteAction = new Action(){

                    public void run() {
                        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        ISelectionService selectionService = workbenchWindow.getSelectionService();
                        ISelection selection = selectionService.getSelection();
                        Delete delete = new Delete(false);
                        delete.selectionChanged((IAction)this, selection);
                        delete.run((IAction)this);
                    }
                };
                this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
                ActionFactory.IWorkbenchAction actionTemplate = ActionFactory.DELETE.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                this.deleteAction.setText(actionTemplate.getText());
                this.deleteAction.setToolTipText(actionTemplate.getToolTipText());
                this.deleteAction.setImageDescriptor(actionTemplate.getImageDescriptor());
                this.deleteAction.setDescription(actionTemplate.getDescription());
                this.deleteAction.setDisabledImageDescriptor(actionTemplate.getDisabledImageDescriptor());
            }
            IAction iAction = this.deleteAction;
            return iAction;
        }
        finally {
            this.deleteLock.unlock();
        }
    }

    @Override
    public synchronized void setDELETEAction(IAction action, IWorkbenchPart part) {
        if (action == null) {
            throw new NullPointerException("action must not be null");
        }
        if (part == null) {
            throw new NullPointerException("part must not be null");
        }
        this.deleteLock.lock();
        try {
            this.deleteAction = action;
            this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
            IKeyBindingService service = part.getSite().getKeyBindingService();
            service.registerAction(this.deleteAction);
        }
        finally {
            this.deleteLock.unlock();
        }
    }

    @Override
    public synchronized IAction getENTERAction() {
        this.enterLock.lock();
        try {
            if (this.enterAction == null) {
                this.enterAction = new Action(){

                    public void run() {
                        try {
                            Robot r = new Robot();
                            r.keyPress(10);
                            r.keyRelease(10);
                        }
                        catch (AWTException e) {
                            e.printStackTrace();
                        }
                    }
                };
                this.enterAction.setText(Messages.ToolManager_enterAction);
                this.enterAction.setToolTipText(Messages.ToolManager_enterActionTooltip);
                this.enterAction.setDescription(Messages.ToolManager_enterActionTooltip);
            }
            IAction iAction = this.enterAction;
            return iAction;
        }
        finally {
            this.enterLock.unlock();
        }
    }

    @Override
    public synchronized IAction getZOOMTOSELECTEDAction() {
        this.enterLock.lock();
        try {
            if (this.zoomToSelectionAction == null) {
                this.zoomToSelectionAction = this.getToolAction("net.refractions.udig.tool.default.show.selection", "net.refractions.udig.tool.category.zoom");
            }
            IAction iAction = this.zoomToSelectionAction;
            return iAction;
        }
        finally {
            this.enterLock.unlock();
        }
    }

    private void createModalToolToolbar(SubCoolBarManager cbmanager) {
        ToolBarManager manager = new ToolBarManager(0x800000);
        for (String id : this.categoryIds) {
            ModalToolCategory modalCategory = this.findModalCategory(id);
            if (modalCategory == null) continue;
            modalCategory.contribute((IToolBarManager)manager);
        }
        if (manager != null && manager.getItems().length > 0) {
            cbmanager.add((IToolBarManager)manager);
        }
    }

    private void createActionToolToolbar(SubCoolBarManager cbmanager) {
        ToolBarManager manager = new ToolBarManager(0x800000);
        manager.add(this.getBACKWARD_HISTORYAction());
        manager.add(this.getFORWARD_HISTORYAction());
        for (String id : this.categoryIds) {
            ActionToolCategory category = this.findActionCategory(id);
            if (category == null) continue;
            category.contribute((IToolBarManager)manager);
        }
        if (manager != null && manager.getItems().length > 0) {
            cbmanager.add((IToolBarManager)manager);
        }
    }

    @Override
    public void contributeToCoolBar(SubCoolBarManager cbmanager, IActionBars bars) {
        cbmanager.setVisible(true);
        this.createActionToolToolbar(cbmanager);
        this.createModalToolToolbar(cbmanager);
    }

    @Override
    public void contributeActionTools(IToolBarManager toolBarManager, IActionBars bars) {
        toolBarManager.add(this.getBACKWARD_HISTORYAction());
        toolBarManager.add(this.getFORWARD_HISTORYAction());
        for (String id : this.categoryIds) {
            ActionToolCategory category = this.findActionCategory(id);
            if (category == null) continue;
            category.contribute(toolBarManager);
        }
    }

    @Override
    public void contributeModalTools(IToolBarManager toolBarManager, IActionBars bars) {
        for (String id : this.categoryIds) {
            ModalToolCategory modalCategory = this.findModalCategory(id);
            if (modalCategory == null) continue;
            modalCategory.contribute(toolBarManager);
        }
    }

    SubActionBars2 getActionBars() {
        if (ApplicationGISInternal.getActiveMap() == ApplicationGIS.NO_MAP) {
            return null;
        }
        MapEditorPart active = ApplicationGISInternal.getActiveEditor();
        if (active instanceof MapEditorPart) {
            MapEditorPart editor = active;
            return (SubActionBars2)editor.getMapEditorSite().getActionBars();
        }
        if (active instanceof ViewPart) {
            ViewPart view = (ViewPart)active;
            return (SubActionBars2)view.getViewSite().getActionBars();
        }
        return null;
    }

    @Override
    public void contributeGlobalActions(IWorkbenchPart part, IActionBars bars) {
        IKeyBindingService service = part.getSite().getKeyBindingService();
        bars.setGlobalActionHandler(ActionFactory.BACK.getId(), this.getBACKWARD_HISTORYAction());
        bars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), this.getFORWARD_HISTORYAction());
        bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getUNDOAction());
        bars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getREDOAction());
        bars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.getCUTAction(part));
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.getCOPYAction(part));
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getPASTEAction(part));
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getDELETEAction());
        ISelectionProvider selection = part.getSite().getSelectionProvider();
        if (selection != null) {
            bars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), this.getPropertiesAction(part, selection));
        }
        if (this.actionCLOSE == null) {
            this.actionCLOSE = ActionFactory.CLOSE.create(part.getSite().getWorkbenchWindow());
        }
        service.registerAction(this.actionCLOSE);
        bars.setGlobalActionHandler(ActionFactory.CLOSE.getId(), this.actionCLOSE);
        if (this.actionSAVE == null) {
            this.actionSAVE = ActionFactory.SAVE.create(part.getSite().getWorkbenchWindow());
        }
        service.registerAction(this.actionSAVE);
        bars.setGlobalActionHandler(ActionFactory.SAVE.getId(), this.actionSAVE);
        if (this.actionCLOSE_ALL == null) {
            this.actionCLOSE_ALL = ActionFactory.CLOSE_ALL.create(part.getSite().getWorkbenchWindow());
        }
        bars.setGlobalActionHandler(ActionFactory.CLOSE_ALL.getId(), this.actionCLOSE_ALL);
    }

    void dispose() {
        for (ToolCategory toolCategory : this.modalCategories) {
            toolCategory.dispose(ApplicationGISInternal.getActiveEditor().getMapEditorSite().getActionBars());
        }
        for (ToolCategory toolCategory : this.actionCategories) {
            toolCategory.dispose(ApplicationGISInternal.getActiveEditor().getMapEditorSite().getActionBars());
        }
        for (ToolCategory toolCategory : this.menuCategories) {
            toolCategory.dispose(ApplicationGISInternal.getActiveEditor().getMapEditorSite().getActionBars());
        }
        for (ToolProxy toolProxy : this.backgroundTools) {
            toolProxy.dispose();
        }
    }

    Adapter getCommandListener(final MapPart editor) {
        if (this.commandListener == null) {
            this.commandListener = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    net.refractions.udig.project.internal.Map map = null;
                    switch (msg.getFeatureID(msg.getNotifier().getClass())) {
                        case 5: {
                            map = (net.refractions.udig.project.internal.Map)msg.getNotifier();
                            ToolManager.this.setCommandActions(map, editor);
                            break;
                        }
                        case 4: {
                            map = (net.refractions.udig.project.internal.Map)msg.getNotifier();
                            ToolManager.this.setCommandActions(map, editor);
                        }
                    }
                }
            };
        }
        return this.commandListener;
    }

    void setCommandActions(net.refractions.udig.project.internal.Map map, MapPart editor) {
        if (map.getCommandStack().canRedo()) {
            this.getREDOAction().setEnabled(true);
        } else {
            this.getREDOAction().setEnabled(false);
        }
        if (map.getCommandStack().canUndo()) {
            this.getUNDOAction().setEnabled(true);
        } else {
            this.getUNDOAction().setEnabled(false);
        }
        if (map.getNavCommandStack().hasBackHistory()) {
            this.getBACKWARD_HISTORYAction().setEnabled(true);
        } else {
            this.getBACKWARD_HISTORYAction().setEnabled(false);
        }
        if (map.getNavCommandStack().hasForwardHistory()) {
            this.getFORWARD_HISTORYAction().setEnabled(true);
        } else {
            this.getFORWARD_HISTORYAction().setEnabled(false);
        }
    }

    @Override
    public IAction getTool(String toolID, String categoryID) {
        return this.getToolAction(toolID, categoryID);
    }

    @Override
    public IAction getToolAction(String toolID, String categoryID) {
        IAction tool = this.getToolInteral(toolID, categoryID);
        if (tool == null) {
            return null;
        }
        return new IAction(tool){
            IAction wrapped;
            {
                this.wrapped = iAction;
            }

            public void addPropertyChangeListener(IPropertyChangeListener listener) {
                this.wrapped.addPropertyChangeListener(listener);
            }

            public int getAccelerator() {
                return this.wrapped.getAccelerator();
            }

            public String getActionDefinitionId() {
                return this.wrapped.getActionDefinitionId();
            }

            public String getDescription() {
                return this.wrapped.getDescription();
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return this.wrapped.getDisabledImageDescriptor();
            }

            public HelpListener getHelpListener() {
                return this.wrapped.getHelpListener();
            }

            public ImageDescriptor getHoverImageDescriptor() {
                return this.wrapped.getHoverImageDescriptor();
            }

            public String getId() {
                return this.wrapped.getId();
            }

            public ImageDescriptor getImageDescriptor() {
                return this.wrapped.getImageDescriptor();
            }

            public IMenuCreator getMenuCreator() {
                return this.wrapped.getMenuCreator();
            }

            public int getStyle() {
                return this.wrapped.getStyle();
            }

            public String getText() {
                return this.wrapped.getText();
            }

            public String getToolTipText() {
                return this.wrapped.getToolTipText();
            }

            public boolean isChecked() {
                return this.wrapped.isChecked();
            }

            public boolean isEnabled() {
                return this.wrapped.isEnabled();
            }

            public boolean isHandled() {
                return this.wrapped.isHandled();
            }

            public void removePropertyChangeListener(IPropertyChangeListener listener) {
                this.wrapped.removePropertyChangeListener(listener);
            }

            public void runWithEvent(Event event) {
                this.wrapped.runWithEvent(event);
            }

            public void run() {
                this.wrapped.run();
            }

            public void setAccelerator(int keycode) {
                throw new UnsupportedOperationException("This is an unmodifiable action");
            }

            public void setActionDefinitionId(String id) {
                throw new UnsupportedOperationException("This is an unmodifiable action");
            }

            public void setChecked(boolean checked) {
                throw new UnsupportedOperationException("This is an unmodifiable action");
            }

            public void setDescription(String text) {
                throw new UnsupportedOperationException("This is an unmodifiable action");
            }

            public void setDisabledImageDescriptor(ImageDescriptor newImage) {
                throw new UnsupportedOperationException("This is an unmodifiable action");
            }

            public void setEnabled(boolean enabled) {
                throw new UnsupportedOperationException("This is an unmodifiable action");
            }

            public void setHelpListener(HelpListener listener) {
                throw new UnsupportedOperationException("This is an unmodifiable action");
            }

            public void setHoverImageDescriptor(ImageDescriptor newImage) {
                throw new UnsupportedOperationException("This is an unmodifiable action");
            }

            public void setId(String id) {
                throw new UnsupportedOperationException("This is an unmodifiable action");
            }

            public void setImageDescriptor(ImageDescriptor newImage) {
                throw new UnsupportedOperationException("This is an unmodifiable action");
            }

            public void setMenuCreator(IMenuCreator creator) {
                throw new UnsupportedOperationException("This is an unmodifiable action");
            }

            public void setText(String text) {
                throw new UnsupportedOperationException("This is an unmodifiable action");
            }

            public void setToolTipText(String text) {
                throw new UnsupportedOperationException("This is an unmodifiable action");
            }
        };
    }

    private IAction getToolInteral(String toolID, String categoryID) {
        IAction tool;
        ToolCategory category = this.findModalCategory(categoryID);
        if (category != null && (tool = this.searchCategoryForTool(toolID, category)) != null) {
            return tool;
        }
        category = this.findActionCategory(categoryID);
        if (category != null && (tool = this.searchCategoryForTool(toolID, category)) != null) {
            return tool;
        }
        category = this.findMenuCategory(categoryID);
        if (category != null && (tool = this.searchCategoryForTool(toolID, category)) != null) {
            return tool;
        }
        return null;
    }

    private IAction searchCategoryForTool(String toolID, ToolCategory category) {
        for (ToolProxy tool : category) {
            String id = tool.getId();
            if (!id.equals(toolID)) continue;
            return tool.getAction();
        }
        return null;
    }

    @Override
    public List<ModalToolCategory> getModalToolCategories() {
        return this.modalCategories;
    }

    @Override
    public ToolCategory getActiveCategory() {
        return this.findModalCategory(this.activeModalToolProxy.getCategoryId());
    }

    public void addToolScope(IWorkbenchPartSite site) {
        String[] scopes = site.getKeyBindingService().getScopes();
        String[] newScopes = new String[scopes.length + 1];
        System.arraycopy(scopes, 0, newScopes, 1, scopes.length);
        newScopes[0] = "net.refractions.udig.project.ui.tool";
        site.getKeyBindingService().setScopes(newScopes);
    }

    @Override
    public MenuManager createOperationsContextMenu(ISelection selection) {
        try {
            OperationCategory category;
            MenuManager contextManager = this.getOperationMenuFactory().createMenuManager();
            List<OperationCategory> primaryCategories = this.activeModalToolProxy.getOperationCategories();
            Collection secondaryCategories = this.getOperationMenuFactory().getCategories().values();
            int i = 0;
            while (i < primaryCategories.size()) {
                category = primaryCategories.get(i);
                if (contextManager.getItems().length >= 15 && category.getActions().size() > 5) break;
                MenuManager menu = category.createContextMenu();
                if (i != 0 && menu.getItems().length != 0 && (secondaryCategories.size() != 0 || this.getOperationMenuFactory().getActions().size() != 0)) {
                    contextManager.add((IContributionItem)new Separator());
                }
                IContributionItem[] iContributionItemArray = menu.getItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    contextManager.add(item);
                    ++n2;
                }
                ++i;
            }
            if (contextManager.getItems().length != 0) {
                RunOperationsAction action = new RunOperationsAction();
                action.setText(Messages.ToolCategory_other);
                contextManager.add((IContributionItem)new Separator());
                contextManager.add((IAction)action);
            } else {
                Iterator iter = secondaryCategories.iterator();
                while (iter.hasNext()) {
                    category = (OperationCategory)iter.next();
                    for (OpAction action : category.getActions()) {
                        if (selection instanceof IStructuredSelection) {
                            action.updateEnablement((IStructuredSelection)selection, true);
                        }
                        if (!action.isEnabled()) continue;
                        contextManager.add((IAction)action);
                    }
                    if (!iter.hasNext()) continue;
                    contextManager.add((IContributionItem)new Separator());
                }
                if (this.getOperationMenuFactory().getActions().size() != 0) {
                    contextManager.add((IContributionItem)new Separator());
                }
                for (OpAction action : this.getOperationMenuFactory().getActions()) {
                    if (selection instanceof IStructuredSelection) {
                        action.updateEnablement((IStructuredSelection)selection, true);
                    }
                    if (!action.isEnabled()) continue;
                    contextManager.add((IAction)action);
                }
            }
            return contextManager;
        }
        catch (Throwable e) {
            ProjectUIPlugin.log("error creating the Operations ContextMenu", e);
            return new MenuManager();
        }
    }

    private OperationMenuFactory getOperationMenuFactory() {
        return UiPlugin.getDefault().getOperationMenuFactory();
    }

    @Override
    public Tool getActiveTool() {
        return this.activeModalToolProxy.getTool();
    }

    public ToolProxy getActiveToolProxy() {
        return this.activeModalToolProxy;
    }

    public void setActiveModalToolProxy(ToolProxy modalToolProxy) {
        if (modalToolProxy == null) {
            modalToolProxy = this.defaultModalToolProxy;
        }
        if (this.activeModalToolProxy != null && this.activeModalToolProxy.getId() == modalToolProxy.getId()) {
            return;
        }
        this.activeModalToolProxy = modalToolProxy;
        this.setActiveModalTool(modalToolProxy.getModalTool());
        this.currentEditor.setSelectionProvider(modalToolProxy.getSelectionProvider());
        this.initToolOptionsContribution(this.currentEditor.getStatusLineManager(), this.getActiveToolProxy());
    }

    private void initToolOptionsContribution(IStatusLineManager statusLine, ToolProxy modalToolProxy) {
        if (statusLine != null) {
            if (this.preferencesShortcutToolOptions == null || this.preferencesShortcutToolOptions.isDisposed()) {
                this.preferencesShortcutToolOptions = new PreferencesShortcutToolOptionsContributionItem();
                statusLine.appendToGroup("BEGIN_GROUP", (IContributionItem)this.preferencesShortcutToolOptions);
                this.preferencesShortcutToolOptions.setVisible(true);
            }
            this.preferencesShortcutToolOptions.update(modalToolProxy);
            for (ContributionItem contribution : this.optionsContribution) {
                statusLine.remove(contribution.getId());
            }
            this.optionsContribution = modalToolProxy.getOptionsContribution();
            for (ContributionItem contribution : this.optionsContribution) {
                statusLine.appendToGroup("BEGIN_GROUP", (IContributionItem)contribution);
                contribution.setVisible(true);
            }
            statusLine.update(true);
        }
    }

    private void setActiveModalTool(ModalTool modalTool) {
        if (modalTool == null) {
            modalTool = this.defaultModalToolProxy.getModalTool();
        }
        if (this.activeTool == modalTool) {
            return;
        }
        if (this.activeTool != null) {
            this.activeTool.setActive(false);
            this.activeTool = null;
        }
        if (modalTool.getContext() == null) {
            return;
        }
        try {
            this.activeTool = modalTool;
            this.activeTool.setActive(true);
            String currentCursorID = this.activeTool.getCursorID();
            Cursor toolCursor = this.findToolCursor(currentCursorID);
            this.activeTool.getContext().getViewportPane().setCursor(toolCursor);
        }
        catch (Throwable eek) {
            System.err.println("Trouble activating " + modalTool + ":" + eek);
            try {
                this.activeTool.setActive(false);
            }
            catch (Throwable throwable) {}
            this.activeTool = this.defaultModalToolProxy.getModalTool();
            this.activeTool.setActive(true);
        }
    }

    public List<ActionToolCategory> getActiveToolCategories() {
        return this.actionCategories;
    }

    private static class CategorySorter
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Map<String, Integer> values = new HashMap<String, Integer>();
        private static final int max = -1;
        private static final int min = 1;

        static {
            values.put("net.refractions.udig.tool.category.render", 5);
            values.put("net.refractions.udig.tool.category.zoom", 4);
            values.put("net.refractions.udig.tool.category.pan", 3);
            values.put("net.refractions.udig.tool.category.selection", 2);
            values.put("net.refractions.udig.tool.category.info", 1);
            values.put("net.refractions.udig.tool.category.edit", 0);
        }

        private CategorySorter() {
        }

        @Override
        public int compare(String arg0, String arg1) {
            Integer value0 = values.get(arg0);
            Integer value1 = values.get(arg1);
            if (value0 == null && value1 == null) {
                return 0;
            }
            if (value1 == null) {
                return -1;
            }
            if (value0 == null) {
                return 1;
            }
            if (value0.equals(value1)) {
                return 0;
            }
            return value0 > value1 ? -1 : 1;
        }
    }

    static class CopyAction
    extends Action {
        final Set<Transfer> transfers = UDIGDragDropUtilities.getTransfers();
        IWorkbenchPart part;

        CopyAction() {
        }

        public IWorkbenchPart getPart() {
            return this.part;
        }

        public void setPart(IWorkbenchPart part) {
            this.part = part;
        }

        public void runWithEvent(Event event) {
            Clipboard clipBoard = new Clipboard(event.display);
            try {
                AdaptingFilter adapting;
                IMap map = ApplicationGIS.getActiveMap();
                if (map == ApplicationGIS.NO_MAP) {
                    return;
                }
                ILayer selectedLayer = map.getEditManager().getSelectedLayer();
                if (selectedLayer == null) {
                    return;
                }
                Filter layerFilter = selectedLayer.getFilter();
                if (layerFilter == Filter.INCLUDE || layerFilter == org.geotools.filter.Filter.ALL) {
                    return;
                }
                AdaptingFilter filter = null;
                if (layerFilter instanceof AdaptingFilter && (adapting = (AdaptingFilter)layerFilter).getAdapter(ILayer.class) != null) {
                    filter = adapting;
                }
                if (filter == null) {
                    filter = AdaptingFilterFactory.createAdaptingFilter((Filter)layerFilter, (Object)selectedLayer);
                }
                clipBoard.setContents(new Object[]{filter}, new Transfer[]{UDigByteAndLocalTransfer.getInstance()});
            }
            finally {
                clipBoard.dispose();
            }
        }
    }

    class EditManagerListener
    implements IEditManagerListener {
        EditManagerListener() {
        }

        public void setCurrentMap(IMap map) {
        }

        public void changed(EditManagerEvent event) {
            if (ToolManager.this.selectedLayerListener != this) {
                event.getSource().removeListener((IEditManagerListener)this);
                return;
            }
            if (event.getType() == 5) {
                ToolManager.this.setEnabled(event.getSource().getMap(), ToolManager.this.actionCategories);
                ToolManager.this.setEnabled(event.getSource().getMap(), ToolManager.this.menuCategories);
                ToolManager.this.setEnabled(event.getSource().getMap(), ToolManager.this.modalCategories);
            }
        }
    }

    static class PasteAction
    extends Action {
        IWorkbenchPart part;

        PasteAction() {
        }

        public IWorkbenchPart getPart() {
            return this.part;
        }

        public void setPart(IWorkbenchPart part) {
            this.part = part;
        }

        public void run() {
            Clipboard clipboard = new Clipboard(this.part.getSite().getShell().getDisplay());
            Set transfers = UDIGDNDProcessor.getTransfers();
            Object contents = null;
            for (Transfer transfer : transfers) {
                contents = clipboard.getContents(transfer);
                if (contents != null) break;
            }
            Object selection = this.firstSelectedElement();
            if (contents != null) {
                UDIGDropHandler finalDropHandler;
                net.refractions.udig.project.internal.Map finalMap;
                MapEditorPart activeEditor = ApplicationGISInternal.getActiveEditor();
                if (selection instanceof net.refractions.udig.project.internal.Map) {
                    finalMap = (net.refractions.udig.project.internal.Map)selection;
                    finalDropHandler = new UDIGDropHandler();
                    activeEditor = null;
                } else if (activeEditor == null) {
                    CreateMapCommand command = new CreateMapCommand(null, Collections.emptyList(), null);
                    try {
                        command.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        throw (RuntimeException)new RuntimeException().initCause(e);
                    }
                    finalMap = (net.refractions.udig.project.internal.Map)command.getCreatedMap();
                    finalDropHandler = new UDIGDropHandler();
                } else {
                    finalDropHandler = activeEditor.getDropHandler();
                    finalMap = activeEditor.getMap();
                }
                final MapEditorPart finalActiveEditor = activeEditor;
                ILayer selectedLayer = finalMap.getEditManager().getSelectedLayer();
                if (selectedLayer == null) {
                    finalDropHandler.setTarget((Object)finalMap);
                } else {
                    finalDropHandler.setTarget((Object)selectedLayer);
                }
                finalDropHandler.addListener(new IDropHandlerListener(){

                    public void done(IDropAction action, Throwable error) {
                        if (finalActiveEditor == null && finalMap.getMapLayers().size() == 0) {
                            finalMap.getProjectInternal().getElementsInternal().remove(finalMap);
                        }
                        finalDropHandler.removeListener((IDropHandlerListener)this);
                    }

                    public void noAction(Object data) {
                        if (finalActiveEditor == null && finalMap.getMapLayers().size() == 0) {
                            finalMap.getProjectInternal().getElementsInternal().remove(finalMap);
                        }
                        finalDropHandler.removeListener((IDropHandlerListener)this);
                    }

                    public void starting(IDropAction action) {
                    }
                });
                finalDropHandler.setViewerLocation(ViewerDropLocation.ON);
                finalDropHandler.performDrop(contents, null);
            }
        }

        private Object firstSelectedElement() {
            ISelection selection = this.part.getSite().getSelectionProvider().getSelection();
            if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                return null;
            }
            return ((IStructuredSelection)selection).getFirstElement();
        }
    }
}

