/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.tool.display;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.tool.display.CurrentContributionItem;
import net.refractions.udig.project.ui.internal.tool.display.ModalItem;
import net.refractions.udig.project.ui.tool.IToolManager;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class ToolCategory
implements Iterable<ModalItem> {
    public List<ModalItem> items = new LinkedList<ModalItem>();
    protected IToolManager manager;
    protected String id;
    protected String name;
    private String commandId;
    private ImageDescriptor icon;
    private boolean handlersSet = false;
    protected IConfigurationElement element;

    protected ToolCategory(IConfigurationElement element, IToolManager manager) {
        this.id = element.getAttribute("id");
        this.commandId = element.getAttribute("commandId");
        this.name = element.getAttribute("name");
        String iconPath = element.getAttribute("icon");
        if (iconPath != null) {
            this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getNamespace(), (String)iconPath);
        }
        this.element = element;
        this.manager = manager;
    }

    public ToolCategory(IToolManager manager) {
        this.manager = manager;
        this.id = Messages.ToolCategory_other;
        this.name = Messages.ToolCategory_other_menu;
        this.icon = null;
        this.commandId = null;
    }

    public void dispose(IActionBars bars) {
        for (ModalItem item : this.items) {
            List<CurrentContributionItem> contributions = item.getContributions();
            for (CurrentContributionItem item2 : contributions) {
                bars.getMenuManager().remove((IContributionItem)item2);
                bars.getToolBarManager().remove((IContributionItem)item2);
                bars.getStatusLineManager().remove((IContributionItem)item2);
            }
            item.clearContributions();
        }
    }

    public void add(ModalItem item) {
        this.items.add(item);
    }

    @Override
    public Iterator<ModalItem> iterator() {
        return this.items.iterator();
    }

    public void setCommandHandlers(ICommandService service) {
        if (!this.handlersSet) {
            Command command;
            if (this.commandId != null && (command = service.getCommand(this.commandId)) != null && this.getHandler() != null) {
                command.setHandler(this.getHandler());
            }
            this.handlersSet = true;
        }
    }

    protected abstract IHandler getHandler();

    public ImageDescriptor getIcon() {
        return this.icon;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

