/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.tool.display;

import java.util.Collection;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.tool.display.CurrentContributionItem;
import net.refractions.udig.project.ui.internal.tool.display.ModalItem;
import net.refractions.udig.project.ui.internal.tool.display.ToolCategory;
import net.refractions.udig.project.ui.internal.tool.display.ToolManager;
import net.refractions.udig.project.ui.internal.tool.display.ToolProxy;
import net.refractions.udig.project.ui.tool.IToolManager;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;

public class MenuToolCategory
extends ToolCategory {
    public MenuToolCategory(IConfigurationElement element, IToolManager manager) {
        super(element, manager);
    }

    public MenuToolCategory(IToolManager manager) {
        super(manager);
    }

    public void contribute(IMenuManager manager) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IContextService contextService = (IContextService)workbench.getService(IContextService.class);
        Collection active = contextService.getActiveContextIds();
        MenuManager actionMenu = new MenuManager(this.name, this.id);
        actionMenu.add((IContributionItem)new GroupMarker("action.ext"));
        actionMenu.add((IContributionItem)new GroupMarker("modal.ext"));
        for (ModalItem item : this) {
            ToolProxy tool = (ToolProxy)item;
            String categoryId = tool.getCategoryId();
            if (contextService.getDefinedContextIds().contains(categoryId) && !active.contains(categoryId)) continue;
            if (tool.getType() == 3) {
                String menuPath = tool.getMenuPath();
                IAction action = tool.getAction();
                if (menuPath != null) {
                    IMenuManager targetMenu;
                    String root = menuPath.substring(0, menuPath.lastIndexOf("/"));
                    String groupName = menuPath.substring(menuPath.lastIndexOf("/") + 1, menuPath.length());
                    if (groupName.equals("tools")) {
                        groupName = "map";
                    }
                    if ((targetMenu = manager.findMenuUsingPath(root)) != null) {
                        IContributionItem find = targetMenu.find(groupName);
                        if (find != null && find instanceof GroupMarker) {
                            targetMenu.appendToGroup(groupName, tool.getAction());
                            targetMenu.setVisible(true);
                        } else {
                            targetMenu.add(action);
                            targetMenu.setVisible(true);
                        }
                    } else {
                        actionMenu.appendToGroup("action.ext", tool.getAction());
                    }
                } else {
                    actionMenu.appendToGroup("action.ext", tool.getAction());
                }
            }
            if (tool.getType() != 1) continue;
            MenuCurrentToolItem menuItem = new MenuCurrentToolItem(tool);
            tool.addContribution(menuItem);
            actionMenu.appendToGroup("modal.ext", (IContributionItem)menuItem);
        }
        if (actionMenu.getItems().length > 0) {
            String menuPath = "map";
            IMenuManager toolManager = manager.findMenuUsingPath(menuPath);
            if (toolManager == null) {
                toolManager = new MenuManager(Messages.MenuToolCategory_menu_manager_title, "tools");
                manager.add((IContributionItem)toolManager);
                toolManager.add((IContributionItem)new GroupMarker("action.ext"));
                toolManager.add((IContributionItem)new GroupMarker("modal.ext"));
            }
            if (toolManager.find("action.ext") == null) {
                toolManager.add((IContributionItem)new GroupMarker("action.ext"));
            }
            toolManager.appendToGroup("action.ext", (IContributionItem)actionMenu);
            toolManager.setVisible(true);
        }
    }

    @Override
    protected IHandler getHandler() {
        return null;
    }

    protected class MenuCurrentToolItem
    extends CurrentContributionItem {
        ToolProxy tool;
        MenuItem menuItem;

        public MenuCurrentToolItem(ToolProxy proxy) {
            this.tool = proxy;
        }

        public void fill(Menu parent, int index) {
            if (MenuToolCategory.this.items.size() == 0) {
                return;
            }
            this.menuItem = new MenuItem(parent, 16, index);
            this.menuItem.setText(this.tool.getName());
            this.menuItem.setImage(this.tool.getImage());
            if (MenuToolCategory.this.items.contains(((ToolManager)MenuToolCategory.this.manager).defaultModalToolProxy)) {
                this.menuItem.setSelection(true);
            }
            this.menuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    MenuCurrentToolItem.this.tool.run();
                }
            });
        }

        @Override
        public void setSelection(boolean checked, ModalItem proxy) {
            if (proxy != this.tool) {
                throw new AssertionError((Object)"Tool not provided for MenuCurrentToolItem");
            }
            if (!this.menuItem.isDisposed()) {
                this.menuItem.setSelection(checked);
            }
        }

        @Override
        protected boolean isChecked() {
            if (!this.menuItem.isDisposed()) {
                return this.menuItem.getSelection();
            }
            return false;
        }

        @Override
        public boolean isDisposed() {
            return this.menuItem == null || this.menuItem.isDisposed();
        }
    }
}

