/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.tool.display;

import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.tool.display.ToolProxy;
import net.refractions.udig.project.ui.tool.IToolHandler;
import net.refractions.udig.project.ui.tool.Tool;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class HandlerProxy
extends AbstractHandler {
    private volatile IToolHandler instance;
    private IConfigurationElement toolElement;
    private ToolProxy tool;
    public static final String ID = "commandHandler";
    private final String commandId;

    public HandlerProxy(IConfigurationElement toolElement, ToolProxy tool, String commandId) {
        this.toolElement = toolElement;
        this.tool = tool;
        this.commandId = commandId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IToolHandler getToolHandler() {
        HandlerProxy handlerProxy = this;
        synchronized (handlerProxy) {
            if (this.instance == null) {
                try {
                    this.instance = (IToolHandler)this.toolElement.createExecutableExtension(ID);
                    this.instance.setTool(this.tool.getTool());
                }
                catch (CoreException e) {
                    ProjectUIPlugin.log(null, e);
                    this.instance = new EmptyHandler();
                }
            }
            this.instance.setCurrentCommandId(this.commandId);
        }
        return this.instance;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        return this.getToolHandler().execute(event);
    }

    public static class EmptyHandler
    extends AbstractHandler
    implements IToolHandler {
        @Override
        public void setTool(Tool tool) {
        }

        @Override
        public void setCurrentCommandId(String currentCommandId) {
        }

        public Object execute(ExecutionEvent event) {
            return null;
        }
    }
}

