/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.tool.display;

import java.text.MessageFormat;
import java.util.List;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.tool.display.CurrentContributionItem;
import net.refractions.udig.project.ui.internal.tool.display.ModalItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class AbstractToolbarContributionItem
extends CurrentContributionItem {
    ToolItem toolItem;
    protected ModalItem currentTool;
    private boolean checked;

    public final void fill(final ToolBar parent, int index) {
        if (this.getTools().size() == 0) {
            return;
        }
        this.toolItem = this.createToolItem(parent, index);
        ModalItem firstTool = this.getTools().get(0);
        this.currentTool = null;
        this.setCurrentTool(firstTool);
        if (this.isActiveItem() || this.isDefaultItem()) {
            this.runCurrentTool();
        }
        this.toolItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 4) {
                    final Menu menu = new Menu((Control)parent);
                    for (final ModalItem tool : AbstractToolbarContributionItem.this.getTools()) {
                        MenuItem menuItem = new MenuItem(menu, 8);
                        menuItem.setImage(tool.getImage());
                        menuItem.setText(tool.getName());
                        menuItem.setEnabled(tool.isEnabled());
                        menuItem.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent e) {
                                this.widgetDefaultSelected(e);
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                                AbstractToolbarContributionItem.this.setCurrentTool(tool);
                                AbstractToolbarContributionItem.this.runCurrentTool();
                                menu.dispose();
                            }
                        });
                    }
                    menu.setVisible(true);
                } else {
                    AbstractToolbarContributionItem.this.runCurrentTool();
                }
            }
        });
    }

    protected abstract boolean isDefaultItem();

    protected abstract boolean isActiveItem();

    protected abstract ToolItem createToolItem(ToolBar var1, int var2);

    protected abstract List<ModalItem> getTools();

    protected void setCurrentTool(final ModalItem tool) {
        if (this.currentTool == tool) {
            return;
        }
        this.currentTool = tool;
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractToolbarContributionItem.this.setWidgetState(tool);
                }
            });
        } else {
            this.setWidgetState(tool);
        }
    }

    private void setWidgetState(ModalItem tool) {
        if (!this.isDisposed() && this.toolItem != null) {
            if (this.toolItem.getImage() == null) {
                this.toolItem.setImage(tool.getImage());
            }
            this.toolItem.setToolTipText(tool.getToolTipText());
        }
    }

    @Override
    public void setSelection(boolean checked, ModalItem tool) {
        if (this.toolItem != null && !this.toolItem.isDisposed()) {
            this.setCurrentTool(tool);
            if (checked) {
                Image activeImage = tool.getActiveImage();
                if (activeImage != null) {
                    this.toolItem.setImage(activeImage);
                }
            } else {
                Image image = tool.getImage();
                if (image != null) {
                    this.toolItem.setImage(image);
                }
            }
            this.checked = checked;
        }
    }

    @Override
    protected boolean isChecked() {
        return this.checked;
    }

    protected void runCurrentTool() {
        if (this.currentTool != null) {
            if (this.currentTool.isEnabled()) {
                this.currentTool.run();
            } else {
                Display disp = Display.getDefault();
                MessageDialog.openWarning((Shell)disp.getActiveShell(), (String)Messages.AbstractToolbarContributionItem_warning_title, (String)MessageFormat.format(Messages.AbstractToolbarContributionItem_warning_message, this.currentTool.getName()));
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.toolItem != null && this.toolItem.isDisposed();
    }

    public void incrementSelection() {
        if (!this.isEnabledTool()) {
            return;
        }
        int index = this.getTools().indexOf(this.currentTool);
        index = index == this.getTools().size() - 1 ? 0 : ++index;
        ModalItem modalItem = this.getTools().get(index);
        this.setCurrentTool(modalItem);
        if (!modalItem.isEnabled()) {
            this.incrementSelection();
        }
    }

    private boolean isEnabledTool() {
        for (ModalItem item : this.getTools()) {
            if (!item.isEnabled()) continue;
            return true;
        }
        return false;
    }
}

