/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.render.displayAdapter.impl;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.render.Tile;
import net.refractions.udig.project.render.displayAdapter.IMapDisplayListener;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.render.displayAdapter.impl.EventHandler;
import net.refractions.udig.project.ui.internal.render.displayAdapter.impl.EventJob;
import net.refractions.udig.project.ui.internal.render.displayAdapter.impl.ViewportPainter;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseListener;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseMotionListener;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseWheelListener;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.project.ui.render.glass.GlassPane;
import net.refractions.udig.ui.graphics.NonAdvancedSWTGraphics;
import net.refractions.udig.ui.graphics.SWTGraphics;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class ViewportPaneTiledSWT
extends Canvas
implements ViewportPane {
    private final Repainter REPAINT = new Repainter();
    private static final long serialVersionUID = 1L;
    private ViewportPainter painter = new ViewportPainter(this);
    EventJob eventJob = new EventJob();
    private RenderManager renderManager;
    private EventHandler handler;
    private MapPart editor;
    Dimension displaySize = new Dimension(0, 0);
    private Display display;
    private volatile Object disposeMutex;
    private volatile Rectangle repaintRequest = null;
    private final Rectangle ZERO_RECTANGLE = new Rectangle(0, 0, 0, 0);
    private Object repaintRequestMutex = new Object();
    private Image buffer;
    private final int dpi;
    private GlassPane glass;
    private Map<ReferencedEnvelope, Tile> cachedTiles = new HashMap<ReferencedEnvelope, Tile>();
    private Map<ReferencedEnvelope, Tile> readyTiles = new HashMap<ReferencedEnvelope, Tile>();

    @Override
    public BufferedImage image(int w, int h) {
        return new BufferedImage(w, h, 6);
    }

    public ViewportPaneTiledSWT(Composite comp, MapPart editor) {
        this(comp, 0x20240000, editor);
    }

    public ViewportPaneTiledSWT(Composite comp, int style, MapPart editor) {
        super(comp, style);
        this.dpi = this.calculateDPI();
        ProjectUIPlugin.trace("net.refractions.udig.project.ui/debug/viewport/trace", this.getClass(), "ViewportPaneSWT created", null);
        this.display = comp.getDisplay();
        this.editor = editor;
        this.addEventListeners();
    }

    private void addEventListeners() {
        this.handler = new EventHandler(this, this.eventJob);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Point size = ViewportPaneTiledSWT.this.getSize();
                if (ViewportPaneTiledSWT.this.displaySize != null && ViewportPaneTiledSWT.this.displaySize.width == size.x && ViewportPaneTiledSWT.this.displaySize.height == size.y) {
                    return;
                }
                ViewportPaneTiledSWT.this.displaySize = new Dimension(size.x, size.y);
                if (ViewportPaneTiledSWT.this.buffer != null) {
                    ViewportPaneTiledSWT.this.buffer.dispose();
                }
                if (size.x == 0 || size.y == 0) {
                    ViewportPaneTiledSWT.this.buffer = null;
                } else {
                    ViewportPaneTiledSWT.this.buffer = new Image((Device)ViewportPaneTiledSWT.this.display, size.x, size.y);
                }
            }
        });
        this.addListener(8, this.handler);
        this.addListener(3, this.handler);
        this.addListener(6, this.handler);
        this.addListener(7, this.handler);
        this.addListener(32, this.handler);
        this.addListener(5, this.handler);
        this.addListener(4, this.handler);
        this.addListener(37, this.handler);
        this.addListener(11, this.handler);
        this.addListener(1, this.handler);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                ViewportPaneTiledSWT.this.paint(event.gc, event.display);
            }
        });
    }

    private int calculateDPI() {
        Point dpi = this.getDisplay().getDPI();
        if (dpi.x != dpi.y) {
            return (dpi.x + dpi.y) / 2;
        }
        return dpi.x;
    }

    @Override
    public void setRenderManager(RenderManager manager) {
        this.renderManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(GC g, Display display) {
        if (g.isDisposed()) {
            return;
        }
        Object object = this.repaintRequestMutex;
        synchronized (object) {
            if (this.repaintRequest != this.ZERO_RECTANGLE) {
                if (g.getClipping() == null || this.repaintRequest == null) {
                    this.repaintRequest = this.ZERO_RECTANGLE;
                } else if (g.getClipping().equals((Object)this.repaintRequest)) {
                    this.repaintRequest = this.ZERO_RECTANGLE;
                } else if (g.getClipping().width == 0 && g.getClipping().height == 0) {
                    this.repaintRequest = this.ZERO_RECTANGLE;
                } else if (this.clipContainsRepaintRequest(g.getClipping())) {
                    this.repaintRequest = this.ZERO_RECTANGLE;
                }
            }
        }
        int antiAliasing = ProjectPlugin.getPlugin().getPreferenceStore().getBoolean("antiAliasingPreference") ? 1 : 0;
        g.setAntialias(antiAliasing);
        Map<ReferencedEnvelope, Tile> tiles = this.getTiles();
        this.getDoubleBufferGraphics(display, g, tiles, this.displaySize.width, this.displaySize.height);
        Object object2 = this.repaintRequestMutex;
        synchronized (object2) {
            if (this.repaintRequest != this.ZERO_RECTANGLE) {
                Rectangle rect = this.repaintRequest;
                this.repaintRequest = null;
                this.doRepaint(rect.x, rect.y, rect.width, rect.height);
            } else {
                this.repaintRequest = null;
            }
        }
    }

    private void getDoubleBufferGraphics(Display display, GC gc, Map<ReferencedEnvelope, Tile> tiles, int minWidth, int minHeight) {
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        boolean useAdvancedGraphics = store.getBoolean("advancedGraphics");
        if ((this.getStyle() & 0x20000000) == 0) {
            if (this.buffer == null) {
                this.buffer = new Image((Device)display, this.displaySize.width, this.displaySize.height);
            }
            Object swtGraphics = null;
            swtGraphics = useAdvancedGraphics ? new SWTGraphics(this.buffer, display) : new NonAdvancedSWTGraphics(this.buffer, display);
            if (this.renderManager.getViewportModelInternal().isBoundsChanging()) {
                ((GC)swtGraphics.getGraphics(GC.class)).setAdvanced(false);
            }
            this.painter.paint((ViewportGraphics)swtGraphics, tiles, minWidth, minHeight);
            swtGraphics.dispose();
            gc.drawImage(this.buffer, 0, 0);
        } else {
            Object swtGraphics = null;
            swtGraphics = useAdvancedGraphics ? new SWTGraphics(gc, display) : new NonAdvancedSWTGraphics(gc, display, null);
            if (this.renderManager.getViewportModelInternal().isBoundsChanging()) {
                ((GC)swtGraphics.getGraphics(GC.class)).setAdvanced(false);
            }
            this.painter.paint((ViewportGraphics)swtGraphics, tiles, minWidth, minHeight);
            swtGraphics.dispose();
        }
    }

    private boolean clipContainsRepaintRequest(Rectangle clipping) {
        return clipping.contains(this.repaintRequest.x, this.repaintRequest.y) && clipping.contains(this.repaintRequest.x + this.repaintRequest.width, this.repaintRequest.y) && clipping.contains(this.repaintRequest.x + this.repaintRequest.width, this.repaintRequest.y = this.repaintRequest.height) && clipping.contains(this.repaintRequest.x, this.repaintRequest.y + this.repaintRequest.height);
    }

    Map<ReferencedEnvelope, Tile> getTiles() {
        if (!Platform.isRunning()) {
            return null;
        }
        if (this.readyTiles != null && !this.readyTiles.isEmpty() && this.disposeMutex == null) {
            return this.readyTiles;
        }
        try {
            if (this.readyTiles != null) {
                this.clearReadyTiles();
            }
            this.disposeMutex = null;
            this.readyTiles = this.createTiles();
            HashMap<ReferencedEnvelope, Tile> tilesCopy = new HashMap<ReferencedEnvelope, Tile>(this.readyTiles);
            return tilesCopy;
        }
        catch (Throwable e) {
            ProjectUIPlugin.log(null, e);
            return null;
        }
    }

    public Collection<Tile> updateReadyTiles() {
        ReferencedEnvelope bnds = this.renderManager.getViewportModelInternal().getBounds();
        Collection newlist = this.renderManager.computeTileBounds(bnds, bnds.getWidth() / (double)this.renderManager.getMapDisplay().getWidth());
        ArrayList<ReferencedEnvelope> newTiles = new ArrayList<ReferencedEnvelope>();
        for (ReferencedEnvelope referencedEnvelope : newlist) {
            if (this.readyTiles.containsKey(referencedEnvelope)) continue;
            newTiles.add(referencedEnvelope);
        }
        Map tiles = this.renderManager.getTiles(newTiles);
        this.readyTiles.putAll(tiles);
        return tiles.values();
    }

    public void clearCachedTiles() {
        Set<Map.Entry<ReferencedEnvelope, Tile>> entrySet = this.cachedTiles.entrySet();
        for (Map.Entry<ReferencedEnvelope, Tile> set : entrySet) {
            Tile tile = set.getValue();
            if (this.readyTiles.containsValue(tile)) continue;
            tile.disposeSWTImage();
        }
        this.cachedTiles.clear();
    }

    public void clearReadyTiles() {
        Set<Map.Entry<ReferencedEnvelope, Tile>> entrySet = this.readyTiles.entrySet();
        for (Map.Entry<ReferencedEnvelope, Tile> set : entrySet) {
            Tile tile = set.getValue();
            tile.disposeSWTImage();
        }
        this.readyTiles.clear();
    }

    private Map<ReferencedEnvelope, Tile> createTiles() {
        ReferencedEnvelope viewportbounds = this.renderManager.getViewportModelInternal().getBounds();
        Collection bounds = this.renderManager.computeTileBounds(viewportbounds, viewportbounds.getWidth() / (double)this.getWidth());
        Map tiles = this.renderManager.getTiles(bounds);
        this.clearCachedTiles();
        this.cachedTiles.putAll(tiles);
        return tiles;
    }

    void initMap() {
        if (this.renderManager.getViewportModelInternal().isBoundsChanging()) {
            return;
        }
        this.disposeMutex = new Object();
    }

    @Override
    public void renderStarting() {
        this.painter.renderStart();
        this.repaint();
    }

    @Override
    public void renderDone() {
        this.renderUpdate();
        this.painter.renderDone();
    }

    @Override
    public void renderUpdate() {
        this.initMap();
        this.painter.renderUpdate();
        this.repaint();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.readyTiles != null) {
            this.clearReadyTiles();
        }
        if (this.cachedTiles != null) {
            this.clearCachedTiles();
        }
    }

    @Override
    public void addDrawCommand(IDrawCommand command) {
        this.painter.addDrawCommand(command);
    }

    public void setCursor(final Cursor cursor) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                String name = cursor.getName();
                if (name.equals("Default Cursor")) {
                    ViewportPaneTiledSWT.this.setCursor(new org.eclipse.swt.graphics.Cursor((Device)ViewportPaneTiledSWT.this.display, 0));
                } else if (name.equals("Crosshair Cursor")) {
                    ViewportPaneTiledSWT.this.setCursor(new org.eclipse.swt.graphics.Cursor((Device)ViewportPaneTiledSWT.this.display, 2));
                } else if (name.equals("Text Cursor")) {
                    ViewportPaneTiledSWT.this.setCursor(new org.eclipse.swt.graphics.Cursor((Device)ViewportPaneTiledSWT.this.display, 19));
                } else if (name.equals("Wait Cursor")) {
                    ViewportPaneTiledSWT.this.setCursor(new org.eclipse.swt.graphics.Cursor((Device)ViewportPaneTiledSWT.this.display, 1));
                } else if (name.equals("SW Resize Cursor")) {
                    ViewportPaneTiledSWT.this.setCursor(new org.eclipse.swt.graphics.Cursor((Device)ViewportPaneTiledSWT.this.display, 16));
                } else if (name.equals("SE Resize Cursor")) {
                    ViewportPaneTiledSWT.this.setCursor(new org.eclipse.swt.graphics.Cursor((Device)ViewportPaneTiledSWT.this.display, 15));
                } else if (name.equals("NW Resize Cursor")) {
                    ViewportPaneTiledSWT.this.setCursor(new org.eclipse.swt.graphics.Cursor((Device)ViewportPaneTiledSWT.this.display, 17));
                } else if (name.equals("NE Resize Cursor")) {
                    ViewportPaneTiledSWT.this.setCursor(new org.eclipse.swt.graphics.Cursor((Device)ViewportPaneTiledSWT.this.display, 14));
                } else if (name.equals("N Resize Cursor")) {
                    ViewportPaneTiledSWT.this.setCursor(new org.eclipse.swt.graphics.Cursor((Device)ViewportPaneTiledSWT.this.display, 10));
                } else if (name.equals("S Resize Cursor")) {
                    ViewportPaneTiledSWT.this.setCursor(new org.eclipse.swt.graphics.Cursor((Device)ViewportPaneTiledSWT.this.display, 11));
                } else if (name.equals("W Resize Cursor")) {
                    ViewportPaneTiledSWT.this.setCursor(new org.eclipse.swt.graphics.Cursor((Device)ViewportPaneTiledSWT.this.display, 13));
                } else if (name.equals("E Resize Cursor")) {
                    ViewportPaneTiledSWT.this.setCursor(new org.eclipse.swt.graphics.Cursor((Device)ViewportPaneTiledSWT.this.display, 12));
                } else if (name.equals("Hand Cursor")) {
                    ViewportPaneTiledSWT.this.setCursor(new org.eclipse.swt.graphics.Cursor((Device)ViewportPaneTiledSWT.this.display, 21));
                } else if (name.equals("Move Cursor")) {
                    ViewportPaneTiledSWT.this.setCursor(new org.eclipse.swt.graphics.Cursor((Device)ViewportPaneTiledSWT.this.display, 5));
                }
            }
        });
    }

    @Override
    public void removeMouseListener(MapMouseListener l) {
        this.eventJob.removeMouseListener(l);
    }

    @Override
    public void removeMouseMotionListener(MapMouseMotionListener l) {
        this.eventJob.removeMouseMotionListener(l);
    }

    @Override
    public void removeMouseWheelListener(MapMouseWheelListener l) {
        this.eventJob.removeMouseWheelListener(l);
    }

    @Override
    public void addMouseListener(MapMouseListener l) {
        this.eventJob.addMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(MapMouseMotionListener l) {
        this.eventJob.addMouseMotionListener(l);
    }

    @Override
    public void addMouseWheelListener(MapMouseWheelListener l) {
        this.eventJob.addMouseWheelListener(l);
    }

    public Dimension getDisplaySize() {
        return this.displaySize;
    }

    public int getWidth() {
        return this.getDisplaySize().width;
    }

    public int getHeight() {
        return this.getDisplaySize().height;
    }

    @Override
    public void addPaneListener(IMapDisplayListener listener) {
        this.eventJob.addMapEditorListener(listener);
    }

    @Override
    public void removePaneListener(IMapDisplayListener listener) {
        this.eventJob.removeMapEditorListener(listener);
    }

    @Override
    public MapPart getMapEditor() {
        return this.editor;
    }

    public int getDPI() {
        return this.dpi;
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public void update() {
        super.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repaint(int x, int y, int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        Object object = this.repaintRequestMutex;
        synchronized (object) {
            Rectangle rectangle = new Rectangle(x, y, width, height);
            if (this.repaintRequest == null) {
                this.repaintRequest = rectangle;
                this.doRepaint(x, y, width, height);
            } else if (this.repaintRequest == this.ZERO_RECTANGLE) {
                this.repaintRequest = rectangle;
            } else {
                this.repaintRequest.union(rectangle);
            }
        }
    }

    private void doRepaint(int x, int y, int width, int height) {
        this.REPAINT.x = x;
        this.REPAINT.y = y;
        this.REPAINT.width = width;
        this.REPAINT.height = height;
        if (Display.getCurrent() != null) {
            this.REPAINT.run();
        } else {
            this.display.asyncExec((Runnable)this.REPAINT);
        }
    }

    @Override
    public void repaint() {
        this.repaint(0, 0, this.displaySize.width, this.displaySize.height);
    }

    @Override
    public void enableDrawCommands(boolean enable) {
        this.painter.switchOnOff(enable);
    }

    @Override
    public void setCursor(org.eclipse.swt.graphics.Cursor cursor) {
        super.setCursor(cursor);
    }

    @Override
    public GlassPane getGlass() {
        return this.glass;
    }

    @Override
    public void setGlass(GlassPane glass) {
        this.glass = glass;
    }

    private class Repainter
    implements Runnable {
        int x;
        int y;
        int width;
        int height;

        private Repainter() {
        }

        @Override
        public void run() {
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            if (!ViewportPaneTiledSWT.this.isDisposed()) {
                ViewportPaneTiledSWT.this.redraw(this.x, this.y, this.width, this.height, false);
            }
        }
    }
}

