/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.render.displayAdapter.impl;

import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.project.render.displayAdapter.IMapDisplayListener;
import net.refractions.udig.project.render.displayAdapter.MapDisplayEvent;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseListener;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseMotionListener;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseWheelEvent;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseWheelListener;
import org.eclipse.swt.widgets.Display;

public class EventJob {
    private CopyOnWriteArraySet<IMapDisplayListener> paneListener = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<MapMouseWheelListener> wheel = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<MapMouseMotionListener> motion = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<MapMouseListener> mouse = new CopyOnWriteArraySet();
    public static final int DOUBLE_CLICK = 1;
    public static final int PRESSED = 2;
    public static final int RELEASED = 3;
    public static final int MOVED = 4;
    public static final int DRAGGED = 5;
    public static final int ENTERED = 6;
    public static final int EXITED = 7;
    public static final int WHEEL = 8;
    public static final int RESIZED = 9;
    public static final int HOVERED = 10;
    private DoubleClickAttempt next = null;
    private final Runnable checkDoubleClick = new Runnable(){

        @Override
        public void run() {
            if (EventJob.this.next == null) {
                return;
            }
            DoubleClickAttempt e = EventJob.this.next;
            EventJob.this.next = null;
            EventJob.this.runEvent(new Event[]{e.first, e.release, e.third});
        }
    };

    public void fire(int type, Object event) {
        Event event1 = new Event(type, event);
        if (event1.type == 2 || this.next != null) {
            this.tryForDoubleClick(event1);
        } else {
            this.runEvent(event1);
        }
    }

    private void runEvent(Event ... event2) {
        Event[] eventArray = event2;
        int n = event2.length;
        int n2 = 0;
        while (n2 < n) {
            Event event = eventArray[n2];
            if (event != null) {
                try {
                    switch (event.type) {
                        case 1: {
                            this.sendDoubleClickEvent(event);
                            break;
                        }
                        case 2: {
                            this.sendMousePressedEvent(event);
                            break;
                        }
                        case 3: {
                            this.sendMouseReleased(event);
                            break;
                        }
                        case 4: {
                            this.sendMouseMoved(event);
                            break;
                        }
                        case 5: {
                            this.sendMouseDragged(event);
                            break;
                        }
                        case 6: {
                            this.sendMouseEntered(event);
                            break;
                        }
                        case 7: {
                            this.sendMouseExited(event);
                            break;
                        }
                        case 8: {
                            this.sendMouseWheel(event);
                            break;
                        }
                        case 9: {
                            this.sendResized(event);
                            break;
                        }
                        case 10: {
                            this.sendHovered(event);
                            break;
                        }
                        default: {
                            System.err.println("Event requested that does not exist " + event.type);
                            break;
                        }
                    }
                }
                catch (Throwable t) {
                    ProjectUIPlugin.log("", t);
                }
            }
            ++n2;
        }
    }

    private void tryForDoubleClick(Event event) {
        if (this.next == null) {
            this.next = new DoubleClickAttempt();
            this.next.first = event;
            Display.getCurrent().timerExec(ProjectUIPlugin.getDefault().getDoubleClickSpeed(), this.checkDoubleClick);
        } else if (this.next.release == null) {
            if (event.type == 3) {
                this.next.release = event;
                return;
            }
            Event first = this.next.first;
            this.next = null;
            this.runEvent(first, event);
        } else {
            switch (event.type) {
                case 3: {
                    if (this.next.third != null) {
                        this.next = null;
                        this.sendDoubleClickEvent(new Event(1, event.data));
                        return;
                    }
                    this.cancelDoubleClickWait(event);
                    break;
                }
                case 2: {
                    if (this.next.release != null && this.next.third == null) {
                        this.next.third = event;
                        break;
                    }
                    this.cancelDoubleClickWait(event);
                    break;
                }
                default: {
                    this.cancelDoubleClickWait(event);
                }
            }
        }
    }

    private void cancelDoubleClickWait(Event event) {
        Event first = this.next.first;
        Event release = this.next.release;
        Event third = this.next.third;
        this.next = null;
        this.runEvent(first, release, third, event);
    }

    private void sendResized(Event event) {
        for (IMapDisplayListener l : this.paneListener) {
            try {
                l.sizeChanged((MapDisplayEvent)event.data);
            }
            catch (Throwable t) {
                ProjectUIPlugin.log("Error processing a resized event", t);
            }
        }
    }

    private void sendMouseWheel(Event event) {
        for (MapMouseWheelListener l : this.wheel) {
            try {
                l.mouseWheelMoved((MapMouseWheelEvent)event.data);
            }
            catch (Throwable t) {
                ProjectUIPlugin.log("Error processing a mouse wheel event", t);
            }
        }
    }

    private void sendMouseExited(Event event) {
        for (MapMouseListener l : this.mouse) {
            try {
                l.mouseExited((MapMouseEvent)event.data);
            }
            catch (Throwable t) {
                ProjectUIPlugin.log("Error processing a moouse exited event", t);
            }
        }
    }

    private void sendHovered(Event event) {
        for (MapMouseMotionListener l : this.motion) {
            try {
                l.mouseHovered((MapMouseEvent)event.data);
            }
            catch (Throwable t) {
                ProjectUIPlugin.log("Error processing a mouse dragged event", t);
            }
        }
    }

    private void sendMouseEntered(Event event) {
        for (MapMouseListener l : this.mouse) {
            try {
                l.mouseEntered((MapMouseEvent)event.data);
            }
            catch (Throwable t) {
                ProjectUIPlugin.log("Error processing a mouse entered event", t);
            }
        }
    }

    private void sendMouseDragged(Event event) {
        for (MapMouseMotionListener l : this.motion) {
            try {
                l.mouseDragged((MapMouseEvent)event.data);
            }
            catch (Throwable t) {
                ProjectUIPlugin.log("Error processing a mouse dragged event", t);
            }
        }
    }

    private void sendMouseMoved(Event event) {
        for (MapMouseMotionListener l : this.motion) {
            try {
                l.mouseMoved((MapMouseEvent)event.data);
            }
            catch (Throwable t) {
                ProjectUIPlugin.log("Error processing a mouse dragged event", t);
            }
        }
    }

    private void sendMouseReleased(Event event) {
        for (MapMouseListener l : this.mouse) {
            try {
                l.mouseReleased((MapMouseEvent)event.data);
            }
            catch (Throwable t) {
                ProjectUIPlugin.log("Error processing a mouse released event", t);
            }
        }
    }

    private void sendMousePressedEvent(Event event) {
        for (MapMouseListener l : this.mouse) {
            try {
                l.mousePressed((MapMouseEvent)event.data);
            }
            catch (Throwable t) {
                ProjectUIPlugin.log("Error processing a mouse pressed event", t);
            }
        }
    }

    private void sendDoubleClickEvent(Event event) {
        for (MapMouseListener l : this.mouse) {
            try {
                l.mouseDoubleClicked((MapMouseEvent)event.data);
            }
            catch (Throwable t) {
                ProjectUIPlugin.log("Error processing a double clicked event", t);
            }
        }
    }

    public void addMapEditorListener(IMapDisplayListener l) {
        this.paneListener.add(l);
    }

    public void removeMapEditorListener(IMapDisplayListener l) {
        this.paneListener.remove(l);
    }

    public void addMouseListener(MapMouseListener l) {
        this.mouse.add(l);
    }

    public void addMouseMotionListener(MapMouseMotionListener l) {
        this.motion.add(l);
    }

    public void addMouseWheelListener(MapMouseWheelListener l) {
        this.wheel.add(l);
    }

    public void removeMouseListener(MapMouseListener l) {
        this.mouse.remove(l);
    }

    public void removeMouseMotionListener(MapMouseMotionListener l) {
        this.motion.remove(l);
    }

    public void removeMouseWheelListener(MapMouseWheelListener l) {
        this.wheel.remove(l);
    }

    static class DoubleClickAttempt {
        Event first;
        Event release;
        Event third;

        DoubleClickAttempt() {
        }
    }

    private static class Event {
        final int type;
        final Object data;

        Event(int type, Object event) {
            this.type = type;
            this.data = event;
        }
    }
}

