/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.property.pages;

import net.refractions.udig.project.Interaction;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.internal.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.geometry.jts.Geometries;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class LayerInteractionPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Button visibleButton;
    private Button layerButton;
    private Button informationButton;
    private Button selectButton;
    private Button editButton;
    private Button backgroundButton;
    private Button aoiButton;
    private Layer layer;
    private boolean isPolygon = false;
    private boolean isRaster = false;

    protected Control createContents(Composite parent) {
        this.layer = (Layer)this.getElement();
        SimpleFeatureType schema = this.layer.getSchema();
        if (schema != null) {
            GeometryDescriptor geomDescriptor = schema.getGeometryDescriptor();
            if (geomDescriptor != null) {
                Class binding = geomDescriptor.getType().getBinding();
                switch (Geometries.getForBinding((Class)binding)) {
                    case POLYGON: 
                    case MULTIPOLYGON: {
                        this.isPolygon = true;
                    }
                }
            }
        } else if (this.layer.canAdaptTo(AbstractGridCoverage2DReader.class)) {
            this.isRaster = true;
        }
        Composite interactionPage = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        interactionPage.setLayout((Layout)layout);
        Group generalGroup = new Group(interactionPage, 16);
        generalGroup.setText(Messages.LayerInteraction_General);
        this.visibleButton = new Button((Composite)generalGroup, 32);
        this.visibleButton.setText(Messages.LayerInteraction_Visible);
        this.visibleButton.setLocation(40, 20);
        this.visibleButton.pack();
        this.visibleButton.addSelectionListener(this.defaultSelectionListener());
        Group toolsGroup = new Group(interactionPage, 16);
        toolsGroup.setText(Messages.LayerInteraction_Tools);
        this.layerButton = new Button((Composite)toolsGroup, 16);
        this.layerButton.setText(Messages.LayerInteraction_Layer);
        this.layerButton.setLocation(20, 20);
        this.layerButton.pack();
        this.layerButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                LayerInteractionPropertyPage.this.setBackgroundLayer(!LayerInteractionPropertyPage.this.layerButton.getSelection());
                LayerInteractionPropertyPage.this.setApplyButton();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.informationButton = new Button((Composite)toolsGroup, 32);
        this.informationButton.setText(Messages.LayerInteraction_Information);
        this.informationButton.setLocation(40, 40);
        this.informationButton.pack();
        this.informationButton.addSelectionListener(this.defaultSelectionListener());
        this.selectButton = new Button((Composite)toolsGroup, 32);
        this.selectButton.setText(Messages.LayerInteraction_Select);
        this.selectButton.setLocation(40, 60);
        this.selectButton.pack();
        this.selectButton.addSelectionListener(this.defaultSelectionListener());
        this.editButton = new Button((Composite)toolsGroup, 32);
        this.editButton.setText(Messages.LayerInteraction_Edit);
        this.editButton.setLocation(40, 80);
        this.editButton.pack();
        this.editButton.addSelectionListener(this.defaultSelectionListener());
        this.backgroundButton = new Button((Composite)toolsGroup, 16);
        this.backgroundButton.setText(Messages.LayerInteraction_Background);
        this.backgroundButton.setLocation(20, 100);
        this.backgroundButton.pack();
        this.backgroundButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                LayerInteractionPropertyPage.this.setBackgroundLayer(LayerInteractionPropertyPage.this.backgroundButton.getSelection());
                LayerInteractionPropertyPage.this.setApplyButton();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.aoiButton = new Button((Composite)toolsGroup, 32);
        this.aoiButton.setText(Messages.LayerInteraction_AOI);
        this.aoiButton.setLocation(40, 120);
        this.aoiButton.pack();
        this.aoiButton.addSelectionListener(this.defaultSelectionListener());
        this.loadLayer();
        return interactionPage;
    }

    private SelectionListener defaultSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                LayerInteractionPropertyPage.this.setApplyButton();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        };
    }

    public boolean performOk() {
        this.saveLayer();
        return super.performOk();
    }

    protected void performApply() {
        this.saveLayer();
        super.performApply();
    }

    protected void performDefaults() {
        this.loadLayer();
        super.performDefaults();
    }

    protected void setApplyButton() {
        boolean changed = this.visibleButton.getSelection() != this.layer.isVisible() || this.backgroundButton.getSelection() != this.layer.getInteraction(Interaction.BACKGROUND) || this.informationButton.getSelection() != this.layer.getInteraction(Interaction.INFO) || this.selectButton.getSelection() != this.layer.isSelectable() || this.editButton.getSelection() != this.layer.getInteraction(Interaction.EDIT) || this.aoiButton.getSelection() != this.layer.getInteraction(Interaction.AOI);
        this.getApplyButton().setEnabled(changed);
        this.getDefaultsButton().setEnabled(changed);
    }

    private void saveLayer() {
        if (this.visibleButton.getSelection() != this.layer.isVisible()) {
            this.layer.setVisible(this.visibleButton.getSelection());
        }
        if (this.backgroundButton.getSelection() != this.layer.getInteraction(Interaction.BACKGROUND)) {
            this.layer.setInteraction(Interaction.BACKGROUND, this.backgroundButton.getSelection());
        }
        if (this.informationButton.getSelection() != this.layer.getInteraction(Interaction.INFO)) {
            this.layer.setInteraction(Interaction.INFO, this.informationButton.getSelection());
        }
        if (this.selectButton.getSelection() != this.layer.isSelectable()) {
            this.layer.setSelectable(this.selectButton.getSelection());
        }
        if (this.editButton.getSelection() != this.layer.getInteraction(Interaction.EDIT)) {
            this.layer.setInteraction(Interaction.EDIT, this.editButton.getSelection());
        }
        if (this.aoiButton.getSelection() != this.layer.getInteraction(Interaction.AOI)) {
            this.layer.setInteraction(Interaction.AOI, this.aoiButton.getSelection());
        }
    }

    private void loadLayer() {
        this.visibleButton.setSelection(this.layer.isVisible());
        boolean isBackgroundLayer = this.layer.getInteraction(Interaction.BACKGROUND);
        this.backgroundButton.setSelection(isBackgroundLayer);
        this.layerButton.setSelection(!isBackgroundLayer);
        this.setBackgroundLayer(isBackgroundLayer);
    }

    private void enableButton(Button button, boolean selection) {
        button.setEnabled(true);
        button.setSelection(selection);
    }

    private void disableButton(Button button) {
        button.setEnabled(false);
        button.setSelection(false);
    }

    private void setBackgroundLayer(boolean selection) {
        if (selection) {
            this.setPolygonLayer();
            this.disableButton(this.informationButton);
            this.disableButton(this.selectButton);
            this.disableButton(this.editButton);
        } else {
            this.setRasterLayer();
            this.disableButton(this.aoiButton);
        }
    }

    private void setPolygonLayer() {
        this.aoiButton.setEnabled(this.isPolygon);
        if (this.isPolygon) {
            this.aoiButton.setSelection(this.layer.getInteraction(Interaction.AOI));
        } else {
            this.aoiButton.setSelection(false);
        }
    }

    private void setRasterLayer() {
        if (this.isRaster) {
            this.enableButton(this.informationButton, this.layer.getInteraction(Interaction.INFO));
            this.disableButton(this.selectButton);
            this.disableButton(this.editButton);
        } else {
            this.enableButton(this.informationButton, this.layer.getInteraction(Interaction.INFO));
            this.enableButton(this.selectButton, this.layer.isSelectable());
            this.enableButton(this.editButton, this.layer.getInteraction(Interaction.EDIT));
        }
    }
}

