/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.properties;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.command.navigation.SetViewportBBoxCommand;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.geotools.geometry.jts.JTS;
import org.opengis.referencing.operation.MathTransform;

public class GeometryPropertyDescriptor
extends PropertyDescriptor {
    public GeometryPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return new CellEditor(parent, 0){
            Geometry geometry;
            private Button button;
            private Label label;

            protected Control createControl(Composite comp) {
                Composite parent = new Composite(comp, 0);
                parent.setLayout((Layout)new GridLayout(2, false));
                this.label = new Label(parent, 8);
                if (this.geometry != null) {
                    this.label.setText(GeometryPropertyDescriptor.this.getLabelProvider().getText((Object)this.geometry));
                }
                GridData data = new GridData(4, 4, true, true);
                data.verticalSpan = 2;
                this.label.setLayoutData((Object)data);
                this.button = new Button(parent, 0x800008);
                this.button.setText(Messages.GeometryPropertyDescriptor_viewButton_text);
                data = new GridData(131072, 128, false, false);
                data.verticalSpan = 1;
                this.button.setLayoutData((Object)data);
                this.button.addListener(4, new Listener(){

                    public void handleEvent(Event event) {
                        MapEditorPart editor = (MapEditorPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                        Map map = editor.getMap();
                        Envelope env = geometry.getEnvelopeInternal();
                        try {
                            env = JTS.transform((Envelope)env, (MathTransform)map.getEditManager().getEditLayer().layerToMapTransform());
                        }
                        catch (Exception e1) {
                            ProjectUIPlugin.log(null, e1);
                        }
                        map.sendCommandASync((MapCommand)new SetViewportBBoxCommand(env, map.getViewportModel().getCRS()));
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)editor);
                    }
                });
                this.button.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        if (e.character == '\u001b') {
                            this.fireCancelEditor();
                        }
                    }
                });
                return parent;
            }

            protected Object doGetValue() {
                return this.geometry;
            }

            protected void doSetFocus() {
                this.button.setFocus();
            }

            protected void doSetValue(Object value) {
                this.geometry = (Geometry)value;
                this.label.setText(GeometryPropertyDescriptor.this.getLabelProvider().getText((Object)this.geometry));
            }
        };
    }

    public ILabelProvider getLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                Geometry geom = (Geometry)element;
                return geom.getGeometryType();
            }
        };
    }
}

