/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.properties;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.EditCommand;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.factory.EditCommandFactory;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.properties.AttributePropertyDescriptor;
import net.refractions.udig.project.ui.internal.properties.AttributePropertySource;
import net.refractions.udig.project.ui.internal.properties.GeomPropertySource;
import net.refractions.udig.project.ui.internal.properties.GeometryPropertyDescriptor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.util.CodeList;

public class FeaturePropertySource
implements IPropertySource2 {
    private static final String ID = "ID";
    private static final String DEFAULT_GEOM = "DEFAULT_GEOM";
    private static final String BOUNDING_BOX = "BOUNDING_BOX";
    private static final String FEATURE = "FEATURE";
    private SimpleFeature feature = null;
    private SimpleFeature old = null;
    private Map<Geometry, Object> geomProperties = new HashMap<Geometry, Object>();
    private Map<AttributeDescriptor, Object> attrProperties = new HashMap<AttributeDescriptor, Object>();
    private List<AttributeDescriptor> attrs;
    private IPropertyDescriptor[] descriptors;
    private boolean attribute;
    private boolean editable = true;
    private IMap map;

    public FeaturePropertySource(SimpleFeature feature) {
        this(feature, false);
    }

    public FeaturePropertySource(SimpleFeature feature2, boolean attribute) {
        IAdaptable adaptable;
        boolean editable = false;
        if (feature2 instanceof IAdaptable && ((adaptable = (IAdaptable)feature2).getAdapter(ILayer.class) != null || adaptable.getAdapter(IMap.class) != null)) {
            editable = true;
        }
        this.init(feature2, attribute, editable);
    }

    public FeaturePropertySource(SimpleFeature feature2, boolean attribute, boolean editable) {
        this.init(feature2, attribute, editable);
    }

    private void init(SimpleFeature feature2, boolean attribute, boolean editable) {
        this.feature = feature2;
        try {
            if (feature2 != null) {
                this.old = SimpleFeatureBuilder.copy((SimpleFeature)this.feature);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.attribute = attribute;
        this.editable = editable;
        if (editable) {
            IAdaptable adaptable = (IAdaptable)feature2;
            if (adaptable.getAdapter(ILayer.class) != null) {
                ILayer layer = (ILayer)adaptable.getAdapter(ILayer.class);
                this.map = layer.getMap();
            } else {
                this.map = adaptable.getAdapter(IMap.class) != null ? (IMap)adaptable.getAdapter(IMap.class) : ApplicationGIS.getActiveMap();
            }
        }
    }

    public Object getEditableValue() {
        return "";
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            boolean hasAttrs = false;
            ArrayList<PropertyDescriptor> descrps = new ArrayList<PropertyDescriptor>();
            Object d = new PropertyDescriptor((Object)ID, ID);
            d.setCategory(Messages.FeaturePropertySource_feature);
            descrps.add((PropertyDescriptor)d);
            d = new GeometryPropertyDescriptor(DEFAULT_GEOM, Messages.FeaturePropertySource_defaultGeometry);
            d.setCategory(Messages.FeaturePropertySource_geometries);
            descrps.add((PropertyDescriptor)d);
            d = new PropertyDescriptor((Object)BOUNDING_BOX, Messages.FeaturePropertySource_bounds);
            d.setCategory(Messages.FeaturePropertySource_feature);
            d.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    Envelope bbox = (Envelope)element;
                    String minx = String.valueOf(bbox.getMinX());
                    minx = minx.substring(0, Math.min(10, minx.length()));
                    String maxx = String.valueOf(bbox.getMaxX());
                    maxx = maxx.substring(0, Math.min(10, maxx.length()));
                    String miny = String.valueOf(bbox.getMinY());
                    miny = miny.substring(0, Math.min(10, miny.length()));
                    String maxy = String.valueOf(bbox.getMaxY());
                    maxy = maxy.substring(0, Math.min(10, maxy.length()));
                    return "(" + minx + "," + miny + "), (" + maxx + "," + maxy + ")";
                }
            });
            descrps.add((PropertyDescriptor)d);
            if (!this.attribute) {
                SimpleFeatureType ft = this.feature.getFeatureType();
                this.attrs = ft.getAttributeDescriptors();
                int i = -1;
                for (AttributeDescriptor at : this.attrs) {
                    ++i;
                    String name = at.getName().getLocalPart().toLowerCase();
                    name = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
                    if (at instanceof GeometryDescriptor) {
                        if (this.feature.getAttribute(at.getLocalName()) == this.feature.getDefaultGeometry()) continue;
                        d = new GeometryPropertyDescriptor(i, String.valueOf(name) + Messages.FeaturePropertySource_geometry);
                        d.setCategory(Messages.FeaturePropertySource_geometries);
                        descrps.add((PropertyDescriptor)d);
                        continue;
                    }
                    d = SimpleFeature.class.isAssignableFrom(at.getType().getBinding()) ? new PropertyDescriptor((Object)(FEATURE + Integer.valueOf(i)), name) : (Collection.class.isAssignableFrom(at.getType().getBinding()) ? new PropertyDescriptor((Object)i, name) : new AttributePropertyDescriptor(i, name, at, ft, this.editable));
                    if (name.equalsIgnoreCase("name")) {
                        d.setCategory(Messages.FeaturePropertySource_feature);
                        descrps.add(0, (PropertyDescriptor)d);
                        continue;
                    }
                    hasAttrs = true;
                    d.setCategory(Messages.FeaturePropertySource_featureAttributes);
                    descrps.add((PropertyDescriptor)d);
                }
            }
            if (!hasAttrs) {
                d = new PropertyDescriptor((Object)"", Messages.FeaturePropertySource_noOtherAttributes);
                d.setCategory(Messages.FeaturePropertySource_featureAttributes);
                descrps.add((PropertyDescriptor)d);
            }
            this.descriptors = new IPropertyDescriptor[descrps.size()];
            descrps.toArray(this.descriptors);
        }
        IPropertyDescriptor[] c = new IPropertyDescriptor[this.descriptors.length];
        System.arraycopy(this.descriptors, 0, c, 0, c.length);
        return c;
    }

    public Object getPropertyValue(Object id) {
        if (id instanceof String) {
            String sid = (String)id;
            if (sid.equals(ID)) {
                return this.feature.getID();
            }
            if (sid.equals(DEFAULT_GEOM)) {
                return this.getGeomProperty((Geometry)this.feature.getDefaultGeometry());
            }
            if (sid.equals(BOUNDING_BOX)) {
                return this.feature.getBounds();
            }
            if (sid.startsWith(FEATURE)) {
                int i = Integer.parseInt(sid.substring(FEATURE.length()));
                return new FeaturePropertySource((SimpleFeature)this.feature.getAttribute(i), true);
            }
        }
        if (id instanceof Integer) {
            Integer i = (Integer)id;
            AttributeDescriptor attrType = this.attrs.get(i);
            if (attrType instanceof GeometryDescriptor) {
                return this.getGeomProperty((Geometry)this.feature.getAttribute(i.intValue()));
            }
            if (Collection.class.isAssignableFrom(attrType.getType().getBinding())) {
                return this.getAttrProperty(attrType, this.feature.getAttribute(i.intValue()));
            }
            Object attr = this.feature.getAttribute(i.intValue());
            if (!(attr instanceof Boolean) && !(attr instanceof CodeList)) {
                if (attr != null) {
                    return attr.toString();
                }
                return "";
            }
            if (attr instanceof Boolean) {
                if (((Boolean)attr).booleanValue()) {
                    return 1;
                }
                return 0;
            }
            if (attr instanceof CodeList) {
                CodeList list = (CodeList)attr;
                return Integer.valueOf(list.ordinal()).toString();
            }
        }
        return null;
    }

    public SimpleFeature getFeature() {
        return this.feature;
    }

    public boolean isPropertySet(Object id) {
        int i;
        Object attr;
        if (id.equals(ID)) {
            return this.feature.getID() == this.old.getID();
        }
        if (id.equals(DEFAULT_GEOM)) {
            return this.feature.getDefaultGeometry() == this.old.getDefaultGeometry();
        }
        if (id.equals(BOUNDING_BOX)) {
            return this.feature.getBounds() == this.old.getBounds();
        }
        if (id instanceof Integer && ((attr = this.feature.getAttribute(i = ((Integer)id).intValue())) instanceof String || attr instanceof Integer || attr instanceof Double || attr instanceof Float || attr instanceof Boolean)) {
            return attr.equals(this.old.getAttribute(i));
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        try {
            int i;
            Object attr;
            if (id instanceof Integer && ((attr = this.feature.getAttribute(i = ((Integer)id).intValue())) instanceof String || attr instanceof Integer || attr instanceof Double || attr instanceof Float || attr instanceof Boolean)) {
                this.feature.setAttribute(i, this.old.getAttribute(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPropertyValue(Object id, Object value) {
        try {
            if (id instanceof Integer) {
                int i = (Integer)id;
                Object attr = this.feature.getAttribute(i);
                EditCommand command = (EditCommand)EditCommandFactory.getInstance().createSetAttributeCommand(this.attrs.get(i).getName().getLocalPart(), value);
                this.map.sendCommandASync((MapCommand)command);
                if (attr instanceof String) {
                    this.feature.setAttribute(i, value);
                } else if (attr instanceof Integer) {
                    this.feature.setAttribute(i, (Object)Integer.valueOf((String)value));
                } else if (attr instanceof Double) {
                    this.feature.setAttribute(i, (Object)Double.valueOf((String)value));
                } else if (attr instanceof Float) {
                    this.feature.setAttribute(i, (Object)Float.valueOf((String)value));
                } else if (attr instanceof Boolean) {
                    this.feature.setAttribute(i, (Object)((Integer)value == 0 ? 1 : 0));
                }
            }
            if (value instanceof Geometry && id.equals(DEFAULT_GEOM)) {
                this.feature.setDefaultGeometry((Object)((Geometry)value));
                EditCommand command = (EditCommand)EditCommandFactory.getInstance().createSetGeometryCommand((Geometry)value);
                this.map.sendCommandASync((MapCommand)command);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object getGeomProperty(Geometry id) {
        Object geom = this.geomProperties.get(id);
        if (geom == null) {
            geom = new GeomPropertySource(id);
            this.geomProperties.put(id, geom);
        }
        return geom;
    }

    private Object getAttrProperty(AttributeDescriptor id, Object value) {
        Object attr = this.attrProperties.get(id);
        if (attr == null) {
            attr = new AttributePropertySource(id, value);
            this.attrProperties.put(id, attr);
        }
        return attr;
    }

    public boolean isPropertyResettable(Object id) {
        return true;
    }
}

