/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.properties;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.ui.AttributeValidator;
import net.refractions.udig.ui.BasicTypeCellEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.util.CodeList;

public class AttributePropertyDescriptor
extends PropertyDescriptor {
    protected AttributeDescriptor type;
    AttributeValidator validator;
    private String[] comboBoxList;
    private boolean editable = false;

    public AttributePropertyDescriptor(Object id, String displayName, AttributeDescriptor type, SimpleFeatureType schema) {
        this(id, displayName, type, schema, false);
    }

    public AttributePropertyDescriptor(Object id, String displayName, AttributeDescriptor type, SimpleFeatureType schema, boolean editable) {
        super(id, displayName);
        this.type = type;
        this.validator = new AttributeValidator(type, schema);
        this.comboBoxList = this.createComboList();
        this.editable = editable;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (!this.editable) {
            return null;
        }
        try {
            if (Boolean.class.isAssignableFrom(this.type.getType().getBinding()) || Boolean.TYPE.isAssignableFrom(this.type.getType().getBinding())) {
                return new ComboBoxCellEditor(parent, new String[]{Messages.AttributePropertyDescriptor_true, Messages.AttributePropertyDescriptor_false});
            }
            if (String.class.isAssignableFrom(this.type.getType().getBinding())) {
                return new TextCellEditor(parent);
            }
            if (Integer.class.isAssignableFrom(this.type.getType().getBinding())) {
                return new BasicTypeCellEditor(parent, Integer.class);
            }
            if (Double.class.isAssignableFrom(this.type.getType().getBinding())) {
                return new BasicTypeCellEditor(parent, Double.class);
            }
            if (Float.class.isAssignableFrom(this.type.getType().getBinding())) {
                return new BasicTypeCellEditor(parent, Float.class);
            }
            if (Long.class.isAssignableFrom(this.type.getType().getBinding())) {
                return new BasicTypeCellEditor(parent, Long.class);
            }
            if (BigInteger.class.isAssignableFrom(this.type.getType().getBinding())) {
                return new BasicTypeCellEditor(parent, BigInteger.class);
            }
            if (BigDecimal.class.isAssignableFrom(this.type.getType().getBinding())) {
                return new BasicTypeCellEditor(parent, BigDecimal.class);
            }
            if (Long.class.isAssignableFrom(this.type.getType().getBinding())) {
                return new BasicTypeCellEditor(parent, Long.class);
            }
            if (CodeList.class.isAssignableFrom(this.type.getType().getBinding())) {
                return new ComboBoxCellEditor(parent, this.comboBoxList);
            }
            return super.createPropertyEditor(parent);
        }
        catch (Throwable t) {
            ProjectUIPlugin.log("error converting attribute to string", t);
            return null;
        }
    }

    String[] createComboList() {
        if (!CodeList.class.isAssignableFrom(this.type.getType().getBinding())) {
            return null;
        }
        CodeList list = (CodeList)this.type.getDefaultValue();
        CodeList[] family = list.family();
        String[] names = new String[family.length];
        int i = 0;
        while (i < names.length) {
            names[i] = family[i].name();
            ++i;
        }
        return names;
    }

    protected ICellEditorValidator getValidator() {
        return this.validator;
    }

    public ILabelProvider getLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "null";
                }
                if (Boolean.class.isAssignableFrom(AttributePropertyDescriptor.this.type.getType().getBinding()) && element instanceof Integer) {
                    int intValue = (Integer)element;
                    return intValue == 1 ? "true" : "false";
                }
                return element.toString();
            }
        };
    }

    public String[] getComboBoxList() {
        String[] c = new String[this.comboBoxList.length];
        System.arraycopy(this.comboBoxList, 0, c, 0, c.length);
        return c;
    }
}

