/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.commands.draw;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.project.ui.commands.IMapTransformCommand;
import net.refractions.udig.project.ui.commands.IPreMapDrawCommand;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import org.eclipse.core.runtime.IProgressMonitor;

public class ZoomDrawCommand
extends AbstractDrawCommand
implements IMapTransformCommand,
IPreMapDrawCommand {
    private AffineTransform transform;
    private int centerx;
    private int centery;

    public ZoomDrawCommand(int centerx, int centery, double zoom) {
        this.setZoom(centerx, centery, zoom);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        AffineTransform t = new AffineTransform(this.transform);
        t.concatenate(this.graphics.getTransform());
        this.graphics.setTransform(t);
    }

    public void setZoom(int centerx, int centery, double amount) {
        this.centerx = centerx;
        this.centery = centery;
        this.transform = AffineTransform.getTranslateInstance(centerx, centery);
        this.transform.scale(amount, amount);
        this.transform.translate(-centerx, -centery);
    }

    public void setZoom(double amount) {
        this.setZoom(this.centerx, this.centery, amount);
        if (this.display instanceof ViewportPane) {
            this.display.repaint();
        }
    }

    @Override
    public Rectangle getValidArea() {
        return null;
    }
}

