/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.commands.draw;

import java.util.List;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.project.ui.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public class StartAnimationCommand
extends AbstractCommand
implements UndoableMapCommand {
    private List<IAnimation> animations;
    private IMapDisplay display;

    public StartAnimationCommand(IMapDisplay display, List<IAnimation> animations) {
        this.animations = animations;
        this.display = display;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        for (IAnimation anim : this.animations) {
            anim.setValid(true);
            AnimationUpdater.runTimer(this.display, anim);
        }
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        for (IAnimation anim : this.animations) {
            anim.setValid(false);
        }
    }

    public String getName() {
        return Messages.StartAnimationCommand_name;
    }
}

