/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.commands.draw;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.PathIterator;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;

public class DrawPathCommand
extends AbstractDrawCommand {
    Path path = null;
    Color paint = null;
    private int style = -1;
    private int width;
    private Color fill;
    private boolean closeShape;
    private int closex1;
    private int closex2;
    private int closey1;
    private int closey2;

    public DrawPathCommand() {
        this(null, Color.BLACK, 1, 1);
    }

    public DrawPathCommand(Path path, Color color, int lineStyle, int lineWidth) {
        this.path = path;
        this.paint = color;
        this.style = lineStyle;
        this.width = lineWidth;
    }

    public DrawPathCommand(Device device, PathIterator path, Color color, int lineStyle, int lineWidth) {
        this.paint = color;
        this.style = lineStyle;
        this.width = lineWidth;
        this.path = AWTSWTImageUtils.createPath((PathIterator)path, (Device)device);
    }

    public void run(IProgressMonitor monitor) {
        if (this.path == null) {
            return;
        }
        this.fill();
        this.draw();
        this.close();
    }

    private void draw() {
        if (this.paint != null || this.fill == null) {
            if (this.paint != null) {
                this.graphics.setColor(this.paint);
            }
            if (this.style > -1) {
                this.graphics.setStroke(this.style, this.width);
            }
            if (this.path != null) {
                this.graphics.drawPath(this.path);
            }
        }
    }

    private void close() {
        if (this.closeShape) {
            this.graphics.drawLine(this.closex1, this.closey1, this.closex2, this.closey2);
        }
    }

    private void fill() {
        if (this.fill != null) {
            this.graphics.setColor(this.fill);
            if (this.path != null) {
                this.graphics.fillPath(this.path);
            }
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Color paint) {
        this.paint = paint;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public void setPath(Device device, PathIterator path) {
        this.path = AWTSWTImageUtils.createPath((PathIterator)path, (Device)device);
    }

    public int getLineStyle() {
        return this.style;
    }

    public int getLineWidth() {
        return this.width;
    }

    public void setStroke(int lineStyle, int lineWidth) {
        this.style = lineStyle;
        this.width = lineWidth;
    }

    public void setFill(Color fillColor) {
        this.fill = fillColor;
    }

    @Override
    public Rectangle getValidArea() {
        if (this.path != null) {
            float[] bounds = new float[4];
            this.path.getBounds(bounds);
            return new Rectangle((int)bounds[0], (int)bounds[1], (int)bounds[2], (int)bounds[3]);
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.path != null) {
            this.path.dispose();
            this.path = null;
        }
        super.setValid(false);
    }

    @Override
    public void setValid(boolean valid) {
        if (!valid) {
            this.dispose();
        } else {
            super.setValid(true);
        }
    }

    public void line(int x1, int y1, int x2, int y2) {
        this.closeShape = true;
        this.closex1 = x1;
        this.closex2 = x2;
        this.closey1 = y1;
        this.closey2 = y2;
    }
}

