/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.commands.draw;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.awt.Color;
import java.awt.Rectangle;
import net.refractions.udig.project.internal.EditManager;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.ui.Drawing;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.styling.Symbolizer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class DrawEditFeatureCommand
extends AbstractDrawCommand {
    ViewportModel model;
    Drawing drawing = Drawing.create();
    Adapter editListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getFeatureID(EditManager.class) == 0) {
                ((ViewportPane)DrawEditFeatureCommand.this.model.getRenderManagerInternal().getMapDisplay()).repaint();
            }
        }
    };
    private boolean doKnots = false;
    private MathTransform mt;
    private boolean errorReported;

    public DrawEditFeatureCommand(IViewportModel model) {
        this.model = (ViewportModel)model;
    }

    public void run(IProgressMonitor monitor) {
        SimpleFeature feature = this.model.getMapInternal().getEditManager().getEditFeature();
        if (feature == null) {
            return;
        }
        EList list = this.model.getMapInternal().getEditManagerInternal().eAdapters();
        if (!list.contains(this.editListener)) {
            list.add(this.editListener);
        }
        MathTransform mt = null;
        mt = this.getMathTransform();
        Symbolizer[] symbs = null;
        symbs = feature.getDefaultGeometry() instanceof Point || feature.getDefaultGeometry() instanceof MultiPoint ? Drawing.getSymbolizers(Point.class, (Color)Color.RED) : Drawing.getSymbolizers(LineString.class, (Color)Color.RED);
        this.drawing.drawFeature(this.graphics, feature, this.model.worldToScreenTransform(), this.doKnots, symbs, mt);
    }

    private MathTransform getMathTransform() {
        if (this.mt == null) {
            try {
                this.mt = this.model.getMapInternal().getEditManagerInternal().getEditLayerInternal().layerToMapTransform();
            }
            catch (Exception exception) {
                this.mt = null;
            }
        }
        return this.mt;
    }

    public void setDrawKnots(boolean doKnots) {
        this.doKnots = doKnots;
    }

    @Override
    public void setValid(boolean valid) {
        super.setValid(valid);
        if (!valid) {
            EList adapters = this.model.getMapInternal().getEditManagerInternal().eAdapters();
            adapters.remove(this.editListener);
        }
    }

    @Override
    public Rectangle getValidArea() {
        SimpleFeature feature = this.getMap().getEditManager().getEditFeature();
        if (feature != null) {
            try {
                ReferencedEnvelope bounds = new ReferencedEnvelope(feature.getBounds()).transform(this.getMap().getViewportModel().getCRS(), true);
                double[] points = new double[]{bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY()};
                this.getMap().getViewportModel().worldToScreenTransform().transform(points, 0, points, 0, 2);
                return new Rectangle((int)points[0], (int)points[1], (int)Math.abs(points[2] - points[0]), (int)Math.abs(points[3] - points[1]));
            }
            catch (TransformException e) {
                if (!this.errorReported) {
                    this.errorReported = true;
                    ProjectUIPlugin.log("error calculating valid area, this will not be reported again", e);
                }
                return null;
            }
            catch (MismatchedDimensionException e) {
                if (!this.errorReported) {
                    this.errorReported = true;
                    ProjectUIPlugin.log("error calculating valid area, this will not be reported again", e);
                }
                return null;
            }
            catch (FactoryException e) {
                if (!this.errorReported) {
                    this.errorReported = true;
                    ProjectUIPlugin.log("error calculating valid area, this will not be reported again", e);
                }
                return null;
            }
        }
        return null;
    }
}

