/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.commands.draw;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.core.runtime.IProgressMonitor;

public class CompositeDrawCommand
extends AbstractDrawCommand {
    private List<IDrawCommand> internalCommands = null;

    public CompositeDrawCommand(IDrawCommand[] commandsArray) {
        this.internalCommands = new ArrayList<IDrawCommand>();
        int i = 0;
        while (i < commandsArray.length) {
            this.internalCommands.add(commandsArray[i]);
            ++i;
        }
    }

    public CompositeDrawCommand(List<? extends IDrawCommand> commandsList) {
        this.internalCommands = new ArrayList<IDrawCommand>(commandsList);
    }

    @Override
    public Rectangle getValidArea() {
        return null;
    }

    @Override
    public void setGraphics(ViewportGraphics graphics, IMapDisplay display) {
        super.setGraphics(graphics, display);
        if (this.internalCommands != null) {
            for (IDrawCommand command : this.internalCommands) {
                command.setGraphics(graphics, display);
            }
        }
    }

    @Override
    public void setValid(boolean valid) {
        super.setValid(valid);
        if (this.internalCommands != null) {
            for (IDrawCommand command : this.internalCommands) {
                command.setValid(valid);
            }
        }
    }

    public void setMap(IMap map) {
        super.setMap(map);
        if (this.internalCommands != null) {
            for (IDrawCommand command : this.internalCommands) {
                command.setMap(map);
            }
        }
    }

    public void run(IProgressMonitor monitor) throws Exception {
        for (IDrawCommand command : this.internalCommands) {
            try {
                if (!command.isValid()) continue;
                command.run(monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

